/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.gui;

import com.clussmanproductions.trafficcontrol.gui.GuiImageList;
import com.clussmanproductions.trafficcontrol.network.PacketHandler;
import com.clussmanproductions.trafficcontrol.network.PacketUpdateSign;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.util.Tuple;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class SignGui
extends GuiScreen {
    SignTileEntity sign;
    GuiImageList list;
    GuiTextField search;
    GuiButtonExt typeButton;
    GuiTextField variant;

    public SignGui(SignTileEntity sign) {
        this.sign = sign;
    }

    public void func_73866_w_() {
        this.list = new GuiImageList(this.field_146294_l - 128, 18, 112, this.field_146295_m - 68, img -> this.onImageClicked((SignTileEntity.Sign)img));
        this.search = new GuiTextField(0, this.field_146289_q, this.field_146294_l - 128, this.field_146295_m - 40, 112, 20);
        this.search.func_146180_a("\u00a73\u00a7oSearch...");
        int leftPanelWidth = this.field_146294_l - 134;
        int leftPanelHorizontalCenter = leftPanelWidth / 2;
        int textWidth = this.field_146289_q.func_78256_a("Type:");
        this.typeButton = new GuiButtonExt(1, leftPanelHorizontalCenter - (203 + textWidth) / 2 + textWidth + 3, 20, this.sign.getFriendlySignName());
        if (this.typeButton.field_146128_h + this.typeButton.field_146120_f > leftPanelWidth) {
            this.typeButton.field_146120_f = leftPanelWidth - this.typeButton.field_146128_h;
        }
        textWidth = this.field_146289_q.func_78256_a("Variant:");
        this.variant = new GuiTextField(2, this.field_146289_q, leftPanelHorizontalCenter - (33 + textWidth) / 2 + textWidth + 3, 50, 30, 20);
        this.variant.func_146180_a(String.valueOf(this.sign.getVariant()));
        this.variant.func_146203_f(3);
        this.field_146292_n.add(this.typeButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.search.func_146194_f();
        this.variant.func_146194_f();
        int leftPanelWidth = this.field_146294_l - 134;
        int leftPanelHorizontalCenter = leftPanelWidth / 2;
        int textWidth = this.field_146289_q.func_78256_a("Type:");
        this.field_146289_q.func_78276_b("Type:", leftPanelHorizontalCenter - (this.typeButton.field_146120_f + textWidth + 3) / 2, 27, 0xFFFFFF);
        textWidth = this.field_146289_q.func_78256_a("Variant:");
        this.field_146289_q.func_78276_b("Variant:", leftPanelHorizontalCenter - (this.variant.field_146218_h + textWidth + 3) / 2, 57, 0xFFFFFF);
        SignTileEntity.Sign currentSign = (SignTileEntity.Sign)SignTileEntity.SIGNS_BY_TYPE_VARIANT.get(new Tuple<Integer, Integer>(this.sign.getType(), this.sign.getVariant()));
        textWidth = this.field_146289_q.func_78256_a("Name: " + currentSign.getName());
        this.field_146289_q.func_78276_b("Name: " + currentSign.getName(), leftPanelHorizontalCenter - textWidth / 2, 73, 0xFFFF00);
        if (currentSign.getNote() != null && !currentSign.getNote().equals("")) {
            String note = "Note: " + currentSign.getNote();
            textWidth = this.field_146289_q.func_78256_a(note);
            if (textWidth > leftPanelWidth) {
                textWidth = leftPanelWidth;
            }
            this.field_146289_q.func_78279_b(note, leftPanelHorizontalCenter - textWidth / 2, this.field_146295_m - 20, textWidth, 0xFFFFFF);
        }
        this.field_146297_k.field_71446_o.func_110577_a(currentSign.getImageResourceLocation());
        int previewWidthHeight = leftPanelWidth;
        int maxPreviewHeight = this.field_146295_m - 105;
        if (previewWidthHeight > maxPreviewHeight) {
            previewWidthHeight = maxPreviewHeight;
        }
        int previewX = leftPanelHorizontalCenter - previewWidthHeight / 2;
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b((double)previewX, 83.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b((double)previewX, (double)(83 + previewWidthHeight), 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        builder.func_181662_b((double)(previewX + previewWidthHeight), (double)(83 + previewWidthHeight), 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b((double)(previewX + previewWidthHeight), 83.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        tess.func_78381_a();
        this.list.draw(mouseX, mouseY, this.field_146289_q, text -> x -> y -> this.func_146283_a((List)text, (int)x, (int)y));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.list.onMouseClick(mouseX, mouseY);
        if (this.search.func_146192_a(mouseX, mouseY, mouseButton) && this.search.func_146179_b().equals("\u00a73\u00a7oSearch...")) {
            this.search.func_146180_a("");
        } else if (this.search.func_146179_b().equals("")) {
            this.search.func_146180_a("\u00a73\u00a7oSearch...");
        }
        this.variant.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.search.func_146201_a(typedChar, keyCode)) {
            this.list.filter(this.search.func_146179_b());
        }
        if (this.variant.func_146201_a(typedChar, keyCode)) {
            int newVariant = 0;
            try {
                newVariant = Integer.parseInt(this.variant.func_146179_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sign.setVariant(newVariant);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.list.onMouseRelease();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.scroll(Integer.signum(Mouse.getDWheel()));
    }

    private void onImageClicked(SignTileEntity.Sign image) {
        this.sign.setType(image.getType());
        this.sign.setVariant(image.getVariant());
        this.typeButton.field_146126_j = this.sign.getFriendlySignName();
        this.variant.func_146180_a(String.valueOf(image.getVariant()));
    }

    public void func_146281_b() {
        super.func_146281_b();
        BlockPos pos = this.sign.func_174877_v();
        PacketUpdateSign updateSign = new PacketUpdateSign();
        updateSign.x = pos.func_177958_n();
        updateSign.y = pos.func_177956_o();
        updateSign.z = pos.func_177952_p();
        updateSign.type = this.sign.getType();
        updateSign.variant = this.sign.getVariant();
        PacketHandler.INSTANCE.sendToServer((IMessage)updateSign);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.typeButton) {
            this.sign.nextType();
            this.typeButton.field_146126_j = this.sign.getFriendlySignName();
            this.variant.func_146180_a(String.valueOf(this.sign.getVariant()));
        }
    }
}

