/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.item;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockBaseTrafficLight;
import com.clussmanproductions.trafficcontrol.item.ItemTrafficLightFrameCapabilityProvider;
import com.clussmanproductions.trafficcontrol.tileentity.BaseTrafficLightTileEntity;
import com.clussmanproductions.trafficcontrol.util.EnumTrafficLightBulbTypes;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BaseItemTrafficLightFrame
extends Item {
    public BaseItemTrafficLightFrame(String name) {
        this.setRegistryName(name);
        this.func_77655_b("trafficcontrol." + name);
        this.func_77625_d(1);
        this.func_77637_a(ModTrafficControl.CREATIVE_TAB);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    protected abstract int getGuiID();

    public abstract int getBulbCount();

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.openGui((Object)ModTrafficControl.instance, this.getGuiID(), worldIn, 0, 0, 0);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemTrafficLightFrameCapabilityProvider(stack, this.getBulbCount());
    }

    public abstract void func_77624_a(ItemStack var1, World var2, List<String> var3, ITooltipFlag var4);

    protected abstract BlockBaseTrafficLight getBaseBlockTrafficLight();

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        worldIn.func_175656_a(pos, this.getBaseBlockTrafficLight().func_176223_P().func_177226_a((IProperty)BlockBaseTrafficLight.FACING, (Comparable)player.func_174811_aO()));
        BaseTrafficLightTileEntity trafficLight = (BaseTrafficLightTileEntity)worldIn.func_175625_s(pos);
        int bulbCount = this.getBulbCount();
        ItemStack heldItem = player.func_184586_b(hand);
        HashMap<Integer, EnumTrafficLightBulbTypes> bulbsBySlot = new HashMap<Integer, EnumTrafficLightBulbTypes>(bulbCount);
        IItemHandler handler = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        HashMap<Integer, Boolean> allowFlashBySlot = new HashMap<Integer, Boolean>();
        for (int i = 0; i < bulbCount; ++i) {
            ItemStack bulbTypeInSlot = handler.getStackInSlot(i);
            if (bulbTypeInSlot == ItemStack.field_190927_a) {
                bulbsBySlot.put(i, null);
            } else {
                bulbsBySlot.put(i, EnumTrafficLightBulbTypes.get(bulbTypeInSlot.func_77960_j()));
            }
            allowFlashBySlot.put(i, this.getAlwaysFlash(heldItem, i));
        }
        trafficLight.setBulbsBySlot(bulbsBySlot);
        trafficLight.setAllowFlashBySlot(allowFlashBySlot);
        player.func_184614_ca().func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = super.getNBTShareTag(stack);
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NBTBase capTag = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)handler, null);
        tag.func_74782_a("ClientInventory", capTag);
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("ClientInventory")) {
            IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().readNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)handler, null, nbt.func_74781_a("ClientInventory"));
        }
    }

    public void handleGuiAlwaysUpdate(ItemStack stack, int slotId, boolean alwaysFlash) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74757_a("always-flash-" + slotId, alwaysFlash);
    }

    public boolean getAlwaysFlash(ItemStack stack, int slotId) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("always-flash-" + slotId)) {
            return true;
        }
        return tag.func_74767_n("always-flash-" + slotId);
    }
}

