/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.item;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelayNE;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelayNW;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelaySE;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelaySW;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelayTopNE;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelayTopNW;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelayTopSE;
import com.clussmanproductions.trafficcontrol.blocks.BlockCrossingRelayTopSW;
import com.clussmanproductions.trafficcontrol.tileentity.RelayTileEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class ItemCrossingRelayBox
extends Item {
    public ItemCrossingRelayBox() {
        this.setRegistryName("crossing_relay_box");
        this.func_77655_b("trafficcontrol.crossing_relay_box");
        this.func_77625_d(1);
        this.func_77637_a(ModTrafficControl.CREATIVE_TAB);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!this.checkSpacing(worldIn, pos, player.func_174811_aO())) {
            return EnumActionResult.SUCCESS;
        }
        this.placeMultiblock(worldIn, pos, player.func_174811_aO());
        if (!player.func_184812_l_()) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            int stackSize = stack.func_190916_E();
            if (stackSize == 1) {
                player.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Blocks.field_150350_a));
            } else {
                stack.func_190920_e(stackSize--);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean checkSpacing(World world, BlockPos pos, EnumFacing facing) {
        int i;
        BlockPos placingPos = pos.func_177972_a(EnumFacing.UP);
        EnumFacing lastFacing = facing;
        boolean success = this.checkSpacing(world, placingPos);
        lastFacing = this.rotateLeft(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        success = success && this.checkSpacing(world, placingPos);
        for (i = 0; i < 2; ++i) {
            lastFacing = this.rotateRight(lastFacing);
            placingPos = placingPos.func_177972_a(lastFacing);
            success = success && this.checkSpacing(world, placingPos);
        }
        placingPos = placingPos.func_177972_a(EnumFacing.UP);
        success = success && this.checkSpacing(world, placingPos);
        for (i = 0; i < 3; ++i) {
            lastFacing = this.rotateRight(lastFacing);
            placingPos = placingPos.func_177972_a(lastFacing);
            success = success && this.checkSpacing(world, placingPos);
        }
        return success;
    }

    private boolean checkSpacing(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    private void placeMultiblock(World world, BlockPos pos, EnumFacing facing) {
        BlockPos placingPos = pos.func_177972_a(EnumFacing.UP);
        EnumFacing lastFacing = facing;
        BlockPos masterTEPos = new BlockPos(placingPos.func_177958_n(), placingPos.func_177956_o(), placingPos.func_177952_p());
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_se.func_176223_P().func_177226_a((IProperty)BlockCrossingRelaySE.FACING, (Comparable)facing));
        RelayTileEntity te = (RelayTileEntity)world.func_175625_s(placingPos);
        te.setMaster();
        lastFacing = this.rotateLeft(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_sw.func_176223_P().func_177226_a((IProperty)BlockCrossingRelaySW.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
        lastFacing = this.rotateRight(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_nw.func_176223_P().func_177226_a((IProperty)BlockCrossingRelayNW.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
        lastFacing = this.rotateRight(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_ne.func_176223_P().func_177226_a((IProperty)BlockCrossingRelayNE.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
        placingPos = placingPos.func_177972_a(EnumFacing.UP);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_top_ne.func_176223_P().func_177226_a((IProperty)BlockCrossingRelayTopNE.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
        lastFacing = this.rotateRight(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_top_se.func_176223_P().func_177226_a((IProperty)BlockCrossingRelayTopSE.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
        lastFacing = this.rotateRight(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_top_sw.func_176223_P().func_177226_a((IProperty)BlockCrossingRelayTopSW.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
        lastFacing = this.rotateRight(lastFacing);
        placingPos = placingPos.func_177972_a(lastFacing);
        world.func_175656_a(placingPos, ModBlocks.crossing_relay_top_nw.func_176223_P().func_177226_a((IProperty)BlockCrossingRelayTopNW.FACING, (Comparable)facing));
        ((RelayTileEntity)world.func_175625_s(placingPos)).setMasterLocation(masterTEPos);
    }

    private EnumFacing rotateLeft(EnumFacing in) {
        switch (in) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    private EnumFacing rotateRight(EnumFacing in) {
        switch (in) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }
}

