/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.item;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockBaseTrafficLight;
import com.clussmanproductions.trafficcontrol.blocks.BlockLampBase;
import com.clussmanproductions.trafficcontrol.blocks.BlockShuntBorder;
import com.clussmanproductions.trafficcontrol.blocks.BlockShuntIsland;
import com.clussmanproductions.trafficcontrol.blocks.BlockTrafficSensorLeft;
import com.clussmanproductions.trafficcontrol.blocks.BlockTrafficSensorStraight;
import com.clussmanproductions.trafficcontrol.tileentity.BaseTrafficLightTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.BellBaseTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.CrossingGateGateTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.RelayTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.ShuntBorderTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.ShuntIslandTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.TrafficLightControlBoxTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.WigWagTileEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class ItemCrossingRelayTuner
extends Item {
    public ItemCrossingRelayTuner() {
        this.setRegistryName("crossing_relay_tuner");
        this.func_77655_b("trafficcontrol.crossing_relay_tuner");
        this.func_77625_d(1);
        this.func_77637_a(ModTrafficControl.CREATIVE_TAB);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity selectedTE = worldIn.func_175625_s(pos);
        if (!this.performPairCheck(player, worldIn, selectedTE)) {
            return EnumActionResult.SUCCESS;
        }
        NBTTagCompound nbt = player.field_71071_by.func_70448_g().func_77978_p();
        int[] relayPosArray = nbt.func_74759_k("pairingpos");
        BlockPos relayPos = new BlockPos(relayPosArray[0], relayPosArray[1], relayPosArray[2]);
        TileEntity pairedTE = worldIn.func_175625_s(relayPos);
        if (selectedTE != null) {
            this.checkUseOnTileEntity(worldIn, selectedTE, pairedTE, player);
        } else {
            this.checkUseOnBlock(worldIn, pos, pairedTE, player);
        }
        return EnumActionResult.SUCCESS;
    }

    private void checkUseOnBlock(World world, BlockPos pos, TileEntity te, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        if (te instanceof RelayTileEntity) {
            RelayTileEntity relay = (RelayTileEntity)te;
            if (state.func_177230_c() instanceof BlockLampBase) {
                if (relay.addOrRemoveCrossingGateLamp(pos)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Crossing Lamps to Relay Box"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Crossing Lamps from Relay Box"));
                }
            }
        }
        if (te instanceof TrafficLightControlBoxTileEntity) {
            TrafficLightControlBoxTileEntity tlBox = (TrafficLightControlBoxTileEntity)te;
            if (state.func_177230_c() instanceof BlockTrafficSensorLeft || state.func_177230_c() instanceof BlockTrafficSensorStraight) {
                if (tlBox.addOrRemoveSensor(pos)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired sensor to Traffic Light Control Box"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired sensor from Traffic Light Control Box"));
                }
            }
        }
    }

    private boolean performPairCheck(EntityPlayer player, World world, TileEntity te) {
        NBTTagCompound nbt = player.field_71071_by.func_70448_g().func_77978_p();
        if (nbt == null || !nbt.func_74764_b("pairingpos")) {
            if (te == null || !(te instanceof RelayTileEntity) && !(te instanceof TrafficLightControlBoxTileEntity)) {
                return false;
            }
            BlockPos relayPos = null;
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            String typeOfPairing = "";
            if (te instanceof RelayTileEntity) {
                RelayTileEntity relay = (RelayTileEntity)te;
                relay = relay.getMaster(world);
                relayPos = relay.func_174877_v();
                this.addTileEntityPosToNBT(nbt, "pairingpos", relay);
                typeOfPairing = "Relay Box";
            }
            if (te instanceof TrafficLightControlBoxTileEntity) {
                TrafficLightControlBoxTileEntity controlBox = (TrafficLightControlBoxTileEntity)te;
                relayPos = controlBox.func_174877_v();
                this.addTileEntityPosToNBT(nbt, "pairingpos", controlBox);
                typeOfPairing = "Traffic Light Control Box";
            }
            player.field_71071_by.func_70448_g().func_77982_d(nbt);
            player.func_145747_a((ITextComponent)new TextComponentString("Started pairing with " + typeOfPairing + " at " + relayPos.func_177958_n() + ", " + relayPos.func_177956_o() + ", " + relayPos.func_177952_p()));
        } else {
            BlockPos pos;
            TileEntity teAtPairingPos;
            int[] pairingpos = nbt.func_74759_k("pairingpos");
            if (te != null && (te instanceof RelayTileEntity || te instanceof TrafficLightControlBoxTileEntity)) {
                BlockPos relayPos = null;
                String typeOfPairing = "";
                if (te instanceof RelayTileEntity) {
                    RelayTileEntity relayTE = (RelayTileEntity)te;
                    relayTE = relayTE.getMaster(world);
                    relayPos = relayTE.func_174877_v();
                    typeOfPairing = "Relay Box";
                }
                if (te instanceof TrafficLightControlBoxTileEntity) {
                    TrafficLightControlBoxTileEntity controlBoxTE = (TrafficLightControlBoxTileEntity)te;
                    relayPos = controlBoxTE.func_174877_v();
                    typeOfPairing = "Traffic Light Control Box";
                }
                nbt.func_82580_o("pairingpos");
                player.func_145747_a((ITextComponent)new TextComponentString("Stopped pairing with " + typeOfPairing + " at " + pairingpos[0] + ", " + pairingpos[1] + ", " + pairingpos[2]));
                if (pairingpos[0] == relayPos.func_177958_n() && pairingpos[1] == relayPos.func_177956_o() && pairingpos[2] == relayPos.func_177952_p()) {
                    player.field_71071_by.func_70448_g().func_77982_d(nbt);
                    return false;
                }
                if (te instanceof RelayTileEntity) {
                    this.addTileEntityPosToNBT(nbt, "pairingpos", ((RelayTileEntity)te).getMaster(world));
                } else {
                    this.addTileEntityPosToNBT(nbt, "pairingpos", te);
                }
                player.field_71071_by.func_70448_g().func_77982_d(nbt);
                pairingpos = nbt.func_74759_k("pairingpos");
                player.func_145747_a((ITextComponent)new TextComponentString("Started pairing with " + typeOfPairing + " at " + pairingpos[0] + ", " + pairingpos[1] + ", " + pairingpos[2]));
            } else if (te != null && ((teAtPairingPos = world.func_175625_s(pos = new BlockPos(pairingpos[0], pairingpos[1], pairingpos[2]))) == null || !(teAtPairingPos instanceof RelayTileEntity) && !(teAtPairingPos instanceof TrafficLightControlBoxTileEntity))) {
                nbt.func_82580_o("pairingpos");
                player.field_71071_by.func_70448_g().func_77982_d(nbt);
                player.func_145747_a((ITextComponent)new TextComponentString("Could not find pair at " + pairingpos[0] + ", " + pairingpos[1] + ", " + pairingpos[2] + ".  Unpaired."));
                return false;
            }
        }
        return true;
    }

    private void addTileEntityPosToNBT(NBTTagCompound nbt, String key, TileEntity te) {
        BlockPos tePos = te.func_174877_v();
        int[] pos = new int[]{tePos.func_177958_n(), tePos.func_177956_o(), tePos.func_177952_p()};
        nbt.func_74783_a(key, pos);
    }

    private void checkUseOnTileEntity(World world, TileEntity te, TileEntity pairedTE, EntityPlayer player) {
        if (pairedTE instanceof RelayTileEntity) {
            RelayTileEntity relay = (RelayTileEntity)pairedTE;
            if (te instanceof CrossingGateGateTileEntity) {
                if (relay.addOrRemoveCrossingGateGate((CrossingGateGateTileEntity)te)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Crossing Gate to Relay Box"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Crossing Gate from Relay Box"));
                }
            }
            if (te instanceof BellBaseTileEntity) {
                if (relay.addOrRemoveBell((BellBaseTileEntity)te)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Bell to Relay Box"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Bell from Relay Box"));
                }
            }
            if (te instanceof WigWagTileEntity) {
                if (relay.addOrRemoveWigWag(te.func_174877_v())) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Wig Wag to Relay Box"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Wig Wag from Relay Box"));
                }
            }
            if (te instanceof ShuntBorderTileEntity) {
                ShuntBorderTileEntity shuntBorderTileEntity = (ShuntBorderTileEntity)te;
                IBlockState borderBlock = world.func_180495_p(te.func_174877_v());
                EnumFacing borderFacing = (EnumFacing)borderBlock.func_177229_b((IProperty)BlockShuntBorder.FACING);
                if (relay.addOrRemoveShuntBorder(shuntBorderTileEntity.getTrackOrigin(), borderFacing)) {
                    shuntBorderTileEntity.addPairedRelayBox(relay.func_174877_v());
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Border Shunt to Relay Box"));
                } else {
                    shuntBorderTileEntity.removePairedRelayBox(relay.func_174877_v());
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Border Shunt from Relay Box"));
                }
            }
            if (te instanceof ShuntIslandTileEntity) {
                ShuntIslandTileEntity shuntIslandTileEntity = (ShuntIslandTileEntity)te;
                IBlockState islandBlock = world.func_180495_p(te.func_174877_v());
                EnumFacing islandFacing = (EnumFacing)islandBlock.func_177229_b((IProperty)BlockShuntIsland.FACING);
                if (relay.addOrRemoveShuntIsland(shuntIslandTileEntity.getTrackOrigin(), islandFacing)) {
                    shuntIslandTileEntity.addPairedRelayBox(relay.func_174877_v());
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Island Shunt to Relay Box"));
                } else {
                    shuntIslandTileEntity.removePairedRelayBox(relay.func_174877_v());
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Island Shunt from Relay Box"));
                }
            }
        }
        if (pairedTE instanceof TrafficLightControlBoxTileEntity) {
            IBlockState state;
            TrafficLightControlBoxTileEntity controlBox = (TrafficLightControlBoxTileEntity)pairedTE;
            if (te instanceof BaseTrafficLightTileEntity && (state = world.func_180495_p(te.func_174877_v())).func_177230_c() instanceof BlockBaseTrafficLight) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBaseTrafficLight.FACING);
                boolean operationResult = false;
                operationResult = facing == EnumFacing.EAST || facing == EnumFacing.WEST ? controlBox.addOrRemoveWestEastTrafficLight(te.func_174877_v()) : controlBox.addOrRemoveNorthSouthTrafficLight(te.func_174877_v());
                if (operationResult) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Paired Traffic Light to Traffic Light Control Box"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unpaired Traffic Light to Traffic Light Control Box"));
                }
            }
        }
    }
}

