/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.scanner;

import com.clussmanproductions.trafficcontrol.Config;
import com.clussmanproductions.trafficcontrol.scanner.IScannerSubscriber;
import com.clussmanproductions.trafficcontrol.scanner.ScanCompleteData;
import com.clussmanproductions.trafficcontrol.scanner.ScanRequest;
import com.clussmanproductions.trafficcontrol.scanner.ScannerData;
import com.clussmanproductions.trafficcontrol.util.ImmersiveRailroadingHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class Scanner {
    private ScannerData _data;
    public static HashMap<Integer, Scanner> ScannersByWorld = new HashMap();
    private ScanSession[] scansInProgress;
    private HashSet<IScannerSubscriber> requestsHandledThisTick = new HashSet();
    private int lastIndex = 0;

    public Scanner(World world) {
        this._data = (ScannerData)world.func_72943_a(ScannerData.class, "TC_scanner_data");
        if (this._data == null) {
            this._data = new ScannerData();
            world.func_72823_a(this._data.field_76190_i, (WorldSavedData)this._data);
        }
        this.scansInProgress = new ScanSession[Config.parallelScans];
        for (int i = 0; i < Config.parallelScans; ++i) {
            this.scansInProgress[i] = new ScanSession();
        }
    }

    public <T extends TileEntity> void subscribe(T subscriber) {
        this._data.addSubscriber(subscriber.func_174877_v());
    }

    public void tick(World world) {
        try {
            if (this._data.getSubscribers().size() == 0) {
                return;
            }
            for (ScanSession scanSession : this.scansInProgress) {
                if (scanSession.getScanSubscriber() == null) {
                    this.tryFindNextSubscriber(scanSession, world);
                }
                if (scanSession.getScanRequest() == null) {
                    scanSession.setScanSubscriber(null);
                    continue;
                }
                ScanRequest request = scanSession.getScanRequest();
                while (scanSession.getBlocksScannedThisSession() < Config.borderTimeout && scanSession.getBlocksScannedThisTick() < Config.borderTick && request != null) {
                    Vec3d lastPosition = scanSession.getLastPosition();
                    Vec3d motion = scanSession.getMotion();
                    if (lastPosition == null) {
                        lastPosition = new Vec3d((Vec3i)request.getStartingPos());
                        motion = new Vec3d(request.getStartDirection().func_176730_m());
                    }
                    Vec3d nextPosition = ImmersiveRailroadingHelper.getNextPosition(lastPosition, motion, world);
                    scanSession.addBlockScannedThisTick();
                    if (nextPosition.equals((Object)lastPosition)) {
                        ScanCompleteData completeData = new ScanCompleteData(request, true, false, false);
                        scanSession.getScanSubscriber().onScanComplete(completeData);
                        if (completeData.getContinueScanningForTileEntity()) {
                            scanSession.popRequest();
                        }
                        if (!completeData.getContinueScanningForTileEntity() || scanSession.getScanRequest() == null) {
                            this.tryFindNextSubscriber(scanSession, world);
                        }
                        request = scanSession.getScanRequest();
                        continue;
                    }
                    motion = new Vec3d(nextPosition.field_72450_a - lastPosition.field_72450_a, nextPosition.field_72448_b - lastPosition.field_72448_b, nextPosition.field_72449_c - lastPosition.field_72449_c);
                    com.clussmanproductions.trafficcontrol.util.Tuple<Boolean, Boolean> trainResultHere = this.checkPosition(nextPosition, motion, world);
                    if (trainResultHere.getFirst().booleanValue()) {
                        scanSession.setFoundTrain(true);
                        scanSession.setTrainMovingTowardsDestination(scanSession.isTrainMovingTowardsDestination() || trainResultHere.getSecond() != false);
                    }
                    boolean whileLoopContinue = false;
                    for (BlockPos endingPos : request.getEndingPositions()) {
                        AxisAlignedBB endingBB = new AxisAlignedBB(endingPos);
                        if (!(endingBB = endingBB.func_72321_a(-1.0, -1.0, -1.0).func_72321_a(1.0, 1.0, 1.0)).func_72318_a(nextPosition)) continue;
                        ScanCompleteData data = new ScanCompleteData(request, false, scanSession.isFoundTrain(), scanSession.isTrainMovingTowardsDestination());
                        scanSession.getScanSubscriber().onScanComplete(data);
                        if (data.getContinueScanningForTileEntity()) {
                            scanSession.popRequest();
                        }
                        if (!data.getContinueScanningForTileEntity() || data.getScanRequest() == null) {
                            this.tryFindNextSubscriber(scanSession, world);
                        }
                        request = scanSession.getScanRequest();
                        whileLoopContinue = true;
                        break;
                    }
                    if (whileLoopContinue) continue;
                    scanSession.setLastPosition(nextPosition);
                    scanSession.setMotion(motion);
                }
                if (request == null && scanSession.getScanSubscriber() != null) {
                    scanSession.getScanSubscriber().onScanRequestsCompleted();
                    this.tryFindNextSubscriber(scanSession, world);
                }
                if (scanSession.getBlocksScannedThisSession() < Config.borderTimeout) continue;
                ScanCompleteData timeout = new ScanCompleteData(request, true, false, false);
                scanSession.getScanSubscriber().onScanComplete(timeout);
                if (timeout.getContinueScanningForTileEntity()) {
                    scanSession.popRequest();
                }
                if (!timeout.getContinueScanningForTileEntity() || scanSession.getScanRequest() == null) {
                    this.tryFindNextSubscriber(scanSession, world);
                }
                request = scanSession.getScanRequest();
            }
            this.requestsHandledThisTick.clear();
            for (ScanSession scanSession : this.scansInProgress) {
                scanSession.resetBlocksScannedThisTick();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void tryFindNextSubscriber(ScanSession scan, World world) {
        ++this.lastIndex;
        if (this.lastIndex >= this._data.getSubscribers().size()) {
            this.lastIndex = 0;
        }
        IScannerSubscriber thisScanSubscriber = null;
        do {
            TileEntity te;
            BlockPos subscriberPos;
            if (world.func_175668_a(subscriberPos = (BlockPos)this._data.getSubscribers().get(this.lastIndex), false) && IScannerSubscriber.class.isAssignableFrom((te = world.func_175625_s(subscriberPos)).getClass()) && (thisScanSubscriber = (IScannerSubscriber)te).getScanRequests().size() != 0) {
                IScannerSubscriber finalThisScanSubscriber = thisScanSubscriber;
                if (!this.requestsHandledThisTick.add(thisScanSubscriber) || Arrays.stream(this.scansInProgress).anyMatch(ss -> ss.getScanSubscriber() == finalThisScanSubscriber)) {
                    thisScanSubscriber = null;
                }
            }
            if (thisScanSubscriber != null) continue;
            ++this.lastIndex;
        } while (this.lastIndex < this._data.getSubscribers().size() && thisScanSubscriber == null);
        scan.setScanSubscriber(thisScanSubscriber);
    }

    private com.clussmanproductions.trafficcontrol.util.Tuple<Boolean, Boolean> checkPosition(Vec3d position, Vec3d motion, World world) {
        Tuple<UUID, Vec3d> moveableRollingStockNearby = ImmersiveRailroadingHelper.getStockNearby(position, world);
        if (moveableRollingStockNearby != null) {
            Vec3d stockVelocity = (Vec3d)moveableRollingStockNearby.func_76340_b();
            if (stockVelocity.field_72450_a == 0.0 && stockVelocity.field_72448_b == 0.0 && stockVelocity.field_72449_c == 0.0) {
                return new com.clussmanproductions.trafficcontrol.util.Tuple<Boolean, Boolean>(true, false);
            }
            EnumFacing stockMovementFacing = EnumFacing.func_176737_a((float)((float)stockVelocity.field_72450_a), (float)((float)stockVelocity.field_72448_b), (float)((float)stockVelocity.field_72449_c));
            EnumFacing motionFacing = EnumFacing.func_176737_a((float)((float)motion.field_72450_a), (float)((float)motion.field_72448_b), (float)((float)motion.field_72449_c));
            boolean trainMovingTowardsDestination = motionFacing.equals((Object)stockMovementFacing);
            return new com.clussmanproductions.trafficcontrol.util.Tuple<Boolean, Boolean>(true, trainMovingTowardsDestination);
        }
        return new com.clussmanproductions.trafficcontrol.util.Tuple<Boolean, Boolean>(false, false);
    }

    private static class ScanSession {
        private IScannerSubscriber scanSubscriber = null;
        private Queue<ScanRequest> scanRequestsToDo;
        private int blocksScannedThisTick = 0;
        private int blocksScannedThisSession = 0;
        private Vec3d lastPosition = null;
        private Vec3d motion = null;
        private boolean foundTrain = false;
        private boolean trainMovingTowardsDestination = false;

        private ScanSession() {
        }

        public IScannerSubscriber getScanSubscriber() {
            return this.scanSubscriber;
        }

        public void setScanSubscriber(IScannerSubscriber scanSubscriber) {
            this.scanSubscriber = scanSubscriber;
            this.scanRequestsToDo = this.scanSubscriber != null ? new LinkedList<ScanRequest>(scanSubscriber.getScanRequests()) : new LinkedList<ScanRequest>();
            this.lastPosition = null;
            this.motion = null;
            this.blocksScannedThisSession = 0;
            this.foundTrain = false;
            this.trainMovingTowardsDestination = false;
        }

        public ScanRequest getScanRequest() {
            return this.scanRequestsToDo.peek();
        }

        public void popRequest() {
            this.scanRequestsToDo.poll();
            this.lastPosition = null;
            this.motion = null;
            this.blocksScannedThisSession = 0;
            this.foundTrain = false;
            this.trainMovingTowardsDestination = false;
        }

        public int getBlocksScannedThisTick() {
            return this.blocksScannedThisTick;
        }

        public void addBlockScannedThisTick() {
            ++this.blocksScannedThisTick;
            ++this.blocksScannedThisSession;
        }

        public void resetBlocksScannedThisTick() {
            this.blocksScannedThisTick = 0;
        }

        public int getBlocksScannedThisSession() {
            return this.blocksScannedThisSession;
        }

        public Vec3d getLastPosition() {
            return this.lastPosition;
        }

        public void setLastPosition(Vec3d lastPosition) {
            this.lastPosition = lastPosition;
        }

        public Vec3d getMotion() {
            return this.motion;
        }

        public void setMotion(Vec3d motion) {
            this.motion = motion;
        }

        public boolean isFoundTrain() {
            return this.foundTrain;
        }

        public void setFoundTrain(boolean foundTrain) {
            this.foundTrain = foundTrain;
        }

        public boolean isTrainMovingTowardsDestination() {
            return this.trainMovingTowardsDestination;
        }

        public void setTrainMovingTowardsDestination(boolean trainMovingTowardsDestination) {
            this.trainMovingTowardsDestination = trainMovingTowardsDestination;
        }
    }
}

