/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.blocks.BlockBaseTrafficLight;
import com.clussmanproductions.trafficcontrol.util.EnumTrafficLightBulbTypes;
import java.util.HashMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class BaseTrafficLightTileEntity
extends TileEntity
implements ITickable {
    private final int BULB_COUNT;
    HashMap<Integer, EnumTrafficLightBulbTypes> bulbsBySlot = new HashMap();
    HashMap<Integer, Boolean> activeBySlot = new HashMap();
    HashMap<Integer, Boolean> flashBySlot = new HashMap();
    HashMap<Integer, Integer> flashTimeBySlot = new HashMap();
    HashMap<Integer, Boolean> flashCurrent = new HashMap();
    HashMap<Integer, Boolean> allowFlashBySlot = new HashMap();
    private int isPigAboveDelay;
    private boolean isPigAbove;

    public BaseTrafficLightTileEntity(int bulbCount) {
        this.BULB_COUNT = bulbCount;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int[] bulbTypes = new int[this.BULB_COUNT];
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            EnumTrafficLightBulbTypes bulbTypeInSlot = this.getBulbTypeBySlot(i);
            bulbTypes[i] = bulbTypeInSlot != null ? bulbTypeInSlot.getIndex() : -1;
            compound.func_74757_a("active" + i, this.getActiveBySlot(i));
            compound.func_74757_a("flash" + i, this.getFlashBySlot(i));
            compound.func_74757_a("allowflash" + i, this.getAllowFlashBySlot(i));
        }
        compound.func_74783_a("bulbTypes", bulbTypes);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bulbsBySlot = new HashMap(this.BULB_COUNT);
        this.activeBySlot = new HashMap(this.BULB_COUNT);
        int[] bulbTypes = compound.func_74759_k("bulbTypes");
        for (int i = 0; i < bulbTypes.length; ++i) {
            this.bulbsBySlot.put(i, EnumTrafficLightBulbTypes.get(bulbTypes[i]));
            this.activeBySlot.put(i, compound.func_74767_n("active" + i));
            this.flashBySlot.put(i, compound.func_74767_n("flash" + i));
            this.allowFlashBySlot.put(i, compound.func_74764_b("allowflash" + i) ? compound.func_74767_n("allowflash" + i) : true);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        int[] bulbTypes = new int[this.BULB_COUNT];
        this.bulbsBySlot.forEach((key, value) -> {
            bulbTypes[key.intValue()] = value != null ? value.getIndex() : -1;
        });
        tag.func_74783_a("bulbTypes", bulbTypes);
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            tag.func_74757_a("active" + i, this.getActiveBySlot(i));
            tag.func_74757_a("flash" + i, this.getFlashBySlot(i));
            tag.func_74757_a("allowflash" + i, this.getAllowFlashBySlot(i));
        }
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        int i;
        super.handleUpdateTag(tag);
        this.bulbsBySlot = new HashMap();
        int[] bulbTypes = tag.func_74759_k("bulbTypes");
        for (i = 0; i < bulbTypes.length; ++i) {
            this.bulbsBySlot.put(i, EnumTrafficLightBulbTypes.get(bulbTypes[i]));
        }
        for (i = 0; i < this.BULB_COUNT; ++i) {
            this.activeBySlot.put(i, tag.func_74767_n("active" + i));
            this.flashBySlot.put(i, tag.func_74767_n("flash" + i));
            this.allowFlashBySlot.put(i, tag.func_74764_b("allowflash" + i) ? tag.func_74767_n("allowflash" + i) : true);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void setBulbsBySlot(HashMap<Integer, EnumTrafficLightBulbTypes> bulbsBySlot) {
        this.bulbsBySlot = bulbsBySlot;
        this.activeBySlot = new HashMap();
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            this.activeBySlot.put(i, false);
        }
        this.func_70296_d();
    }

    public boolean hasBulb(EnumTrafficLightBulbTypes bulbType) {
        return this.bulbsBySlot.containsValue((Object)bulbType);
    }

    public void setActive(EnumTrafficLightBulbTypes bulbType, boolean active, boolean flash) {
        this.bulbsBySlot.forEach((slot, type) -> {
            if (type == bulbType) {
                this.activeBySlot.put((Integer)slot, active);
                this.flashBySlot.put((Integer)slot, flash);
            }
        });
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
    }

    public void powerOff() {
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            this.activeBySlot.put(i, false);
            this.flashBySlot.put(i, false);
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
    }

    public EnumTrafficLightBulbTypes getBulbTypeBySlot(int slot) {
        if (this.bulbsBySlot.containsKey(slot)) {
            return this.bulbsBySlot.get(slot);
        }
        return null;
    }

    public boolean getActiveBySlot(int slot) {
        if (this.activeBySlot.containsKey(slot)) {
            return this.activeBySlot.get(slot);
        }
        return false;
    }

    public boolean getFlashBySlot(int slot) {
        if (this.flashBySlot.containsKey(slot)) {
            return this.flashBySlot.get(slot);
        }
        return false;
    }

    public boolean getFlashCurrentBySlot(int slot) {
        if (this.flashCurrent.containsKey(slot)) {
            return this.flashCurrent.get(slot);
        }
        return true;
    }

    public void setAllowFlashBySlot(HashMap<Integer, Boolean> allowFlashBySlot) {
        this.allowFlashBySlot = new HashMap();
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            if (allowFlashBySlot.containsKey(i)) {
                this.allowFlashBySlot.put(i, allowFlashBySlot.get(i));
                continue;
            }
            this.allowFlashBySlot.put(i, true);
        }
        this.func_70296_d();
    }

    public boolean getAllowFlashBySlot(int slot) {
        if (this.allowFlashBySlot.containsKey(slot)) {
            return this.allowFlashBySlot.get(slot);
        }
        return true;
    }

    public boolean anyActive() {
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            if (!this.getActiveBySlot(i) || this.getFlashBySlot(i) && !this.getFlashCurrentBySlot(i)) continue;
            return true;
        }
        return false;
    }

    public int getYRotation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockBaseTrafficLight)) {
            return 0;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockBaseTrafficLight.FACING)) {
            case EAST: {
                return 270;
            }
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 90;
            }
        }
        return 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.isPigAboveDelay;
        if (this.isPigAboveDelay >= 20) {
            this.isPigAbove = this.field_145850_b.func_72872_a(EntityPig.class, new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177981_b(2)).func_72321_a(0.5, 0.0, 0.5)).size() > 0;
            this.isPigAboveDelay = 0;
        }
        for (int i = 0; i < this.BULB_COUNT; ++i) {
            if (this.getFlashBySlot(i) && this.getAllowFlashBySlot(i)) {
                if (!this.flashTimeBySlot.containsKey(i)) {
                    this.flashTimeBySlot.put(i, 0);
                }
                if (!this.flashCurrent.containsKey(i)) {
                    this.flashCurrent.put(i, false);
                }
                this.flashTimeBySlot.put(i, this.flashTimeBySlot.get(i) + 1);
                if (this.flashTimeBySlot.get(i) <= 20) continue;
                this.flashCurrent.put(i, this.flashCurrent.get(i) == false);
                this.flashTimeBySlot.put(i, 0);
                this.field_145850_b.func_175664_x(this.func_174877_v());
                continue;
            }
            if (!this.getFlashBySlot(i) || this.getAllowFlashBySlot(i)) continue;
            this.flashCurrent.put(i, false);
        }
    }

    public boolean getIsPigAbove() {
        return this.isPigAbove;
    }
}

