/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.util.ILoopableSoundTileEntity;
import com.clussmanproductions.trafficcontrol.util.LoopableTileEntitySound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BellBaseTileEntity
extends TileEntity
implements ILoopableSoundTileEntity {
    private boolean isRinging = false;
    private boolean soundPlaying = false;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isRinging = compound.func_74767_n("isringing");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74757_a("isringing", this.isRinging);
        return nbt;
    }

    public void setIsRinging(boolean ringing) {
        this.isRinging = ringing;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a("ringing", this.isRinging);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.isRinging = tag.func_74767_n("ringing");
        if (this.field_145850_b.field_72995_K) {
            if (this.isRinging) {
                this.handlePlaySound();
            } else {
                this.soundPlaying = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handlePlaySound() {
        if (!this.soundPlaying) {
            LoopableTileEntitySound sound = new LoopableTileEntitySound(this.getSoundEvent(), this, this.field_174879_c, 1.0f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            this.soundPlaying = true;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @Override
    public boolean isDonePlayingSound() {
        return !this.soundPlaying;
    }

    public void onChunkUnload() {
        this.soundPlaying = false;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract SoundEvent getSoundEvent();
}

