/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockLampBase;
import com.clussmanproductions.trafficcontrol.blocks.BlockWigWag;
import com.clussmanproductions.trafficcontrol.scanner.IScannerSubscriber;
import com.clussmanproductions.trafficcontrol.scanner.ScanCompleteData;
import com.clussmanproductions.trafficcontrol.scanner.ScanRequest;
import com.clussmanproductions.trafficcontrol.scanner.Scanner;
import com.clussmanproductions.trafficcontrol.tileentity.BellBaseTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.CrossingGateGateTileEntity;
import com.clussmanproductions.trafficcontrol.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RelayTileEntity
extends TileEntity
implements ITickable,
IScannerSubscriber {
    private boolean isMaster;
    private boolean isPowered;
    private boolean automatedPowerOverride;
    private int masterX;
    private int masterY;
    private int masterZ;
    private boolean alreadyNotifiedGates;
    private int lastFlash = 19;
    private BlockLampBase.EnumState state = BlockLampBase.EnumState.Off;
    private boolean alreadyNotifiedBells;
    private boolean alreadyNotifiedWigWags;
    private ArrayList<BlockPos> crossingLampLocations = new ArrayList();
    private ArrayList<BlockPos> crossingGateLocations = new ArrayList();
    private ArrayList<BlockPos> bellLocations = new ArrayList();
    private ArrayList<BlockPos> wigWagLocations = new ArrayList();
    private ArrayList<Tuple<BlockPos, EnumFacing>> shuntBorderOriginsAndFacing = new ArrayList();
    private ArrayList<Tuple<BlockPos, EnumFacing>> shuntIslandOriginsAndFacing = new ArrayList();
    private HashMap<BlockPos, Integer> invalidCrossingGates = new HashMap();
    private HashMap<BlockPos, Integer> invalidBells = new HashMap();
    private int lastHeartbeat;
    private final UUID islandRequest = UUID.fromString("da2e3487-9fe6-4369-80bc-4b5ce40f0530");
    private final UUID borderRequest = UUID.fromString("c4ba0fb7-3df0-4c18-9edf-491d825899d9");
    long lastMovementWorldTime = 0L;

    public void func_145839_a(NBTTagCompound compound) {
        EnumFacing facing;
        BlockPos pos;
        super.func_145839_a(compound);
        this.isMaster = compound.func_74767_n("ismaster");
        this.isPowered = compound.func_74767_n("ispowered");
        this.masterX = compound.func_74762_e("masterx");
        this.masterY = compound.func_74762_e("mastery");
        this.masterZ = compound.func_74762_e("masterz");
        this.alreadyNotifiedGates = compound.func_74767_n("alreadynotifiedgates");
        this.lastFlash = compound.func_74762_e("lastflash");
        this.state = BlockLampBase.EnumState.getStateByID(compound.func_74762_e("state"));
        this.alreadyNotifiedBells = compound.func_74767_n("alreadynotifiedbells");
        this.fillArrayListFromNBT("lamps", this.crossingLampLocations, compound);
        this.fillArrayListFromNBT("gate", this.crossingGateLocations, compound);
        this.fillArrayListFromNBT("bell", this.bellLocations, compound);
        this.fillArrayListFromNBT("wigwags", this.wigWagLocations, compound);
        int i = 0;
        while (compound.func_74764_b("island_pos_" + i)) {
            pos = BlockPos.func_177969_a((long)compound.func_74763_f("island_pos_" + i));
            facing = EnumFacing.field_82609_l[compound.func_74762_e("island_facing_" + i)];
            this.shuntIslandOriginsAndFacing.add(new Tuple<BlockPos, EnumFacing>(pos, facing));
            ++i;
        }
        i = 0;
        while (compound.func_74764_b("border_pos_" + i)) {
            pos = BlockPos.func_177969_a((long)compound.func_74763_f("border_pos_" + i));
            facing = EnumFacing.field_82609_l[compound.func_74762_e("border_facing_" + i)];
            this.shuntBorderOriginsAndFacing.add(new Tuple<BlockPos, EnumFacing>(pos, facing));
            ++i;
        }
    }

    private void fillArrayListFromNBT(String key, ArrayList<BlockPos> list, NBTTagCompound tag) {
        int i = 0;
        while (tag.func_74764_b(key + i)) {
            int[] blockPos = tag.func_74759_k(key + i);
            BlockPos pos = new BlockPos(blockPos[0], blockPos[1], blockPos[2]);
            list.add(pos);
            ++i;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int i;
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74757_a("ismaster", this.isMaster);
        nbt.func_74757_a("ispowered", this.isPowered);
        nbt.func_74768_a("masterx", this.masterX);
        nbt.func_74768_a("mastery", this.masterY);
        nbt.func_74768_a("masterz", this.masterZ);
        nbt.func_74757_a("alreadynotifiedgates", this.alreadyNotifiedGates);
        nbt.func_74768_a("lastflash", this.lastFlash);
        nbt.func_74768_a("state", this.state.getID());
        nbt.func_74757_a("alreadynotifiedbells", this.alreadyNotifiedBells);
        nbt.func_74757_a("alreadynotifiedwigwags", this.alreadyNotifiedWigWags);
        for (i = 0; i < this.crossingLampLocations.size(); ++i) {
            BlockPos lamps = this.crossingLampLocations.get(i);
            int[] lampPos = new int[]{lamps.func_177958_n(), lamps.func_177956_o(), lamps.func_177952_p()};
            nbt.func_74783_a("lamps" + i, lampPos);
        }
        for (i = 0; i < this.crossingGateLocations.size(); ++i) {
            BlockPos gate = this.crossingGateLocations.get(i);
            int[] gatePos = new int[]{gate.func_177958_n(), gate.func_177956_o(), gate.func_177952_p()};
            nbt.func_74783_a("gate" + i, gatePos);
        }
        for (i = 0; i < this.bellLocations.size(); ++i) {
            BlockPos bell = this.bellLocations.get(i);
            int[] bellPos = new int[]{bell.func_177958_n(), bell.func_177956_o(), bell.func_177952_p()};
            nbt.func_74783_a("bell" + i, bellPos);
        }
        for (i = 0; i < this.wigWagLocations.size(); ++i) {
            BlockPos wigWag = this.wigWagLocations.get(i);
            int[] wigWagPos = new int[]{wigWag.func_177958_n(), wigWag.func_177956_o(), wigWag.func_177952_p()};
            nbt.func_74783_a("wigwags" + i, wigWagPos);
        }
        for (i = 0; i < this.shuntIslandOriginsAndFacing.size(); ++i) {
            Tuple<BlockPos, EnumFacing> island = this.shuntIslandOriginsAndFacing.get(i);
            compound.func_74772_a("island_pos_" + i, island.getFirst().func_177986_g());
            compound.func_74768_a("island_facing_" + i, island.getSecond().func_176745_a());
        }
        for (i = 0; i < this.shuntBorderOriginsAndFacing.size(); ++i) {
            Tuple<BlockPos, EnumFacing> border = this.shuntBorderOriginsAndFacing.get(i);
            compound.func_74772_a("border_pos_" + i, border.getFirst().func_177986_g());
            compound.func_74768_a("border_facing_" + i, border.getSecond().func_176745_a());
        }
        return nbt;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.isMaster) {
            return;
        }
        if (this.lastHeartbeat >= 20) {
            this.alreadyNotifiedBells = false;
            this.alreadyNotifiedGates = false;
            this.alreadyNotifiedWigWags = false;
            this.lastHeartbeat = 0;
        } else {
            ++this.lastHeartbeat;
        }
        boolean markDirty = false;
        if (!(this.alreadyNotifiedBells && this.alreadyNotifiedGates && this.alreadyNotifiedWigWags)) {
            markDirty = true;
        }
        markDirty |= this.notifyGates();
        this.updateLamps();
        markDirty |= this.updateBells();
        markDirty |= this.notifyWigWags();
        if (markDirty |= this.checkRemoveInvalidItems()) {
            this.func_70296_d();
        }
        if (ModTrafficControl.IR_INSTALLED) {
            Scanner.ScannersByWorld.get(this.field_145850_b.field_73011_w.getDimension()).subscribe(this);
        }
    }

    private boolean notifyGates() {
        boolean markDirty = false;
        for (BlockPos gatePos : this.crossingGateLocations) {
            TileEntity te = this.field_145850_b.func_175625_s(gatePos);
            if (!(te instanceof CrossingGateGateTileEntity) || te.func_145837_r()) {
                if (this.invalidCrossingGates.containsKey(gatePos)) {
                    this.invalidCrossingGates.put(gatePos, this.invalidCrossingGates.get(gatePos) + 1);
                    continue;
                }
                this.invalidCrossingGates.put(gatePos, 1);
                continue;
            }
            if (this.invalidCrossingGates.containsKey(gatePos)) {
                this.invalidCrossingGates.remove(gatePos);
            }
            if (this.alreadyNotifiedGates) continue;
            CrossingGateGateTileEntity gate = (CrossingGateGateTileEntity)te;
            gate.setStatus(this.getPowered() ? CrossingGateGateTileEntity.EnumStatuses.Closing : CrossingGateGateTileEntity.EnumStatuses.Opening);
            markDirty = true;
        }
        this.alreadyNotifiedGates = true;
        return markDirty;
    }

    private void updateLamps() {
        if (!this.getPowered() && this.state != BlockLampBase.EnumState.Off) {
            if (this.crossingGateLocations.stream().noneMatch(cgl -> !this.invalidCrossingGates.containsKey(cgl))) {
                this.lastFlash = 19;
                this.state = BlockLampBase.EnumState.Off;
                this.notifyLamps();
                this.func_70296_d();
            } else {
                BlockPos firstValidGate = this.crossingGateLocations.stream().filter(cgl -> !this.invalidCrossingGates.containsKey(cgl)).findFirst().get();
                CrossingGateGateTileEntity gateTE = (CrossingGateGateTileEntity)this.field_145850_b.func_175625_s(firstValidGate);
                if (gateTE.getStatus() == CrossingGateGateTileEntity.EnumStatuses.Open) {
                    this.lastFlash = 19;
                    this.state = BlockLampBase.EnumState.Off;
                    this.notifyLamps();
                    this.func_70296_d();
                }
            }
        } else if (!this.getPowered() && this.state == BlockLampBase.EnumState.Off) {
            return;
        }
        if (this.lastFlash < 20) {
            ++this.lastFlash;
            this.func_70296_d();
            return;
        }
        this.lastFlash = 0;
        this.state = this.state == BlockLampBase.EnumState.Flash2 || this.state == BlockLampBase.EnumState.Off ? BlockLampBase.EnumState.Flash1 : BlockLampBase.EnumState.Flash2;
        this.notifyLamps();
        this.func_70296_d();
    }

    private void notifyLamps() {
        ArrayList<BlockPos> positionsToRemove = new ArrayList<BlockPos>();
        for (BlockPos lampLocation : this.crossingLampLocations) {
            try {
                IBlockState lampState = this.field_145850_b.func_180495_p(lampLocation);
                this.field_145850_b.func_175656_a(lampLocation, lampState.func_177226_a(BlockLampBase.STATE, (Comparable)((Object)this.state)));
            }
            catch (Exception ex) {
                positionsToRemove.add(lampLocation);
            }
        }
        for (BlockPos positionToRemove : positionsToRemove) {
            this.crossingLampLocations.remove(positionToRemove);
            ModTrafficControl.logger.error("Crossing Lamp at " + positionToRemove.func_177958_n() + ", " + positionToRemove.func_177956_o() + ", " + positionToRemove.func_177952_p() + " has been unpaired due to an error");
        }
    }

    private boolean updateBells() {
        boolean markDirty = false;
        for (BlockPos bellPos : this.bellLocations) {
            TileEntity te = this.field_145850_b.func_175625_s(bellPos);
            if (!(te instanceof BellBaseTileEntity) || te.func_145837_r()) {
                if (this.invalidBells.containsKey(bellPos)) {
                    this.invalidBells.put(bellPos, this.invalidBells.get(bellPos) + 1);
                    continue;
                }
                this.invalidBells.put(bellPos, 1);
                continue;
            }
            if (this.invalidBells.containsKey(bellPos)) {
                this.invalidBells.remove(bellPos);
            }
            if (this.alreadyNotifiedBells) continue;
            BellBaseTileEntity bell = (BellBaseTileEntity)te;
            bell.setIsRinging(this.getPowered());
            markDirty = true;
        }
        this.alreadyNotifiedBells = true;
        return markDirty;
    }

    private boolean notifyWigWags() {
        if (!this.alreadyNotifiedWigWags) {
            ArrayList<BlockPos> positionsToRemove = new ArrayList<BlockPos>();
            for (BlockPos pos : this.wigWagLocations) {
                try {
                    IBlockState currentState = this.field_145850_b.func_180495_p(pos);
                    this.field_145850_b.func_175656_a(pos, currentState.func_177226_a((IProperty)BlockWigWag.ACTIVE, (Comparable)Boolean.valueOf(this.getPowered())));
                }
                catch (Exception ex) {
                    positionsToRemove.add(pos);
                }
            }
            for (BlockPos pos : positionsToRemove) {
                this.wigWagLocations.remove(pos);
                ModTrafficControl.logger.error("Wig Wag at " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + " has been unpaired due to an error");
            }
            this.alreadyNotifiedWigWags = true;
            return true;
        }
        return false;
    }

    private boolean checkRemoveInvalidItems() {
        boolean didRemove = false;
        ArrayList<BlockPos> itemsRemoved = new ArrayList<BlockPos>();
        for (BlockPos invalidGate : this.invalidCrossingGates.entrySet().stream().filter(set -> (Integer)set.getValue() > 200).map(set -> (BlockPos)set.getKey()).collect(Collectors.toList())) {
            didRemove = true;
            ModTrafficControl.logger.warn("Crossing Relay at " + this.func_174877_v().toString() + " found that a crossing gate at " + invalidGate.toString() + " did not load after 10 seconds.  It is getting removed from the list of paired items for this relay.");
            this.crossingGateLocations.remove(invalidGate);
            itemsRemoved.add(invalidGate);
        }
        for (BlockPos removed : itemsRemoved) {
            this.invalidCrossingGates.remove(removed);
        }
        itemsRemoved.clear();
        for (BlockPos invalidBell : this.invalidBells.entrySet().stream().filter(set -> (Integer)set.getValue() > 200).map(set -> (BlockPos)set.getKey()).collect(Collectors.toList())) {
            didRemove = true;
            ModTrafficControl.logger.warn("Crossing Relay at " + this.func_174877_v().toString() + " found that a bell at " + invalidBell.toString() + " did not load after 10 seconds.  It is getting removed from the list of paired items for this relay.");
            this.bellLocations.remove(invalidBell);
            itemsRemoved.add(invalidBell);
        }
        for (BlockPos removed : itemsRemoved) {
            this.invalidBells.remove(removed);
        }
        return didRemove;
    }

    public void setMaster() {
        this.isMaster = true;
        this.func_70296_d();
    }

    public void setMasterLocation(BlockPos pos) {
        this.masterX = pos.func_177958_n();
        this.masterY = pos.func_177956_o();
        this.masterZ = pos.func_177952_p();
    }

    public RelayTileEntity getMaster(World world) {
        if (this.isMaster) {
            return this;
        }
        TileEntity master = world.func_175625_s(this.getMasterBlockPos());
        if (master == null || !(master instanceof RelayTileEntity)) {
            return null;
        }
        return (RelayTileEntity)master;
    }

    private BlockPos getMasterBlockPos() {
        return new BlockPos(this.masterX, this.masterY, this.masterZ);
    }

    public boolean addOrRemoveCrossingGateLamp(BlockPos lampPos) {
        BlockPos posToRemove = null;
        for (BlockPos existingLampPos : this.crossingLampLocations) {
            if (!lampPos.equals((Object)existingLampPos)) continue;
            posToRemove = existingLampPos;
            break;
        }
        if (posToRemove != null) {
            this.crossingLampLocations.remove(posToRemove);
            return false;
        }
        this.crossingLampLocations.add(lampPos);
        return true;
    }

    public boolean addOrRemoveCrossingGateGate(CrossingGateGateTileEntity gate) {
        BlockPos posToRemove = null;
        for (BlockPos pos : this.crossingGateLocations) {
            if (!pos.equals((Object)gate.func_174877_v())) continue;
            posToRemove = pos;
            break;
        }
        if (posToRemove != null) {
            this.crossingGateLocations.remove(posToRemove);
            return false;
        }
        this.crossingGateLocations.add(gate.func_174877_v());
        return true;
    }

    public boolean addOrRemoveBell(BellBaseTileEntity bell) {
        BlockPos posToRemove = null;
        for (BlockPos pos : this.bellLocations) {
            if (!pos.equals((Object)bell.func_174877_v())) continue;
            posToRemove = pos;
            break;
        }
        if (posToRemove != null) {
            this.bellLocations.remove(posToRemove);
            return false;
        }
        this.bellLocations.add(bell.func_174877_v());
        return true;
    }

    public boolean addOrRemoveWigWag(BlockPos wigWagPos) {
        if (this.wigWagLocations.contains(wigWagPos)) {
            this.wigWagLocations.remove(wigWagPos);
            return false;
        }
        this.wigWagLocations.add(wigWagPos);
        return true;
    }

    public boolean addOrRemoveShuntBorder(BlockPos trackOrigin, EnumFacing shuntFacing) {
        Tuple<BlockPos, EnumFacing> value = new Tuple<BlockPos, EnumFacing>(trackOrigin, shuntFacing);
        if (this.shuntBorderOriginsAndFacing.contains(value)) {
            this.shuntBorderOriginsAndFacing.remove(value);
            return false;
        }
        this.shuntBorderOriginsAndFacing.add(value);
        return true;
    }

    public boolean addOrRemoveShuntIsland(BlockPos trackOrigin, EnumFacing shuntFacing) {
        Tuple<BlockPos, EnumFacing> value = new Tuple<BlockPos, EnumFacing>(trackOrigin, shuntFacing);
        if (this.shuntIslandOriginsAndFacing.contains(value)) {
            this.shuntIslandOriginsAndFacing.remove(value);
            return false;
        }
        this.shuntIslandOriginsAndFacing.add(value);
        return true;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
        this.alreadyNotifiedGates = false;
        this.alreadyNotifiedBells = false;
        this.alreadyNotifiedWigWags = false;
        this.func_70296_d();
    }

    private boolean getPowered() {
        return this.isPowered || this.automatedPowerOverride;
    }

    @Override
    public List<ScanRequest> getScanRequests() {
        ArrayList<ScanRequest> scanRequestList = new ArrayList<ScanRequest>();
        for (Tuple<BlockPos, EnumFacing> islandOrigin : this.shuntIslandOriginsAndFacing) {
            scanRequestList.add(new ScanRequest(this.islandRequest, islandOrigin.getFirst(), this.shuntIslandOriginsAndFacing.stream().map(tup -> (BlockPos)tup.getFirst()).filter(pos -> !pos.equals(islandOrigin.getFirst())).collect(Collectors.toList()), islandOrigin.getSecond()));
        }
        for (Tuple<BlockPos, EnumFacing> borderOrigin : this.shuntBorderOriginsAndFacing) {
            scanRequestList.add(new ScanRequest(this.borderRequest, borderOrigin.getFirst(), this.shuntIslandOriginsAndFacing.stream().map(tup -> (BlockPos)tup.getFirst()).collect(Collectors.toList()), borderOrigin.getSecond()));
        }
        return scanRequestList;
    }

    @Override
    public void onScanComplete(ScanCompleteData scanCompleteData) {
        UUID scanRequestID = scanCompleteData.getScanRequest().getRequestID();
        if (scanRequestID.equals(this.islandRequest)) {
            if (scanCompleteData.getTrainFound()) {
                if (!this.automatedPowerOverride) {
                    this.alreadyNotifiedBells = false;
                    this.alreadyNotifiedGates = false;
                    this.alreadyNotifiedWigWags = false;
                    this.automatedPowerOverride = true;
                }
                scanCompleteData.cancelScanningForTileEntity();
                return;
            }
        } else {
            if (scanCompleteData.getTimedOut()) {
                return;
            }
            if (scanCompleteData.getTrainFound()) {
                if (scanCompleteData.getTrainMovingTowardsDestination()) {
                    this.lastMovementWorldTime = this.field_145850_b.func_82737_E();
                }
                if (!this.automatedPowerOverride && scanCompleteData.getTrainMovingTowardsDestination()) {
                    this.alreadyNotifiedBells = false;
                    this.alreadyNotifiedGates = false;
                    this.alreadyNotifiedWigWags = false;
                    this.automatedPowerOverride = true;
                }
                if (!this.automatedPowerOverride || scanCompleteData.getTrainMovingTowardsDestination() || this.field_145850_b.func_82737_E() - this.lastMovementWorldTime <= 200L) {
                    scanCompleteData.cancelScanningForTileEntity();
                }
                return;
            }
        }
    }

    @Override
    public void onScanRequestsCompleted() {
        if (this.automatedPowerOverride) {
            this.alreadyNotifiedBells = false;
            this.alreadyNotifiedGates = false;
            this.alreadyNotifiedWigWags = false;
            this.automatedPowerOverride = false;
            return;
        }
    }
}

