/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.tileentity.RelayTileEntity;
import com.clussmanproductions.trafficcontrol.util.ImmersiveRailroadingHelper;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public abstract class ShuntBaseTileEntity
extends TileEntity {
    private BlockPos trackOrigin = new BlockPos(0, -1, 0);
    private ArrayList<BlockPos> relayBoxes = new ArrayList();

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.trackOrigin = this.arrayToBP(compound.func_74759_k("origin"));
        int counter = 0;
        while (compound.func_74764_b("relayBox" + counter)) {
            this.relayBoxes.add(this.arrayToBP(compound.func_74759_k("relayBox" + counter)));
            ++counter;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74783_a("origin", this.bpToArray(this.trackOrigin));
        for (int i = 0; i < this.relayBoxes.size(); ++i) {
            compound.func_74783_a("relayBox" + i, this.bpToArray(this.relayBoxes.get(i)));
        }
        return super.func_189515_b(compound);
    }

    private int[] bpToArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    private BlockPos arrayToBP(int[] array) {
        if (array.length < 3) {
            return new BlockPos(0, -1, 0);
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    protected abstract <T extends IBlockState> Consumer<T> getRelayAddOrRemoveShuntMethod(RelayTileEntity var1);

    public void onBreak(IBlockState state) {
        for (BlockPos pos : this.relayBoxes) {
            TileEntity e = this.field_145850_b.func_175625_s(pos);
            if (!(e instanceof RelayTileEntity)) continue;
            RelayTileEntity rte = (RelayTileEntity)e;
            Consumer<IBlockState> addOrRemoveConsumer = this.getRelayAddOrRemoveShuntMethod(rte);
            addOrRemoveConsumer.accept(state);
        }
    }

    public boolean setOrigin(EnumFacing facing) {
        Vec3d origin = ImmersiveRailroadingHelper.findOrigin(this.func_174877_v(), facing, this.field_145850_b);
        this.trackOrigin = new BlockPos(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
        return this.trackOrigin.func_177956_o() != -1;
    }

    public BlockPos getTrackOrigin() {
        return this.trackOrigin;
    }

    public void addPairedRelayBox(BlockPos relayPos) {
        this.relayBoxes.add(relayPos);
        this.func_70296_d();
    }

    public void removePairedRelayBox(BlockPos relayPos) {
        this.relayBoxes.remove(relayPos);
        this.func_70296_d();
    }
}

