/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.util.Tuple;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SignTileEntity
extends TileEntity {
    private int type = 0;
    private int variant = 0;
    private final int MAXTYPE = 5;
    public static ImmutableMap<Tuple<Integer, Integer>, Sign> SIGNS_BY_TYPE_VARIANT;
    public static ImmutableMap<Integer, Integer> MAX_VARIANTS_BY_TYPE;
    private static boolean signsInitialized;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.type = compound.func_74762_e("type");
        this.variant = compound.func_74762_e("variant");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("type", this.type);
        compound.func_74768_a("variant", this.variant);
        return super.func_189515_b(compound);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setVariant(int variant) {
        if (variant > (Integer)MAX_VARIANTS_BY_TYPE.get((Object)this.getType())) {
            switch (this.getType()) {
                case 0: {
                    variant = 114;
                    break;
                }
                case 1: {
                    variant = 162;
                    break;
                }
                case 2: {
                    variant = 119;
                    break;
                }
                case 3: {
                    variant = 91;
                    break;
                }
                case 4: {
                    variant = 168;
                    break;
                }
                case 5: {
                    variant = 96;
                }
            }
        }
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    public ResourceLocation getTexture() {
        String signName = SignTileEntity.getSignTypeName(this.type);
        String resourceName = "trafficcontrol:textures/blocks/sign/" + signName + "/" + signName + this.variant + ".png";
        return new ResourceLocation(resourceName);
    }

    public static String getSignTypeName(int type) {
        switch (type) {
            case 0: {
                return "circle";
            }
            case 1: {
                return "diamond";
            }
            case 2: {
                return "misc";
            }
            case 3: {
                return "rectangle";
            }
            case 4: {
                return "square";
            }
            case 5: {
                return "triangle";
            }
        }
        return null;
    }

    public static String getBackSignName(int type, int variant) {
        if (type != 2) {
            return SignTileEntity.getSignTypeName(type) + "0";
        }
        if (variant == 0) {
            return "misc0b";
        }
        if (variant >= 1 && variant <= 4 || variant >= 100 && variant <= 101 || variant == 113 || variant == 119) {
            return "misc1b";
        }
        if (variant >= 5 && variant <= 8 || variant >= 117 && variant <= 118) {
            return "misc2b";
        }
        if (variant >= 9 && variant <= 32 || variant >= 76 && variant <= 99 || variant >= 102 && variant <= 105 || variant >= 108 && variant <= 109 || variant == 112 || variant >= 114 && variant <= 116) {
            return "misc3b";
        }
        if (variant >= 33 && variant <= 40 || variant >= 106 && variant <= 107 || variant >= 110 && variant <= 111) {
            return "misc4b";
        }
        if (variant >= 41 && variant <= 45) {
            return "misc5b";
        }
        if (variant >= 46 && variant <= 47) {
            return "misc6b";
        }
        if (variant >= 48 && variant <= 50) {
            return "misc7b";
        }
        return "misc8b";
    }

    public static int getSignTypeByName(String type) {
        switch (type) {
            case "circle": {
                return 0;
            }
            case "diamond": {
                return 1;
            }
            case "misc": {
                return 2;
            }
            case "rectangle": {
                return 3;
            }
            case "square": {
                return 4;
            }
            case "triangle": {
                return 5;
            }
        }
        return 0;
    }

    public String getFriendlySignName() {
        switch (this.type) {
            case 0: {
                return "Circle";
            }
            case 1: {
                return "Diamond";
            }
            case 2: {
                return "Miscellaneous";
            }
            case 3: {
                return "Rectangle";
            }
            case 4: {
                return "Square";
            }
            case 5: {
                return "Triangle";
            }
        }
        return "Unknown";
    }

    public void nextType() {
        this.type = this.type == 5 ? 0 : ++this.type;
        this.variant = 0;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74768_a("type", this.type);
        compound.func_74768_a("variant", this.variant);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.type = tag.func_74762_e("type");
        this.variant = tag.func_74762_e("variant");
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initializeSigns() {
        if (signsInitialized) {
            return;
        }
        try {
            ResourceLocation signJsonRL = new ResourceLocation("trafficcontrol:misc/signs.json");
            InputStream jsonStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(signJsonRL).func_110527_b();
            InputStreamReader streamReader = new InputStreamReader(jsonStream);
            JsonArray jsonArray = new JsonParser().parse((Reader)streamReader).getAsJsonArray();
            Iterator arrayIterator = jsonArray.iterator();
            HashMap<Tuple<Integer, Integer>, Sign> signsbyTypeVariant = new HashMap<Tuple<Integer, Integer>, Sign>();
            HashMap<Integer, Integer> maxVariantsByType = new HashMap<Integer, Integer>();
            while (arrayIterator.hasNext()) {
                int currentMaxVariant;
                JsonElement element = (JsonElement)arrayIterator.next();
                if (!element.isJsonObject()) continue;
                JsonObject obj = element.getAsJsonObject();
                String name = obj.get("name").getAsString();
                String type = obj.get("type").getAsString();
                int typeID = SignTileEntity.getSignTypeByName(type);
                int variant = obj.get("variant").getAsInt();
                if (variant > (currentMaxVariant = maxVariantsByType.getOrDefault(typeID, 0).intValue())) {
                    maxVariantsByType.put(typeID, variant);
                }
                String tooltip = null;
                String note = null;
                if (obj.has("tooltip")) {
                    tooltip = obj.get("tooltip").getAsString();
                }
                if (obj.has("note")) {
                    note = obj.get("note").getAsString();
                }
                if ((note == null || note.equals("")) && tooltip != null && !tooltip.equals("")) {
                    note = tooltip;
                }
                Sign newImage = new Sign(new ResourceLocation("trafficcontrol:textures/blocks/sign/" + type + "/" + type + variant + ".png"), name, typeID, variant, tooltip, note);
                signsbyTypeVariant.put(new Tuple<Integer, Integer>(typeID, variant), newImage);
            }
            SIGNS_BY_TYPE_VARIANT = ImmutableMap.copyOf(signsbyTypeVariant);
            MAX_VARIANTS_BY_TYPE = ImmutableMap.copyOf(maxVariantsByType);
            signsInitialized = true;
        }
        catch (Exception ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to load signs", true);
        }
    }

    static {
        signsInitialized = false;
    }

    public static class Sign {
        private ResourceLocation imageResourceLocation;
        private String name;
        private int type;
        private int variant;
        private String tooltip;
        private String note;

        public Sign(ResourceLocation imageRL, String name, int type, int variant, String toolTip, String note) {
            this.imageResourceLocation = imageRL;
            this.name = name;
            this.type = type;
            this.variant = variant;
            this.tooltip = toolTip;
            this.note = note;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public int getVariant() {
            return this.variant;
        }

        public ResourceLocation getImageResourceLocation() {
            return this.imageResourceLocation;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public String getNote() {
            return this.note;
        }

        public static class TestComparator
        implements Comparator<Tuple<Integer, Integer>> {
            @Override
            public int compare(Tuple<Integer, Integer> arg0, Tuple<Integer, Integer> arg1) {
                if (arg0 == null && arg1 == null) {
                    return 0;
                }
                if (arg0 == null && arg1 != null) {
                    return -1;
                }
                if (arg1 == null && arg0 != null) {
                    return 1;
                }
                if (arg0.getFirst() != arg1.getFirst()) {
                    if (arg0.getFirst() > arg1.getFirst()) {
                        return 1;
                    }
                    return -1;
                }
                if (arg0.getSecond() == arg1.getSecond()) {
                    return 0;
                }
                if (arg0.getSecond() > arg1.getSecond()) {
                    return 1;
                }
                return -1;
            }
        }
    }
}

