/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.blocks.BlockLightSource;
import com.clussmanproductions.trafficcontrol.blocks.BlockStreetLightSingle;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StreetLightSingleTileEntity
extends TileEntity {
    private int[] blockPos1 = new int[]{0, -1, 0};
    private int[] blockPos2 = new int[]{0, -1, 0};

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.blockPos1 = compound.func_74759_k("blockPos1");
        this.blockPos2 = compound.func_74759_k("blockPos2");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74783_a("blockPos1", this.blockPos1);
        compound.func_74783_a("blockPos2", this.blockPos2);
        return super.func_189515_b(compound);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K || this.func_145837_r()) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == ModBlocks.street_light_single && !((Boolean)state.func_177229_b((IProperty)BlockStreetLightSingle.POWERED)).booleanValue()) {
            this.addLightSources();
        }
    }

    private void setBlockPosArray(BlockPos pos) {
        if (this.blockPos1[1] == -1) {
            this.blockPos1 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        } else {
            this.blockPos2 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        }
    }

    private void tryPlaceLightSource(BlockPos pos) {
        IBlockState proposedBlockState = this.field_145850_b.func_180495_p(pos);
        if (proposedBlockState.func_177230_c() != Blocks.field_150350_a && (proposedBlockState = this.field_145850_b.func_180495_p(pos = pos.func_177984_a())).func_177230_c() != Blocks.field_150350_a) {
            proposedBlockState = null;
        }
        if (proposedBlockState != null) {
            this.field_145850_b.func_175656_a(pos, ModBlocks.light_source.func_176223_P());
            this.setBlockPosArray(pos);
        }
    }

    public void removeLightSources() {
        IBlockState state2;
        BlockPos pos2;
        IBlockState state1;
        BlockPos pos1 = this.getBlockPos(1);
        if (pos1 != null && (state1 = this.field_145850_b.func_180495_p(pos1)).func_177230_c() instanceof BlockLightSource) {
            this.field_145850_b.func_175656_a(pos1, Blocks.field_150350_a.func_176223_P());
        }
        if ((pos2 = this.getBlockPos(2)) != null && (state2 = this.field_145850_b.func_180495_p(pos2)).func_177230_c() instanceof BlockLightSource) {
            this.field_145850_b.func_175656_a(pos2, Blocks.field_150350_a.func_176223_P());
        }
    }

    private BlockPos getBlockPos(int index) {
        switch (index) {
            case 1: {
                if (this.blockPos1[1] != -1) {
                    return new BlockPos(this.blockPos1[0], this.blockPos1[1], this.blockPos1[2]);
                }
            }
            case 2: {
                if (this.blockPos2[1] == -1) break;
                return new BlockPos(this.blockPos2[0], this.blockPos2[1], this.blockPos2[2]);
            }
        }
        return null;
    }

    public void addLightSources() {
        IBlockState lampState = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)lampState.func_177229_b((IProperty)BlockStreetLightSingle.FACING);
        switch (facing) {
            case NORTH: {
                BlockPos angle = this.func_174877_v().func_177970_e(2).func_177985_f(2);
                this.tryPlaceLightSource(angle);
                angle = angle.func_177965_g(4);
                this.tryPlaceLightSource(angle);
                break;
            }
            case WEST: {
                BlockPos angle = this.func_174877_v().func_177965_g(2).func_177964_d(2);
                this.tryPlaceLightSource(angle);
                angle = angle.func_177970_e(4);
                this.tryPlaceLightSource(angle);
                break;
            }
            case SOUTH: {
                BlockPos angle = this.func_174877_v().func_177964_d(2).func_177985_f(2);
                this.tryPlaceLightSource(angle);
                angle = angle.func_177965_g(4);
                this.tryPlaceLightSource(angle);
                break;
            }
            case EAST: {
                BlockPos angle = this.func_174877_v().func_177985_f(2).func_177964_d(2);
                this.tryPlaceLightSource(angle);
                angle = angle.func_177970_e(4);
                this.tryPlaceLightSource(angle);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (newSate.func_177230_c() instanceof BlockStreetLightSingle) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newSate);
    }
}

