/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.Config;
import com.clussmanproductions.trafficcontrol.blocks.BlockBaseTrafficLight;
import com.clussmanproductions.trafficcontrol.blocks.BlockTrafficSensorLeft;
import com.clussmanproductions.trafficcontrol.blocks.BlockTrafficSensorStraight;
import com.clussmanproductions.trafficcontrol.tileentity.BaseTrafficLightTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.SyncableTileEntity;
import com.clussmanproductions.trafficcontrol.util.EnumTrafficLightBulbTypes;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TrafficLightControlBoxTileEntity
extends SyncableTileEntity
implements ITickable {
    private ArrayList<BlockPos> westEastLights = new ArrayList();
    private ArrayList<BlockPos> northSouthLights = new ArrayList();
    private HashMap<EnumTrafficLightBulbTypes, Boolean> manualNorthSouthActive = new HashMap();
    private HashMap<EnumTrafficLightBulbTypes, Boolean> manualWestEastActive = new HashMap();
    private HashMap<EnumTrafficLightBulbTypes, Boolean> manualNorthSouthInactive = new HashMap();
    private HashMap<EnumTrafficLightBulbTypes, Boolean> manualWestEastInactive = new HashMap();
    private ArrayList<BlockPos> sensors = new ArrayList();
    private boolean hasSensors = false;
    private boolean powered;
    private Automator automator = null;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int[] blockPosArray;
        BlockPos pos;
        int i;
        for (i = 0; i < this.westEastLights.size(); ++i) {
            pos = this.westEastLights.get(i);
            blockPosArray = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            compound.func_74783_a("westEast" + i, blockPosArray);
        }
        for (i = 0; i < this.northSouthLights.size(); ++i) {
            pos = this.northSouthLights.get(i);
            blockPosArray = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
            compound.func_74783_a("northSouth" + i, blockPosArray);
        }
        compound.func_74757_a("powered", this.powered);
        this.writeManualSettingDictionary(compound, this.manualNorthSouthActive, "manualNorthSouthActive");
        this.writeManualSettingDictionary(compound, this.manualWestEastActive, "manualWestEastActive");
        this.writeManualSettingDictionary(compound, this.manualNorthSouthInactive, "manualNorthSouthInactive");
        this.writeManualSettingDictionary(compound, this.manualWestEastInactive, "manualWestEastInactive");
        for (i = 0; i < this.sensors.size(); ++i) {
            BlockPos sensorPos = this.sensors.get(i);
            compound.func_74772_a("sensor" + i, sensorPos.func_177986_g());
        }
        this.getAutomator().writeNBT(compound);
        return super.func_189515_b(compound);
    }

    private void writeManualSettingDictionary(NBTTagCompound compound, HashMap<EnumTrafficLightBulbTypes, Boolean> map, String prefix) {
        ArrayList<EnumTrafficLightBulbTypes> keyList = new ArrayList<EnumTrafficLightBulbTypes>(map.keySet());
        ArrayList<Boolean> valueList = new ArrayList<Boolean>(map.values());
        for (int i = 0; i < map.size(); ++i) {
            String keyKey = prefix + "-key-" + i;
            String valueKey = prefix + "-value-" + i;
            compound.func_74768_a(keyKey, keyList.get(i).getIndex());
            compound.func_74757_a(valueKey, valueList.get(i).booleanValue());
        }
    }

    private void readManualSettingDictionary(NBTTagCompound compound, HashMap<EnumTrafficLightBulbTypes, Boolean> map, String prefix) {
        map.clear();
        int i = 0;
        while (compound.func_74764_b(prefix + "-key-" + i)) {
            int bulbType = compound.func_74762_e(prefix + "-key-" + i);
            boolean flash = compound.func_74767_n(prefix + "-value-" + i);
            map.put(EnumTrafficLightBulbTypes.get(bulbType), flash);
            ++i;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        BlockPos newBlockPos;
        int[] blockPosArray;
        super.func_145839_a(compound);
        int counter = 0;
        while (compound.func_74764_b("westEast" + counter)) {
            blockPosArray = compound.func_74759_k("westEast" + counter);
            newBlockPos = new BlockPos(blockPosArray[0], blockPosArray[1], blockPosArray[2]);
            this.westEastLights.add(newBlockPos);
            ++counter;
        }
        counter = 0;
        while (compound.func_74764_b("northSouth" + counter)) {
            blockPosArray = compound.func_74759_k("northSouth" + counter);
            newBlockPos = new BlockPos(blockPosArray[0], blockPosArray[1], blockPosArray[2]);
            this.northSouthLights.add(newBlockPos);
            ++counter;
        }
        this.powered = compound.func_74767_n("powered");
        this.readManualSettingDictionary(compound, this.manualNorthSouthActive, "manualNorthSouthActive");
        this.readManualSettingDictionary(compound, this.manualWestEastActive, "manualWestEastActive");
        this.readManualSettingDictionary(compound, this.manualNorthSouthInactive, "manualNorthSouthInactive");
        this.readManualSettingDictionary(compound, this.manualWestEastInactive, "manualWestEastInactive");
        for (String key2 : compound.func_150296_c().stream().filter(key -> key.startsWith("sensor")).collect(Collectors.toSet())) {
            BlockPos sensorPos = BlockPos.func_177969_a((long)compound.func_74763_f(key2));
            this.sensors.add(sensorPos);
        }
        this.getAutomator().readNBT(compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.writeManualSettingDictionary(compound, this.manualNorthSouthActive, "manualNorthSouthActive");
        this.writeManualSettingDictionary(compound, this.manualWestEastActive, "manualWestEastActive");
        this.writeManualSettingDictionary(compound, this.manualNorthSouthInactive, "manualNorthSouthInactive");
        this.writeManualSettingDictionary(compound, this.manualWestEastInactive, "manualWestEastInactive");
        compound.func_74757_a("hasSensors", !this.sensors.isEmpty());
        this.getAutomator().setSyncData(compound);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readManualSettingDictionary(tag, this.manualNorthSouthActive, "manualNorthSouthActive");
        this.readManualSettingDictionary(tag, this.manualWestEastActive, "manualWestEastActive");
        this.readManualSettingDictionary(tag, this.manualNorthSouthInactive, "manualNorthSouthInactive");
        this.readManualSettingDictionary(tag, this.manualWestEastInactive, "manualWestEastInactive");
        this.hasSensors = tag.func_74767_n("hasSensors");
        this.getAutomator().readSyncData(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void setPowered(boolean powered) {
        BaseTrafficLightTileEntity light;
        TileEntity te;
        if (!this.sensors.isEmpty()) {
            return;
        }
        this.powered = powered;
        for (BlockPos westEastLight : this.westEastLights) {
            te = this.field_145850_b.func_175625_s(westEastLight);
            if (!(te instanceof BaseTrafficLightTileEntity)) continue;
            light = (BaseTrafficLightTileEntity)te;
            light.powerOff();
        }
        for (BlockPos northSouthLight : this.northSouthLights) {
            te = this.field_145850_b.func_175625_s(northSouthLight);
            if (!(te instanceof BaseTrafficLightTileEntity)) continue;
            light = (BaseTrafficLightTileEntity)te;
            light.powerOff();
        }
        if (powered) {
            BaseTrafficLightTileEntity light2;
            TileEntity te2;
            for (EnumTrafficLightBulbTypes bulbType : this.manualNorthSouthActive.keySet()) {
                for (BlockPos northSouthLight : this.northSouthLights) {
                    te2 = this.field_145850_b.func_175625_s(northSouthLight);
                    if (!(te2 instanceof BaseTrafficLightTileEntity)) continue;
                    light2 = (BaseTrafficLightTileEntity)te2;
                    light2.setActive(bulbType, true, this.manualNorthSouthActive.get((Object)bulbType));
                }
            }
            for (EnumTrafficLightBulbTypes bulbType : this.manualWestEastActive.keySet()) {
                for (BlockPos westEastLight : this.westEastLights) {
                    te2 = this.field_145850_b.func_175625_s(westEastLight);
                    if (!(te2 instanceof BaseTrafficLightTileEntity)) continue;
                    light2 = (BaseTrafficLightTileEntity)te2;
                    light2.setActive(bulbType, true, this.manualWestEastActive.get((Object)bulbType));
                }
            }
        } else {
            BaseTrafficLightTileEntity light3;
            TileEntity te3;
            for (EnumTrafficLightBulbTypes bulbType : this.manualNorthSouthInactive.keySet()) {
                for (BlockPos northSouthLight : this.northSouthLights) {
                    te3 = this.field_145850_b.func_175625_s(northSouthLight);
                    if (!(te3 instanceof BaseTrafficLightTileEntity)) continue;
                    light3 = (BaseTrafficLightTileEntity)te3;
                    light3.setActive(bulbType, true, this.manualNorthSouthInactive.get((Object)bulbType));
                }
            }
            for (EnumTrafficLightBulbTypes bulbType : this.manualWestEastInactive.keySet()) {
                for (BlockPos westEastLight : this.westEastLights) {
                    te3 = this.field_145850_b.func_175625_s(westEastLight);
                    if (!(te3 instanceof BaseTrafficLightTileEntity)) continue;
                    light3 = (BaseTrafficLightTileEntity)te3;
                    light3.setActive(bulbType, true, this.manualWestEastInactive.get((Object)bulbType));
                }
            }
        }
        this.func_70296_d();
    }

    public boolean addOrRemoveWestEastTrafficLight(BlockPos pos) {
        if (this.westEastLights.contains(pos)) {
            this.westEastLights.remove(pos);
            return false;
        }
        this.westEastLights.add(pos);
        this.func_70296_d();
        return true;
    }

    public boolean addOrRemoveNorthSouthTrafficLight(BlockPos pos) {
        if (this.northSouthLights.contains(pos)) {
            this.northSouthLights.remove(pos);
            return false;
        }
        this.northSouthLights.add(pos);
        this.func_70296_d();
        return true;
    }

    public boolean addOrRemoveSensor(BlockPos pos) {
        if (this.sensors.contains(pos)) {
            this.sensors.remove(pos);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
            return false;
        }
        this.sensors.add(pos);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
        return true;
    }

    public void addRemoveNorthSouthActive(EnumTrafficLightBulbTypes type, boolean flash, boolean add) {
        if (add) {
            this.manualNorthSouthActive.put(type, flash);
        } else if (!add && flash) {
            this.manualNorthSouthActive.put(type, false);
        } else {
            this.manualNorthSouthActive.remove((Object)type);
        }
    }

    public void addRemoveWestEastActive(EnumTrafficLightBulbTypes type, boolean flash, boolean add) {
        if (add) {
            this.manualWestEastActive.put(type, flash);
        } else if (!add && flash) {
            this.manualWestEastActive.put(type, false);
        } else {
            this.manualWestEastActive.remove((Object)type);
        }
    }

    public void addRemoveNorthSouthInactive(EnumTrafficLightBulbTypes type, boolean flash, boolean add) {
        if (add) {
            this.manualNorthSouthInactive.put(type, flash);
        } else if (!add && flash) {
            this.manualNorthSouthInactive.put(type, false);
        } else {
            this.manualNorthSouthInactive.remove((Object)type);
        }
    }

    public void addRemoveWestEastInactive(EnumTrafficLightBulbTypes type, boolean flash, boolean add) {
        if (add) {
            this.manualWestEastInactive.put(type, flash);
        } else if (!add && flash) {
            this.manualWestEastInactive.put(type, false);
        } else {
            this.manualWestEastInactive.remove((Object)type);
        }
    }

    @Override
    public NBTTagCompound getClientToServerUpdateTag() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeManualSettingDictionary(compound, this.manualNorthSouthActive, "manualNorthSouthActive");
        this.writeManualSettingDictionary(compound, this.manualWestEastActive, "manualWestEastActive");
        this.writeManualSettingDictionary(compound, this.manualNorthSouthInactive, "manualNorthSouthInactive");
        this.writeManualSettingDictionary(compound, this.manualWestEastInactive, "manualWestEastInactive");
        this.getAutomator().setSyncData(compound);
        return compound;
    }

    @Override
    public void handleClientToServerUpdateTag(NBTTagCompound compound) {
        this.readManualSettingDictionary(compound, this.manualNorthSouthActive, "manualNorthSouthActive");
        this.readManualSettingDictionary(compound, this.manualWestEastActive, "manualWestEastActive");
        this.readManualSettingDictionary(compound, this.manualNorthSouthInactive, "manualNorthSouthInactive");
        this.readManualSettingDictionary(compound, this.manualWestEastInactive, "manualWestEastInactive");
        this.getAutomator().readSyncData(compound);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
    }

    public boolean hasSpecificNorthSouthManualOption(EnumTrafficLightBulbTypes bulbType, boolean flash, boolean forActive) {
        if (forActive) {
            boolean result = this.manualNorthSouthActive.containsKey((Object)bulbType);
            if (flash) {
                result = result && this.manualNorthSouthActive.get((Object)bulbType) != false;
            }
            return result;
        }
        boolean result = this.manualNorthSouthInactive.containsKey((Object)bulbType);
        if (flash) {
            result = result && this.manualNorthSouthInactive.get((Object)bulbType) != false;
        }
        return result;
    }

    public boolean hasSpecificWestEastManualOption(EnumTrafficLightBulbTypes bulbType, boolean flash, boolean forActive) {
        if (forActive) {
            boolean result = this.manualWestEastActive.containsKey((Object)bulbType);
            if (flash) {
                result = result && this.manualWestEastActive.get((Object)bulbType) != false;
            }
            return result;
        }
        boolean result = this.manualWestEastInactive.containsKey((Object)bulbType);
        if (flash) {
            result = result && this.manualWestEastInactive.get((Object)bulbType) != false;
        }
        return result;
    }

    public boolean getHasSensors() {
        return this.hasSensors;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.sensors.isEmpty()) {
            this.getAutomator().update();
        }
    }

    public Automator getAutomator() {
        if (this.automator == null) {
            this.automator = new Automator();
        }
        return this.automator;
    }

    private static enum Stages {
        Red(0, 0),
        Direction1TurnArrow(1, 1),
        Direction2TurnArrow(2, 1),
        BothTurnArrow(3, 1),
        Direction1TurnArrowYellow(4, 2),
        Direction2TurnArrowYellow(5, 2),
        BothTurnArrowYellow(6, 2),
        Green(7, 3),
        Yellow(8, 4);

        private int priority;
        private int id;

        private Stages(int id, int priority) {
            this.id = id;
            this.priority = priority;
        }

        public static Stages getById(int id) {
            for (Stages stage : Stages.values()) {
                if (stage.id != id) continue;
                return stage;
            }
            return null;
        }
    }

    private static enum RightOfWays {
        NorthSouth(0),
        EastWest(1);

        private int index;

        private RightOfWays(int index) {
            this.index = index;
        }

        public static RightOfWays getbyIndex(int index) {
            for (RightOfWays rightOfWay : RightOfWays.values()) {
                if (rightOfWay.index != index) continue;
                return rightOfWay;
            }
            return null;
        }

        public RightOfWays getNext() {
            RightOfWays newRow = RightOfWays.getbyIndex(this.index + 1);
            if (newRow == null) {
                newRow = RightOfWays.getbyIndex(0);
            }
            return newRow;
        }
    }

    public class Automator {
        private long nextUpdate;
        private boolean hasInitialized = false;
        private final ImmutableList<Class<?>> sensorClasses = ImmutableList.builder().add(BlockTrafficSensorLeft.class).add(BlockTrafficSensorStraight.class).build();
        private final String nbtPrefix = "automated_";
        private Stages lastStage = Stages.Red;
        private RightOfWays lastRightOfWay = RightOfWays.EastWest;
        private double greenMinimum = 10.0;
        private double yellowTime = 3.0;
        private double redTime = 2.0;
        private double arrowMinimum = 5.0;

        public double getGreenMinimum() {
            return this.greenMinimum;
        }

        public void setGreenMinimum(double greenMinimum) {
            this.greenMinimum = greenMinimum;
        }

        public double getYellowTime() {
            return this.yellowTime;
        }

        public void setYellowTime(double yellowTime) {
            this.yellowTime = yellowTime;
        }

        public double getRedTime() {
            return this.redTime;
        }

        public void setRedTime(double redTime) {
            this.redTime = redTime;
        }

        public double getArrowMinimum() {
            return this.arrowMinimum;
        }

        public void setArrowMinimum(double arrowMinimum) {
            this.arrowMinimum = arrowMinimum;
        }

        public void update() {
            if (!this.hasInitialized) {
                this.initialize();
            }
            if (MinecraftServer.func_130071_aq() < this.nextUpdate) {
                return;
            }
            if (this.lastStage == Stages.Red) {
                this.lastRightOfWay = this.lastRightOfWay.getNext();
            }
            SensorCheckResult sensorResults = this.checkSensors(this.lastRightOfWay);
            this.lastStage = this.updateLightsByStage(this.getNextLogicalStage(this.lastStage, this.lastRightOfWay, sensorResults));
            TrafficLightControlBoxTileEntity.this.func_70296_d();
        }

        private void initialize() {
            for (BaseTrafficLightTileEntity te : TrafficLightControlBoxTileEntity.this.northSouthLights.stream().map(bp -> {
                TileEntity teAtPos = TrafficLightControlBoxTileEntity.this.field_145850_b.func_175625_s(bp);
                if (teAtPos instanceof BaseTrafficLightTileEntity) {
                    return (BaseTrafficLightTileEntity)teAtPos;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList())) {
                te.powerOff();
                te.setActive(EnumTrafficLightBulbTypes.Red, true, false);
                te.setActive(EnumTrafficLightBulbTypes.RedArrowLeft, true, false);
            }
            for (BaseTrafficLightTileEntity te : TrafficLightControlBoxTileEntity.this.westEastLights.stream().map(bp -> {
                TileEntity teAtPos = TrafficLightControlBoxTileEntity.this.field_145850_b.func_175625_s(bp);
                if (teAtPos instanceof BaseTrafficLightTileEntity) {
                    return (BaseTrafficLightTileEntity)teAtPos;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList())) {
                te.powerOff();
                te.setActive(EnumTrafficLightBulbTypes.Red, true, false);
                te.setActive(EnumTrafficLightBulbTypes.RedArrowLeft, true, false);
            }
            this.hasInitialized = true;
        }

        private Stages updateLightsByStage(Stages stage) {
            EnumFacing direction2;
            EnumFacing direction1;
            List trafficLightsForRightOfWay;
            if (this.lastRightOfWay == RightOfWays.NorthSouth) {
                trafficLightsForRightOfWay = TrafficLightControlBoxTileEntity.this.northSouthLights.stream().map(p -> {
                    TileEntity te = TrafficLightControlBoxTileEntity.this.field_145850_b.func_175625_s(p);
                    if (te instanceof BaseTrafficLightTileEntity) {
                        return (BaseTrafficLightTileEntity)te;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                direction1 = EnumFacing.NORTH;
                direction2 = EnumFacing.SOUTH;
            } else {
                trafficLightsForRightOfWay = TrafficLightControlBoxTileEntity.this.westEastLights.stream().map(p -> {
                    TileEntity te = TrafficLightControlBoxTileEntity.this.field_145850_b.func_175625_s(p);
                    if (te instanceof BaseTrafficLightTileEntity) {
                        return (BaseTrafficLightTileEntity)te;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                direction1 = EnumFacing.EAST;
                direction2 = EnumFacing.WEST;
            }
            switch (stage) {
                case Red: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.Red, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.RedArrowLeft, true, false);
                    });
                    return Stages.Red;
                }
                case Direction1TurnArrow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        IBlockState tlBs = TrafficLightControlBoxTileEntity.this.field_145850_b.func_180495_p(tl.func_174877_v());
                        if (!((EnumFacing)tlBs.func_177229_b((IProperty)BlockBaseTrafficLight.FACING)).equals((Object)direction1)) {
                            return;
                        }
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.GreenArrowLeft, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.Green, true, false);
                    });
                    return Stages.Direction1TurnArrow;
                }
                case Direction2TurnArrow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        IBlockState tlBs = TrafficLightControlBoxTileEntity.this.field_145850_b.func_180495_p(tl.func_174877_v());
                        if (!((EnumFacing)tlBs.func_177229_b((IProperty)BlockBaseTrafficLight.FACING)).equals((Object)direction2)) {
                            return;
                        }
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.GreenArrowLeft, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.Green, true, false);
                    });
                    return Stages.Direction2TurnArrow;
                }
                case BothTurnArrow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.Red, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.GreenArrowLeft, true, false);
                    });
                    return Stages.BothTurnArrow;
                }
                case Direction1TurnArrowYellow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        IBlockState tlBs = TrafficLightControlBoxTileEntity.this.field_145850_b.func_180495_p(tl.func_174877_v());
                        if (!((EnumFacing)tlBs.func_177229_b((IProperty)BlockBaseTrafficLight.FACING)).equals((Object)direction1)) {
                            return;
                        }
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.YellowArrowLeft, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.Green, true, false);
                    });
                    return Stages.Direction1TurnArrowYellow;
                }
                case Direction2TurnArrowYellow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        IBlockState tlBs = TrafficLightControlBoxTileEntity.this.field_145850_b.func_180495_p(tl.func_174877_v());
                        if (!((EnumFacing)tlBs.func_177229_b((IProperty)BlockBaseTrafficLight.FACING)).equals((Object)direction2)) {
                            return;
                        }
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.YellowArrowLeft, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.Green, true, false);
                    });
                    return Stages.Direction2TurnArrowYellow;
                }
                case BothTurnArrowYellow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.Red, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.YellowArrowLeft, true, false);
                    });
                    return Stages.BothTurnArrowYellow;
                }
                case Yellow: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.YellowArrowLeft, true, false);
                        tl.setActive(EnumTrafficLightBulbTypes.Yellow, true, false);
                    });
                    return Stages.Yellow;
                }
                case Green: {
                    trafficLightsForRightOfWay.stream().forEach(tl -> {
                        tl.powerOff();
                        tl.setActive(EnumTrafficLightBulbTypes.YellowArrowLeft, true, true);
                        tl.setActive(EnumTrafficLightBulbTypes.Green, true, false);
                    });
                    return Stages.Green;
                }
            }
            return stage;
        }

        public void readNBT(NBTTagCompound nbt) {
            this.lastStage = Stages.getById(nbt.func_74762_e(this.getNbtKey("lastStage")));
            this.lastRightOfWay = RightOfWays.getbyIndex(nbt.func_74762_e(this.getNbtKey("lastRightOfWay")));
            this.readSyncData(nbt);
        }

        public void writeNBT(NBTTagCompound nbt) {
            nbt.func_74768_a(this.getNbtKey("lastStage"), this.lastStage.id);
            nbt.func_74768_a(this.getNbtKey("lastRightOfWay"), this.lastRightOfWay.index);
            this.setSyncData(nbt);
        }

        public void readSyncData(NBTTagCompound nbt) {
            this.greenMinimum = nbt.func_74769_h(this.getNbtKey("greenMinimum"));
            this.yellowTime = nbt.func_74769_h(this.getNbtKey("yellowTime"));
            this.redTime = nbt.func_74769_h(this.getNbtKey("redTime"));
            this.arrowMinimum = nbt.func_74769_h(this.getNbtKey("arrowMinimum"));
        }

        public void setSyncData(NBTTagCompound nbt) {
            nbt.func_74780_a(this.getNbtKey("greenMinimum"), this.greenMinimum);
            nbt.func_74780_a(this.getNbtKey("yellowTime"), this.yellowTime);
            nbt.func_74780_a(this.getNbtKey("redTime"), this.redTime);
            nbt.func_74780_a(this.getNbtKey("arrowMinimum"), this.arrowMinimum);
        }

        private String getNbtKey(String key) {
            return "automated_" + key;
        }

        private SensorCheckResult checkSensors(RightOfWays rightOfWay) {
            EnumFacing direction1 = rightOfWay == RightOfWays.NorthSouth ? EnumFacing.NORTH : EnumFacing.EAST;
            EnumFacing direction2 = rightOfWay == RightOfWays.NorthSouth ? EnumFacing.SOUTH : EnumFacing.WEST;
            ArrayList<BlockPos> invalidSensors = new ArrayList<BlockPos>();
            SensorCheckResult result = new SensorCheckResult();
            for (BlockPos sensePos : TrafficLightControlBoxTileEntity.this.sensors) {
                boolean isTripped;
                EnumFacing currentFacing;
                IBlockState senseState = TrafficLightControlBoxTileEntity.this.field_145850_b.func_180495_p(sensePos);
                if (!this.sensorClasses.contains(senseState.func_177230_c().getClass())) {
                    invalidSensors.add(sensePos);
                    continue;
                }
                boolean isStraight = true;
                if (senseState.func_177230_c() instanceof BlockTrafficSensorLeft) {
                    currentFacing = (EnumFacing)senseState.func_177229_b((IProperty)BlockTrafficSensorLeft.FACING);
                    isStraight = false;
                } else {
                    currentFacing = (EnumFacing)senseState.func_177229_b((IProperty)BlockTrafficSensorStraight.FACING);
                }
                if (!currentFacing.equals((Object)direction1) && !currentFacing.equals((Object)direction2) || isStraight && currentFacing.equals((Object)direction1) && result.Direction1Sensor || isStraight && currentFacing.equals((Object)direction2) && result.Direction2Sensor || !isStraight && currentFacing.equals((Object)direction1) && result.Direction1SensorLeft || !isStraight && currentFacing.equals((Object)direction2) && result.Direction2SensorLeft || !(isTripped = TrafficLightControlBoxTileEntity.this.field_145850_b.func_72839_b(null, new AxisAlignedBB(sensePos).func_72321_a(-1.0, (double)Config.sensorScanHeight, 1.0)).stream().anyMatch(e -> !(e instanceof EntityPlayerMP) && Arrays.stream(Config.sensorClasses).anyMatch(eName -> {
                    for (Class<?> nextClass = e.getClass(); nextClass != null; nextClass = nextClass.getSuperclass()) {
                        if (!eName.equals(nextClass.getName())) continue;
                        return true;
                    }
                    return false;
                })))) continue;
                this.setSensorCheckResults(isStraight, currentFacing.equals((Object)direction1), result);
            }
            for (BlockPos invalidSensor : invalidSensors) {
                TrafficLightControlBoxTileEntity.this.sensors.remove(invalidSensor);
            }
            return result;
        }

        private void setSensorCheckResults(boolean isStraight, boolean isDirection1, SensorCheckResult results) {
            if (isStraight && isDirection1) {
                results.Direction1Sensor = true;
            } else if (isStraight && !isDirection1) {
                results.Direction2Sensor = true;
            } else if (!isStraight && isDirection1) {
                results.Direction1SensorLeft = true;
            } else {
                results.Direction2SensorLeft = true;
            }
        }

        private Stages getNextLogicalStage(Stages currentStage, RightOfWays currentRightOfWay, SensorCheckResult sensorResult) {
            switch (currentStage) {
                case Red: {
                    if (sensorResult.Direction1SensorLeft && sensorResult.Direction2SensorLeft) {
                        this.setNextUpdate(this.arrowMinimum);
                        return Stages.BothTurnArrow;
                    }
                    if (sensorResult.Direction1SensorLeft) {
                        this.setNextUpdate(this.arrowMinimum);
                        return Stages.Direction1TurnArrow;
                    }
                    if (sensorResult.Direction2SensorLeft) {
                        this.setNextUpdate(this.arrowMinimum);
                        return Stages.Direction2TurnArrow;
                    }
                    this.setNextUpdate(this.greenMinimum);
                    return Stages.Green;
                }
                case BothTurnArrow: {
                    this.setNextUpdate(this.yellowTime);
                    return Stages.BothTurnArrowYellow;
                }
                case BothTurnArrowYellow: {
                    this.setNextUpdate(this.greenMinimum);
                    return Stages.Green;
                }
                case Direction1TurnArrow: {
                    this.setNextUpdate(this.yellowTime);
                    return Stages.Direction1TurnArrowYellow;
                }
                case Direction1TurnArrowYellow: {
                    this.setNextUpdate(this.greenMinimum);
                    return Stages.Green;
                }
                case Direction2TurnArrow: {
                    this.setNextUpdate(this.yellowTime);
                    return Stages.Direction2TurnArrowYellow;
                }
                case Direction2TurnArrowYellow: {
                    this.setNextUpdate(this.greenMinimum);
                    return Stages.Green;
                }
                case Green: {
                    SensorCheckResult crossSensorCheck = this.checkSensors(currentRightOfWay.getNext());
                    if (crossSensorCheck.Direction1Sensor || crossSensorCheck.Direction1SensorLeft || crossSensorCheck.Direction2Sensor || crossSensorCheck.Direction2SensorLeft) {
                        this.setNextUpdate(this.yellowTime);
                        return Stages.Yellow;
                    }
                    this.setNextUpdate(this.yellowTime);
                    return Stages.Green;
                }
                case Yellow: {
                    this.setNextUpdate(this.redTime);
                    return Stages.Red;
                }
            }
            return null;
        }

        private void setNextUpdate(double secondsIntoFuture) {
            this.nextUpdate = MinecraftServer.func_130071_aq() + (long)(secondsIntoFuture * 1000.0);
        }

        private class SensorCheckResult {
            public boolean Direction1Sensor;
            public boolean Direction2Sensor;
            public boolean Direction1SensorLeft;
            public boolean Direction2SensorLeft;

            private SensorCheckResult() {
            }
        }
    }
}

