/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity.render;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.ResourceLocation;

public class TESRHelper {

    public static class TextureInfo {
        ResourceLocation texture;
        double startX;
        double startY;
        double endX;
        double endY;

        public TextureInfo(ResourceLocation texture, double startX, double startY, double endX, double endY) {
            this.texture = texture;
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
        }

        public double getConvertedStartX() {
            return this.startX / 16.0;
        }

        public double getConvertedStartY() {
            return this.startY / 16.0;
        }

        public double getConvertedEndX() {
            return this.endX / 16.0;
        }

        public double getConvertedEndY() {
            return this.endY / 16.0;
        }
    }

    public static class TextureInfoCollection {
        TextureInfo southFace;
        TextureInfo upFace;
        TextureInfo northFace;
        TextureInfo downFace;
        TextureInfo eastFace;
        TextureInfo westFace;

        public TextureInfoCollection(TextureInfo southFace, TextureInfo upFace, TextureInfo northFace, TextureInfo downFace, TextureInfo eastFace, TextureInfo westFace) {
            this.southFace = southFace;
            this.upFace = upFace;
            this.northFace = northFace;
            this.downFace = downFace;
            this.eastFace = eastFace;
            this.westFace = westFace;
        }

        public TextureInfo getSouthFace() {
            return this.southFace;
        }

        public TextureInfo getUpFace() {
            return this.upFace;
        }

        public TextureInfo getNorthFace() {
            return this.northFace;
        }

        public TextureInfo getDownFace() {
            return this.downFace;
        }

        public TextureInfo getEastFace() {
            return this.eastFace;
        }

        public TextureInfo getWestFace() {
            return this.westFace;
        }
    }

    public static class Box {
        private double x;
        private double y;
        private double z;
        private double width;
        private double height;
        private double depth;
        private TextureInfoCollection textureInfoCollection;

        public Box(double x, double y, double z, double width, double height, double depth, TextureInfoCollection textureInfoCollection) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.width = width;
            this.height = height;
            this.depth = depth;
            this.textureInfoCollection = textureInfoCollection;
        }

        public void render(BufferBuilder builder, Consumer<ResourceLocation> bindTexture) {
            double[][] vertexPoints = this.getVertexPoints();
            int index = 0;
            int count = 0;
            ResourceLocation lastResourceLocation = null;
            for (double[] vertexPoint : vertexPoints) {
                TextureInfo info = this.getTextureInfo(index);
                if (info.texture != lastResourceLocation) {
                    lastResourceLocation = info.texture;
                    bindTexture.accept(lastResourceLocation);
                }
                double uvX = 0.0;
                double uvY = 0.0;
                switch (count) {
                    case 0: {
                        uvX = info.getConvertedEndX();
                        uvY = info.getConvertedEndY();
                        break;
                    }
                    case 1: {
                        uvX = info.getConvertedEndX();
                        uvY = info.getConvertedStartY();
                        break;
                    }
                    case 2: {
                        uvX = info.getConvertedStartX();
                        uvY = info.getConvertedStartY();
                        break;
                    }
                    case 3: {
                        uvX = info.getConvertedStartX();
                        uvY = info.getConvertedEndY();
                    }
                }
                builder.func_181662_b(vertexPoint[0], vertexPoint[1], vertexPoint[2]).func_187315_a(uvX, uvY).func_181675_d();
                if (++count < 4) continue;
                ++index;
                count = 0;
            }
        }

        private TextureInfo getTextureInfo(int count) {
            switch (count) {
                case 0: {
                    return this.textureInfoCollection.northFace;
                }
                case 1: {
                    return this.textureInfoCollection.upFace;
                }
                case 2: {
                    return this.textureInfoCollection.southFace;
                }
                case 3: {
                    return this.textureInfoCollection.downFace;
                }
                case 4: {
                    return this.textureInfoCollection.eastFace;
                }
                case 5: {
                    return this.textureInfoCollection.westFace;
                }
            }
            return null;
        }

        private double[][] getVertexPoints() {
            double convertedX = this.x;
            double convertedY = this.y;
            double convertedZ = this.z;
            double convertedWidth = this.width;
            double convertedHeight = this.height;
            double convertedDepth = this.depth;
            return new double[][]{{convertedX + convertedWidth, convertedY, convertedZ}, {convertedX + convertedWidth, convertedY + convertedHeight, convertedZ}, {convertedX, convertedY + convertedHeight, convertedZ}, {convertedX, convertedY, convertedZ}, {convertedX + convertedWidth, convertedY + convertedHeight, convertedZ}, {convertedX + convertedWidth, convertedY + convertedHeight, convertedZ + convertedDepth}, {convertedX, convertedY + convertedHeight, convertedZ + convertedDepth}, {convertedX, convertedY + convertedHeight, convertedZ}, {convertedX, convertedY, convertedZ + convertedDepth}, {convertedX, convertedY + convertedHeight, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY + convertedHeight, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY, convertedZ}, {convertedX, convertedY, convertedZ}, {convertedX, convertedY, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY + convertedHeight, convertedZ + convertedDepth}, {convertedX + convertedWidth, convertedY + convertedHeight, convertedZ}, {convertedX + convertedWidth, convertedY, convertedZ}, {convertedX, convertedY, convertedZ}, {convertedX, convertedY + convertedHeight, convertedZ}, {convertedX, convertedY + convertedHeight, convertedZ + convertedDepth}, {convertedX, convertedY, convertedZ + convertedDepth}};
        }
    }
}

