/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.tp.minecraft;

import com.google.common.collect.Lists;
import dev.buildtool.tp.PreviewEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CrossbowProjectilePreview
extends Entity
implements PreviewEntity<AbstractArrowEntity> {
    public CrossbowProjectilePreview(World worldIn) {
        super(EntityType.field_200790_d, worldIn);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack crossbow) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = crossbow.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    private static AbstractArrowEntity createArrow(World worldIn, LivingEntity shooter, ItemStack crossbow, ItemStack ammo) {
        ArrowItem arrowitem = (ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, ammo, shooter);
        if (shooter instanceof PlayerEntity) {
            abstractarrowentity.func_70243_d(true);
        }
        abstractarrowentity.func_213869_a(SoundEvents.field_219609_bA);
        abstractarrowentity.func_213865_o(true);
        return abstractarrowentity;
    }

    @Override
    public List<AbstractArrowEntity> initializeEntities(PlayerEntity player, ItemStack associatedItem) {
        if (associatedItem.func_77973_b() instanceof CrossbowItem && CrossbowItem.func_220012_d((ItemStack)associatedItem)) {
            List<ItemStack> allProjectiles = CrossbowProjectilePreview.getChargedProjectiles(associatedItem);
            ArrayList<AbstractArrowEntity> abstractArrowEntities = new ArrayList<AbstractArrowEntity>(3);
            for (int i = 0; i < allProjectiles.size(); ++i) {
                ItemStack itemStack = allProjectiles.get(i);
                if (!(itemStack.func_77973_b() instanceof ArrowItem)) continue;
                AbstractArrowEntity abstractArrowEntity = CrossbowProjectilePreview.createArrow(this.field_70170_p, (LivingEntity)player, associatedItem, new ItemStack((IItemProvider)Items.field_151032_g));
                Vector3d vec3d1 = player.func_213286_i(1.0f);
                float angle = 0.0f;
                if (i == 1) {
                    angle = -10.0f;
                } else if (i == 2) {
                    angle = 10.0f;
                }
                Quaternion quaternion = new Quaternion(new Vector3f(vec3d1), angle, true);
                Vector3d vec3d = player.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vec3d);
                vector3f.func_214905_a(quaternion);
                float velocity = 3.15f;
                abstractArrowEntity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, 0.0f);
                abstractArrowEntities.add(abstractArrowEntity);
            }
            return abstractArrowEntities;
        }
        return null;
    }

    @Override
    public void simulateShot(AbstractArrowEntity simulatedEntity) {
        Vector3d vec3d2;
        Vector3d vec3d1;
        BlockRayTraceResult raytraceresult;
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        boolean flag = simulatedEntity.func_203047_q();
        Vector3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)CrossbowProjectilePreview.func_213296_b((Vector3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()))) continue;
                this.func_70106_y();
                return;
            }
        }
        if ((raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1 = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), vec3d2 = vec3d1.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS) {
            vec3d2 = raytraceresult.func_216347_e();
        }
        while (this.func_70089_S()) {
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)vec3d, (Vector3d)vec3d2, (AxisAlignedBB)simulatedEntity.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !p_213871_1_.func_175149_v() && p_213871_1_.func_70089_S() && p_213871_1_.func_70067_L() && p_213871_1_ != simulatedEntity.func_234616_v_());
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                Entity entity1 = simulatedEntity.func_234616_v_();
                if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && !flag) {
                this.field_70160_al = true;
            }
            if (entityraytraceresult == null || simulatedEntity.func_213874_s() <= 0) break;
            raytraceresult = null;
        }
        vec3d = this.func_213322_ci();
        double d1 = vec3d.field_72450_a;
        double d2 = vec3d.field_72448_b;
        double d0 = vec3d.field_72449_c;
        this.func_70107_b(this.func_226277_ct_() + d1, this.func_226278_cu_() + d2, this.func_226281_cx_() + d0);
        float f4 = MathHelper.func_76133_a((double)CrossbowProjectilePreview.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d1), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        float f1 = 0.99f;
        if (this.func_70090_H()) {
            f1 = 0.6f;
        }
        this.func_213317_d(vec3d.func_186678_a((double)f1));
        if (!this.func_189652_ae() && !flag) {
            Vector3d vec3d3 = this.func_213322_ci();
            this.func_213293_j(vec3d3.field_72450_a, vec3d3.field_72448_b - (double)0.05f, vec3d3.field_72449_c);
        }
        this.func_145775_I();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

