/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import trapcraft.block.tileentity.BearTrapTileEntity;

public class BearTrapBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty TRIGGERED = BooleanProperty.func_177716_a((String)"triggered");

    public BearTrapBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_226896_b_().func_200948_a(2.0f, 2.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            BearTrapTileEntity bearTrap = (BearTrapTileEntity)worldIn.func_175625_s(pos);
            if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue() && !bearTrap.hasTrappedEntity()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext selectionContext) {
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new BearTrapTileEntity();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue()) {
            return;
        }
        if (entity instanceof PlayerEntity || !(entity instanceof MobEntity)) {
            return;
        }
        MobEntity livingEntity = (MobEntity)entity;
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        BearTrapTileEntity bearTrap = (BearTrapTileEntity)world.func_175625_s(pos);
        bearTrap.setTrappedEntity(livingEntity);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)TRIGGERED) != false ? 15 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TRIGGERED, WATERLOGGED});
    }

    public boolean func_149744_f(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TRIGGERED);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        if (!blockState.func_185897_m()) {
            return 0;
        }
        return 15;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction side) {
        return side == Direction.UP ? blockState.func_185911_a(blockReader, pos, side) : 0;
    }
}

