/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import trapcraft.block.tileentity.FanTileEntity;

public class FanBlock
extends ContainerBlock {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public FanBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 2.0f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.WEST)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new FanTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d().func_176734_d())).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, POWERED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            this.updateFanState(state, worldIn, pos);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.updateFanState(state, worldIn, pos);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            this.updateFanState(state, worldIn, pos);
        }
    }

    private void updateFanState(BlockState state, World worldIn, BlockPos pos) {
        boolean flag = worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }
}

