/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mod.grimmauld.windowlogging.WindowInABlockTileEntity;
import mod.grimmauld.windowlogging.WrappedBakedModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WindowInABlockModel
extends WrappedBakedModel {
    public WindowInABlockModel(IBakedModel original) {
        super(original);
    }

    private static void fightZfighting(BakedQuad q) {
        int[] data = q.func_178209_a();
        Vec3i vec = q.func_178210_d().func_176730_m();
        int dirX = vec.func_177958_n();
        int dirY = vec.func_177956_o();
        int dirZ = vec.func_177952_p();
        for (int i = 0; i < 4; ++i) {
            int j = data.length / 4 * i;
            float x = Float.intBitsToFloat(data[j]);
            float y = Float.intBitsToFloat(data[j + 1]);
            float z = Float.intBitsToFloat(data[j + 2]);
            double offset = q.func_178210_d().func_176740_k().func_196051_a((double)x, (double)y, (double)z);
            if (!(offset < 9.765625E-4) && !(offset > 0.9990234375)) continue;
            data[j] = Float.floatToIntBits(x - 0.001953125f * (float)dirX);
            data[j + 1] = Float.floatToIntBits(y - 0.001953125f * (float)dirY);
            data[j + 2] = Float.floatToIntBits(z - 0.001953125f * (float)dirZ);
        }
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockState partialState = (BlockState)data.getData(WindowInABlockTileEntity.PARTIAL_BLOCK);
        BlockState windowState = (BlockState)data.getData(WindowInABlockTileEntity.WINDOW_BLOCK);
        BlockPos position = (BlockPos)data.getData(WindowInABlockTileEntity.POSITION);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (world == null || position == null) {
            return quads;
        }
        if (partialState == null || windowState == null) {
            return dispatcher.func_184389_a(Blocks.field_150346_d.func_176223_P()).getQuads(state, side, rand, data);
        }
        RenderType renderType = MinecraftForgeClient.getRenderLayer();
        if (RenderTypeLookup.canRenderInLayer((BlockState)partialState, (RenderType)renderType)) {
            IBakedModel partialModel = dispatcher.func_184389_a(partialState);
            IModelData modelData = partialModel.getModelData((ILightReader)world, position, partialState, (IModelData)EmptyModelData.INSTANCE);
            quads.addAll(partialModel.getQuads(partialState, side, rand, modelData));
        }
        if (RenderTypeLookup.canRenderInLayer((BlockState)windowState, (RenderType)renderType)) {
            IBakedModel windowModel = dispatcher.func_184389_a(windowState);
            IModelData glassModelData = windowModel.getModelData((ILightReader)world, position, windowState, (IModelData)EmptyModelData.INSTANCE);
            dispatcher.func_184389_a(windowState).getQuads(windowState, side, rand, glassModelData).forEach(bakedQuad -> {
                if (!Block.func_220056_d((BlockState)partialState, (IBlockReader)world, (BlockPos)position, (Direction)bakedQuad.func_178210_d())) {
                    WindowInABlockModel.fightZfighting(bakedQuad);
                    quads.add((BakedQuad)bakedQuad);
                }
            });
        }
        return quads;
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IModelData data) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockState partialState = (BlockState)data.getData(WindowInABlockTileEntity.PARTIAL_BLOCK);
        if (partialState == null) {
            return super.getParticleTexture(data);
        }
        return dispatcher.func_184389_a(partialState).getParticleTexture(data);
    }

    @Override
    public boolean func_177555_b() {
        RenderType renderLayer = MinecraftForgeClient.getRenderLayer();
        return renderLayer == RenderType.func_228639_c_();
    }
}

