/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mod.grimmauld.windowlogging.RegistryEntries;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fml.DistExecutor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WindowInABlockTileEntity
extends TileEntity {
    public static final ModelProperty<BlockState> PARTIAL_BLOCK = new ModelProperty();
    public static final ModelProperty<BlockState> WINDOW_BLOCK = new ModelProperty();
    public static final ModelProperty<BlockPos> POSITION = new ModelProperty();
    private BlockState partialBlock = Blocks.field_150350_a.func_176223_P();
    private BlockState windowBlock = Blocks.field_150350_a.func_176223_P();
    @OnlyIn(value=Dist.CLIENT)
    private IModelData modelData;

    public WindowInABlockTileEntity() {
        super(RegistryEntries.WINDOW_IN_A_BLOCK_TILE_ENTITY);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::initDataMap);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initDataMap() {
        this.modelData = new ModelDataMap.Builder().withInitial(WINDOW_BLOCK, (Object)Blocks.field_150350_a.func_176223_P()).withInitial(PARTIAL_BLOCK, (Object)Blocks.field_150350_a.func_176223_P()).withInitial(POSITION, (Object)BlockPos.field_177992_a).build();
    }

    public void func_145839_a(CompoundNBT compound) {
        this.partialBlock = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("PartialBlock"));
        this.windowBlock = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("WindowBlock"));
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("PartialBlock", (INBT)NBTUtil.func_190009_a((BlockState)this.getPartialBlock()));
        compound.func_218657_a("WindowBlock", (INBT)NBTUtil.func_190009_a((BlockState)this.getWindowBlock()));
        return super.func_189515_b(compound);
    }

    public void updateWindowConnections() {
        if (this.field_145850_b == null) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockPos offsetPos = this.field_174879_c.func_177972_a(side);
            this.windowBlock = this.getWindowBlock().func_196956_a(side, this.field_145850_b.func_180495_p(offsetPos), (IWorld)this.field_145850_b, this.field_174879_c, offsetPos);
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 18);
        this.func_70296_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IModelData getModelData() {
        this.modelData.setData(PARTIAL_BLOCK, (Object)this.partialBlock);
        this.modelData.setData(WINDOW_BLOCK, (Object)this.windowBlock);
        this.modelData.setData(POSITION, (Object)this.field_174879_c);
        return this.modelData;
    }

    public BlockState getPartialBlock() {
        return this.partialBlock;
    }

    public void setPartialBlock(BlockState partialBlock) {
        this.partialBlock = partialBlock;
    }

    public BlockState getWindowBlock() {
        return this.windowBlock;
    }

    public void setWindowBlock(BlockState windowBlock) {
        this.windowBlock = windowBlock;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

