/*
 * Decompiled with CFR 0.152.
 */
package mod.grimmauld.windowlogging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mod.grimmauld.windowlogging.RegistryEntries;
import mod.grimmauld.windowlogging.WindowInABlockBlock;
import mod.grimmauld.windowlogging.WindowInABlockTileEntity;
import mod.grimmauld.windowlogging.Windowlogging;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.WallBlock;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class EventListener {
    public static void clientInit(FMLClientSetupEvent event) {
        EventListener.registerRenderers();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers() {
        RenderTypeLookup.setRenderLayer((Block)RegistryEntries.WINDOW_IN_A_BLOCK, renderType -> true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        EventListener.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, EventListener.getAllBlockStateModelLocations((Block)RegistryEntries.WINDOW_IN_A_BLOCK), RegistryEntries.WINDOW_IN_A_BLOCK::createModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        block.func_176194_O().func_177619_a().forEach(state -> {
            ModelResourceLocation rl = EventListener.getBlockModelLocation(block, BlockModelShapes.func_209552_a((Map)state.func_206871_b()));
            if (rl != null) {
                models.add(rl);
            }
        });
        return models;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected static ModelResourceLocation getBlockModelLocation(Block block, String suffix) {
        ResourceLocation rl = block.getRegistryName();
        if (rl == null) {
            return null;
        }
        return new ModelResourceLocation(rl, suffix);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation location, Function<IBakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (IBakedModel)factory.apply(modelRegistry.get(location)));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<IBakedModel, T> factory) {
        locations.forEach(location -> EventListener.swapModels(modelRegistry, location, factory));
    }

    @SubscribeEvent
    public void rightClickPartialBlockWithPaneMakesItWindowLogged(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseItem() == Event.Result.DENY) {
            return;
        }
        if (event.getEntityLiving().func_225608_bj_()) {
            return;
        }
        if (!event.getPlayer().func_175142_cm()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return;
        }
        BlockItem item = (BlockItem)stack.func_77973_b();
        if (!item.func_206844_a((ITag)Tags.Items.GLASS_PANES)) {
            item.func_179223_d();
            if (!item.func_179223_d().func_203417_a((ITag)Tags.Blocks.GLASS_PANES)) {
                return;
            }
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        BlockState blockState = world.func_180495_p(pos);
        if (!blockState.func_177230_c().getTags().contains(Windowlogging.WindowableBlockTagLocation)) {
            return;
        }
        if (blockState.func_177230_c() instanceof WindowInABlockBlock) {
            return;
        }
        if (blockState.func_235903_d_((Property)BlockStateProperties.field_208145_at).orElse(null) == SlabType.DOUBLE) {
            return;
        }
        BlockState defaultState = RegistryEntries.WINDOW_IN_A_BLOCK.func_176223_P();
        world.func_175656_a(pos, defaultState);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof WindowInABlockTileEntity) {
            WindowInABlockTileEntity wte = (WindowInABlockTileEntity)te;
            wte.setWindowBlock(item.func_179223_d().func_176223_P());
            wte.updateWindowConnections();
            SoundType soundtype = wte.getWindowBlock().getSoundType((IWorldReader)world, pos, (Entity)event.getPlayer());
            world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (blockState.func_177230_c() instanceof FourWayBlock) {
                for (BooleanProperty side : Arrays.asList(FourWayBlock.field_196411_b, FourWayBlock.field_196409_a, FourWayBlock.field_196413_c, FourWayBlock.field_196414_y)) {
                    blockState = (BlockState)blockState.func_206870_a((Property)side, (Comparable)Boolean.valueOf(false));
                }
            }
            if (blockState.func_177230_c() instanceof WallBlock) {
                blockState = (BlockState)blockState.func_206870_a((Property)WallBlock.field_176256_a, (Comparable)Boolean.valueOf(true));
            }
            wte.setPartialBlock(blockState);
            wte.requestModelDataUpdate();
            if (!event.getPlayer().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            event.getPlayer().func_184609_a(event.getHand());
        }
        event.setCanceled(true);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            Windowlogging.LOGGER.debug("blocks registering");
            event.getRegistry().register(new WindowInABlockBlock().setRegistryName("window_in_a_block"));
        }

        @SubscribeEvent
        public static void registerTEs(RegistryEvent.Register<TileEntityType<?>> event) {
            Windowlogging.LOGGER.debug("TEs registering");
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(WindowInABlockTileEntity::new, (Block[])new Block[]{RegistryEntries.WINDOW_IN_A_BLOCK}).func_206865_a(null).setRegistryName("window_in_a_block"));
        }
    }
}

