/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod;

import com.swdteam.wotwmod.WOTWContent;
import com.swdteam.wotwmod.client.ClientEvents;
import com.swdteam.wotwmod.client.overlay.GeneralOverlay;
import com.swdteam.wotwmod.common.event.BlockEvents;
import com.swdteam.wotwmod.common.event.ForgeEventBusSubscriber;
import com.swdteam.wotwmod.common.event.InventoryEvents;
import com.swdteam.wotwmod.common.event.MobEvents;
import com.swdteam.wotwmod.common.event.WorldEvents;
import com.swdteam.wotwmod.common.init.WOTWBiomes;
import com.swdteam.wotwmod.common.misc.WOTWConfig;
import com.swdteam.wotwmod.common.misc.WOTWTabs;
import com.swdteam.wotwmod.common.network.NetworkHandler;
import com.swdteam.wotwmod.common.utils.MathUtils;
import com.swdteam.wotwmod.common.utils.WOTWStructures;
import com.swdteam.wotwmod.common.world.mars.biomes.MarsBiome;
import com.swdteam.wotwmod.common.world.mars.biomes.MarsLushBiome;
import com.swdteam.wotwmod.common.world.mars.biomes.MarsMountainsBiome;
import com.swdteam.wotwmod.common.world.mars.biomes.MarsQuarriesBiome;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="wotwmod")
public class WOTWMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "wotwmod";
    public static final String BUILD_STRING = "WOTWMod Update 1.0.7";
    public static WOTWTabs tabs;
    public static WOTWStructures structures;
    public static MathUtils MATH_UTILS;
    public static final ResourceLocation MARS_DIM_TYPE;

    public WOTWMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonStartup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, WOTWConfig.COMMON_SPEC, "wotwmod-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, WOTWConfig.CLIENT_SPEC, "wotwmod-client.toml");
        WOTWContent.init();
        structures = new WOTWStructures();
        MATH_UTILS = new MathUtils();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(WorldEvents.class);
        MinecraftForge.EVENT_BUS.register(MobEvents.class);
        MinecraftForge.EVENT_BUS.register(BlockEvents.class);
        MinecraftForge.EVENT_BUS.register(InventoryEvents.class);
        MinecraftForge.EVENT_BUS.register(ForgeEventBusSubscriber.class);
        tabs = new WOTWTabs();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info(BUILD_STRING);
        NetworkHandler.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
        ClientEvents.overlays.add(new GeneralOverlay());
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    @SubscribeEvent
    public void onCommonStartup(FMLCommonSetupEvent e) {
        DeferredWorkQueue.runLater(() -> {
            Iterator biomes = ForgeRegistries.BIOMES.iterator();
            biomes.forEachRemaining(biome -> {
                if (!(biome.func_201856_r() == Biome.Category.OCEAN || biome.func_201856_r() == Biome.Category.SWAMP || biome instanceof MarsBiome || biome instanceof MarsMountainsBiome || biome instanceof MarsQuarriesBiome || biome instanceof MarsLushBiome)) {
                    biome.func_226711_a_(WOTWStructures.RUINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.RUINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                    biome.func_226711_a_(WOTWStructures.RUINS_1.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.RUINS_1.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                    biome.func_226711_a_(WOTWStructures.HOUSE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.HOUSE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                    biome.func_226711_a_(WOTWStructures.DESERT_HOUSE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.DESERT_HOUSE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                    biome.func_226711_a_(WOTWStructures.UKCAMP.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.UKCAMP.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                    biome.func_226711_a_(WOTWStructures.HUMANMINE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.HUMANMINE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                }
                ((Biome)WOTWBiomes.MARS_BIOME.get()).func_226711_a_(WOTWStructures.ORE_PILE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.ORE_PILE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME.get()).func_226711_a_(WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME_LUSH.get()).func_226711_a_(WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME_LUSH.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME_MOUNTAIN.get()).func_226711_a_(WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME_MOUNTAIN.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME_QUARRY.get()).func_226711_a_(WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME_QUARRY.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.COBALT_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME.get()).func_226711_a_(WOTWStructures.SLAVE_MINES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.SLAVE_MINES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME_QUARRY.get()).func_226711_a_(WOTWStructures.ORE_PILE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME_QUARRY.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.ORE_PILE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                ((Biome)WOTWBiomes.MARS_BIOME_MOUNTAIN.get()).func_226711_a_(WOTWStructures.ORE_PILE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                ((Biome)WOTWBiomes.MARS_BIOME_MOUNTAIN.get()).func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, WOTWStructures.ORE_PILE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            });
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    static {
        MARS_DIM_TYPE = new ResourceLocation(MOD_ID, "mars");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

