/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.client.entity.render.martian;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.swdteam.wotwmod.client.entity.model.FightingMachineModel;
import com.swdteam.wotwmod.client.mdl.MDL;
import com.swdteam.wotwmod.client.mdl.MDLLoader;
import com.swdteam.wotwmod.client.mdl.obj.Model;
import com.swdteam.wotwmod.common.entity.martian.FightingMachineEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class EntityFightingMachineRender
extends MobRenderer<FightingMachineEntity, FightingMachineModel<FightingMachineEntity>> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("wotwmod", "textures/entity/fightingmachine.png");
    public MDL model = MDLLoader.loadMDL("wotwmod", "models/entity/martian/fighting_machine.mdl");

    public EntityFightingMachineRender(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new FightingMachineModel(), 8.0f);
    }

    public ResourceLocation getEntityTexture(FightingMachineEntity entity) {
        return TEXTURE;
    }

    public void render(FightingMachineEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        GL11.glPushMatrix();
        if (this.model != null) {
            float fab;
            double x2 = entityIn.field_70169_q + (entityIn.func_226277_ct_() - entityIn.field_70169_q) * (double)partialTicks;
            double y2 = entityIn.field_70167_r + (entityIn.func_226278_cu_() - entityIn.field_70167_r) * (double)partialTicks;
            double z2 = entityIn.field_70166_s + (entityIn.func_226281_cx_() - entityIn.field_70166_s) * (double)partialTicks;
            float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
            this.model.yRotation = -f;
            this.model.move((float)x2, (float)y2, (float)z2);
            float fa = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
            float fb = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
            float netHeadYaw = fab = fb - fa;
            float headPitch = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
            if (this.model != null) {
                for (Model m : this.model.getModels()) {
                    float legRot;
                    if (m.model_name.equalsIgnoreCase("leg_left")) {
                        m.xRotation = legRot = -MathHelper.func_76134_b((float)(entityIn.field_184619_aG * 0.5f)) * entityIn.field_70721_aZ * 10.0f;
                    }
                    if (m.model_name.equalsIgnoreCase("leg_right")) {
                        m.xRotation = legRot = MathHelper.func_76134_b((float)(entityIn.field_184619_aG * 0.5f)) * entityIn.field_70721_aZ * 10.0f;
                    }
                    if (!m.model_name.equalsIgnoreCase("leg_back")) continue;
                    m.xRotation = legRot = -MathHelper.func_76134_b((float)(entityIn.field_184619_aG * 0.5f)) * entityIn.field_70721_aZ * 10.0f;
                }
                float hurtRed = 0.0f;
                if (entityIn.field_70737_aN > 0) {
                    hurtRed = 0.5f;
                }
                BlockPos pos = entityIn.func_180425_c();
                float brightness = (float)Minecraft.func_71410_x().field_71441_e.func_226658_a_(LightType.BLOCK, entityIn.func_180425_c().func_177982_a(0, 0, 0)) / 16.0f / 2.0f;
                brightness = entityIn.field_70170_p.func_226660_f_(pos.func_177982_a(0, 0, 0)) ? (brightness += Minecraft.func_71410_x().field_71441_e.func_228326_g_(1.0f) * 1.5f) : (brightness += 0.2f);
                if (brightness > 1.0f) {
                    brightness = 1.0f;
                }
                if (brightness < 0.2f) {
                    brightness = 0.2f;
                }
                Runnable enable = () -> {
                    RenderSystem.enableAlphaTest();
                    RenderSystem.defaultAlphaFunc();
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableFog();
                };
                RenderHelper.func_227780_a_();
                enable.run();
                if (hurtRed > 0.0f) {
                    brightness = 0.5f;
                }
                GL11.glColor4f((float)(brightness + hurtRed), (float)brightness, (float)brightness, (float)1.0f);
                this.model.renderAll();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GL11.glPopMatrix();
    }
}

