/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.client.mdl;

import com.swdteam.wotwmod.client.mdl.obj.Model;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class MDL {
    public BufferedImage modelIcon;
    private Model[] models;
    private HashMap<String, Integer> modelIndexes;
    public int[] displayLists;
    public int[] textures;
    public BufferedImage[] textureFiles;
    public boolean[] loadingTextures;
    public boolean portalRender;
    public float xTransform;
    public float yTransform;
    public float zTransform;
    public float xOffset;
    public float yOffset;
    public float zOffset;
    public float xRotation;
    public float yRotation;
    public float zRotation;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;

    public void move(float x, float y, float z) {
        this.xTransform = x;
        this.yTransform = y;
        this.zTransform = z;
    }

    public void renderAll() {
        GL11.glPushMatrix();
        this.applyGlobalTransform();
        GL11.glTranslatef((float)this.xTransform, (float)this.yTransform, (float)this.zTransform);
        GL11.glScaled((double)this.xScale, (double)this.yScale, (double)this.zScale);
        GL11.glRotatef((float)this.zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)this.xOffset, (float)this.yOffset, (float)this.zOffset);
        this.pre();
        this.render();
        this.post();
        GL11.glPopMatrix();
    }

    public void render() {
        if (this.models != null) {
            GL11.glPushMatrix();
            int previousTexture = GL11.glGetInteger((int)32873);
            for (Model m : this.models) {
                if (m.isChild) continue;
                this.render(m);
            }
            MDL.bindTexture(previousTexture);
            GL11.glPopMatrix();
        }
    }

    public void render(String model) {
        GL11.glPushMatrix();
        int previousTexture = GL11.glGetInteger((int)32873);
        this.render(this.getModel(model));
        MDL.bindTexture(previousTexture);
        GL11.glPopMatrix();
    }

    public void render(Model model) {
        if (this != null && model != null && this.models != null) {
            model.renderAll(this);
        }
    }

    private void pre() {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2884);
    }

    private void post() {
    }

    public void applyGlobalTransform() {
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec2f angle = new Vec2f(renderInfo.func_216777_e(), renderInfo.func_216778_f());
        Vec3d origin = renderInfo.func_216785_c();
        GL11.glRotated((double)angle.field_189982_i, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(angle.field_189983_j + 180.0f), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(-origin.field_72450_a), (double)(-origin.field_72448_b), (double)(-origin.field_72449_c));
    }

    public Model getModel(String s) {
        if (this.modelIndexes == null) {
            this.modelIndexes = new HashMap();
        }
        if (this.modelIndexes.containsKey(s)) {
            return this.models[this.modelIndexes.get(s)];
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (!this.models[i].model_name.equalsIgnoreCase(s)) continue;
            this.modelIndexes.put(s, i);
            return this.models[i];
        }
        return null;
    }

    public int getModelIndex(String s) {
        if (this.modelIndexes == null) {
            this.modelIndexes = new HashMap();
        }
        if (this.modelIndexes.containsKey(s)) {
            return this.modelIndexes.get(s);
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (!this.models[i].model_name.equalsIgnoreCase(s)) continue;
            this.modelIndexes.put(s, i);
            return i;
        }
        return -1;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int createDisplayList(Model model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        model.render();
        GL11.glEndList();
        return displayList;
    }

    public void setModels(Model[] models) {
        this.models = models;
        this.displayLists = new int[models.length];
        for (int i = 0; i < models.length; ++i) {
            this.displayLists[i] = -1;
        }
    }

    public void setTextures(BufferedImage[] imgs) {
        this.textureFiles = imgs;
        this.textures = new int[imgs.length];
        this.loadingTextures = new boolean[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            this.textures[i] = -1;
            this.loadingTextures[i] = false;
        }
    }

    public static int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    public static void bindTexture(int i) {
        GL11.glBindTexture((int)3553, (int)i);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
    }

    public static class MDLData {
        public String[] textures;
        public ObjectData[] object_data;

        public static class ObjectData {
            public String name;
            public int texture_index;
            public String[] children = new String[0];
            public float[] transform = new float[]{0.0f, 0.0f, 0.0f};
            public float[] offset = new float[]{0.0f, 0.0f, 0.0f};
            public float[] rotate = new float[]{0.0f, 0.0f, 0.0f};
            public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
            public float[] color = new float[]{1.0f, 1.0f, 1.0f};
            public float opacity = 1.0f;
            public boolean hidden = false;
            public boolean glow = false;
            public boolean disable_shading = false;
            public boolean portal_mesh = false;
        }
    }
}

