/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.client.mdl;

import com.google.gson.Gson;
import com.swdteam.wotwmod.client.mdl.MDL;
import com.swdteam.wotwmod.client.mdl.obj.Model;
import com.swdteam.wotwmod.client.mdl.obj.OBJLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class MDLLoader {
    public static Gson GSON = new Gson();

    public static MDL loadMDL(String mod, String location) {
        if (location.endsWith(".mdl")) {
            return MDLLoader.loadMDL(new ResourceLocation(mod, location));
        }
        return MDLLoader.loadMDL(new ResourceLocation(mod, location + ".mdl"));
    }

    public static MDL loadMDL(ResourceLocation location) {
        try {
            return MDLLoader.loadMDL(Minecraft.func_71410_x().func_195551_G().func_199002_a(location).func_199027_b());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDL loadMDL(InputStream inputstream) throws Exception {
        BufferedReader reader = null;
        try {
            MDL mdl_main = new MDL();
            HashMap<String, Model> models = new HashMap<String, Model>();
            HashMap<String, BufferedImage> textures = new HashMap<String, BufferedImage>();
            MDL.MDLData mdl_data = null;
            ZipInputStream stream = new ZipInputStream(inputstream);
            ZipEntry entry = null;
            while ((entry = stream.getNextEntry()) != null) {
                BufferedImage image;
                if (entry.getName().equalsIgnoreCase("data_mdl.json")) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                    StringBuilder string_builder = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        string_builder.append(line);
                    }
                    mdl_data = (MDL.MDLData)GSON.fromJson(string_builder.toString(), MDL.MDLData.class);
                    if (mdl_data == null) {
                        reader.close();
                        throw new Exception("MDL Data is missing...");
                    }
                }
                if (entry.getName().toUpperCase().endsWith(".OBJ")) {
                    Model obj = OBJLoader.INSTANCE.loadModel(stream);
                    obj.model_name = entry.getName().substring(0, entry.getName().length() - 4);
                    models.put(obj.model_name, obj);
                }
                if (!entry.getName().toUpperCase().startsWith("MDL_ICO") && entry.getName().toUpperCase().endsWith(".PNG")) {
                    image = ImageIO.read(stream);
                    textures.put(entry.getName().substring(0, entry.getName().length() - 4), image);
                }
                if (!entry.getName().toUpperCase().equals("MDL_ICO.PNG")) continue;
                mdl_main.modelIcon = image = ImageIO.read(stream);
            }
            if (mdl_data != null && mdl_data.object_data != null) {
                MDL.MDLData.ObjectData data;
                int i;
                ArrayList img = new ArrayList();
                ArrayList<Model> mdls = new ArrayList<Model>();
                for (i = 0; i < mdl_data.textures.length; ++i) {
                    if (!textures.containsKey(mdl_data.textures[i])) continue;
                    img.add(textures.get(mdl_data.textures[i]));
                }
                for (i = 0; i < mdl_data.object_data.length; ++i) {
                    data = mdl_data.object_data[i];
                    if (!models.containsKey(data.name)) continue;
                    Model obj = (Model)models.get(data.name);
                    if (!data.name.equalsIgnoreCase(obj.model_name)) continue;
                    obj.textureIndex = data.texture_index;
                    obj.xTransform = data.transform[0];
                    obj.xOffset = data.offset[0];
                    obj.xRotation = data.rotate[0];
                    obj.yTransform = data.transform[1];
                    obj.yOffset = data.offset[1];
                    obj.yRotation = data.rotate[1];
                    obj.zTransform = -data.transform[2];
                    obj.zOffset = -data.offset[2];
                    obj.zRotation = -data.rotate[2];
                    obj.xScale = data.scale[0];
                    obj.yScale = data.scale[1];
                    obj.zScale = data.scale[2];
                    obj.hidden = data.hidden;
                    obj.disable_shading = data.disable_shading;
                    obj.glow = data.glow;
                    obj.color = data.color;
                    mdls.add(obj);
                }
                for (i = 0; i < mdl_data.object_data.length; ++i) {
                    data = mdl_data.object_data[i];
                    if (!models.containsKey(data.name)) continue;
                    for (int j = 0; j < data.children.length; ++j) {
                        if (!models.containsKey(data.children[j])) continue;
                        ((Model)models.get((Object)data.name)).children.add((Model)models.get(data.children[j]));
                        ((Model)models.get((Object)data.children[j])).isChild = true;
                    }
                }
                mdl_main.setTextures(img.toArray(new BufferedImage[img.size()]));
                mdl_main.setModels(mdls.toArray(new Model[mdls.size()]));
                MDL mDL = mdl_main;
                return mDL;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputstream != null) {
                inputstream.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return null;
    }

    public static class MDLCache {
        private static Map<String, MDL> cache = new HashMap<String, MDL>();

        public static MDL loadMDL(String s) {
            if (cache.containsKey(s)) {
                return cache.get(s);
            }
            cache.put(s, MDLLoader.loadMDL("wotwmod", s));
            if (cache.get(s) != null) {
                return cache.get(s);
            }
            return new MDL();
        }

        public static void clearCache() {
            cache.clear();
        }
    }
}

