/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.client.mdl.obj;

import com.swdteam.wotwmod.client.mdl.MDL;
import com.swdteam.wotwmod.client.mdl.obj.OBJLoader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Model {
    public String model_name;
    public boolean hidden = false;
    public boolean isChild = false;
    public List<Model> children;
    public float xTransform;
    public float yTransform;
    public float zTransform;
    public float xOffset;
    public float yOffset;
    public float zOffset;
    public float xRotation;
    public float yRotation;
    public float zRotation;
    public float xScale;
    public float yScale;
    public float zScale;
    public float[] color = new float[]{1.0f, 1.0f, 1.0f};
    public float opacity = 1.0f;
    public boolean glow = false;
    public boolean disable_shading;
    public int renderListID = -1;
    private final Position3f[] vertices;
    private final Position2f[] textureCoords;
    private final Vector3f[] normals;
    private final Face[] faces;
    private boolean enableSmoothShading;
    public int textureIndex = 0;
    FloatBuffer previousColor;

    public Model(Position3f[] vertices, Position2f[] textureCoords, Vector3f[] normals, Face[] faces, boolean enableSmoothShading) {
        this.vertices = vertices;
        this.textureCoords = textureCoords;
        this.normals = normals;
        this.faces = faces;
        this.enableSmoothShading = enableSmoothShading;
        this.children = new ArrayList<Model>();
    }

    public void smoothShading() {
        if (this.isSmoothShadingEnabled()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
    }

    public boolean hasTextureCoordinates() {
        return this.getTextureCoordinates().length > 0;
    }

    public boolean hasNormals() {
        return this.getNormals().length > 0;
    }

    public Position3f[] getVertices() {
        return this.vertices;
    }

    public Position2f[] getTextureCoordinates() {
        return this.textureCoords;
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public Face[] getFaces() {
        return this.faces;
    }

    public boolean isSmoothShadingEnabled() {
        return this.enableSmoothShading;
    }

    public void setSmoothShadingEnabled(boolean isSmoothShadingEnabled) {
        this.enableSmoothShading = isSmoothShadingEnabled;
    }

    public void renderAll(MDL mdl) {
        if (!this.hidden) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.xTransform, (float)this.yTransform, (float)this.zTransform);
            GL11.glScaled((double)this.xScale, (double)this.yScale, (double)this.zScale);
            GL11.glRotatef((float)this.zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)this.yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)this.xOffset, (float)this.yOffset, (float)this.zOffset);
            this.smoothShading();
            this.loadTextures(mdl);
            MDL.bindTexture(mdl.textures[this.textureIndex]);
            if (this.previousColor == null) {
                this.previousColor = BufferUtils.createFloatBuffer((int)16);
            }
            GL11.glGetFloatv((int)2816, (FloatBuffer)this.previousColor);
            float[] rgbaOld = new float[]{this.previousColor.get(0), this.previousColor.get(1), this.previousColor.get(2), this.previousColor.get(3)};
            GL11.glColor4f((float)(this.color[0] * rgbaOld[0]), (float)(this.color[1] * rgbaOld[1]), (float)(this.color[2] * rgbaOld[2]), (float)(this.opacity * rgbaOld[3]));
            if (this.renderListID == -1) {
                this.renderListID = mdl.createDisplayList(this);
            } else {
                GL11.glCallList((int)this.renderListID);
            }
            GL11.glColor4f((float)rgbaOld[0], (float)rgbaOld[1], (float)rgbaOld[2], (float)rgbaOld[3]);
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).renderAll(mdl);
            }
            GL11.glPopMatrix();
        }
    }

    public void render() {
        OBJLoader.INSTANCE.render(this);
    }

    public void loadTextures(MDL mdl) {
        if (mdl.textures[this.textureIndex] == -1 && !mdl.loadingTextures[this.textureIndex]) {
            mdl.textures[this.textureIndex] = MDL.loadTexture(mdl.textureFiles[this.textureIndex]);
            mdl.loadingTextures[this.textureIndex] = true;
        }
    }

    public static class Position2f {
        private float x;
        private float y;

        public Position2f(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }
    }

    public static class Position3f {
        private float x;
        private float y;
        private float z;

        public Position3f(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }
    }

    public static class Face {
        private int[] vertexIndices;
        private int[] normalIndices;
        private int[] textureCoordinateIndices;

        public boolean hasNormals() {
            return this.normalIndices != null;
        }

        public boolean hasTextureCoords() {
            return this.textureCoordinateIndices != null;
        }

        public int[] getVertices() {
            return this.vertexIndices;
        }

        public int[] getTextureCoords() {
            return this.textureCoordinateIndices;
        }

        public int[] getNormals() {
            return this.normalIndices;
        }

        public Face(int[] vertexIndices, int[] textureCoordinateIndices, int[] normalIndices) {
            this.vertexIndices = vertexIndices;
            this.normalIndices = normalIndices;
            this.textureCoordinateIndices = textureCoordinateIndices;
        }
    }
}

