/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.client.mdl.obj;

import com.swdteam.wotwmod.client.mdl.obj.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import net.minecraft.client.renderer.Vector3f;
import org.lwjgl.opengl.GL11;

public class OBJLoader {
    public static OBJLoader INSTANCE = new OBJLoader();

    public void render(Model model) {
        GL11.glPushMatrix();
        GL11.glBegin((int)4);
        for (Model.Face face : model.getFaces()) {
            Vector3f[] n = model.getNormals();
            Model.Position2f[] t = model.getTextureCoordinates();
            Model.Position3f[] v = model.getVertices();
            for (int i = 0; i < face.getVertices().length - 2; ++i) {
                float px = v[face.getVertices()[0]].getX();
                float py = v[face.getVertices()[0]].getY();
                float pz = v[face.getVertices()[0]].getZ();
                float nx = n[face.getNormals()[0]].func_195899_a();
                float ny = n[face.getNormals()[0]].func_195900_b();
                float nz = n[face.getNormals()[0]].func_195902_c();
                float tx = t[face.getTextureCoords()[0]].getX();
                float ty = 1.0f - t[face.getTextureCoords()[0]].getY();
                GL11.glNormal3f((float)nx, (float)ny, (float)nz);
                GL11.glTexCoord2f((float)tx, (float)ty);
                GL11.glVertex3f((float)px, (float)py, (float)pz);
                for (int j = 0; j < 2; ++j) {
                    px = v[face.getVertices()[i + j + 1]].getX();
                    py = v[face.getVertices()[i + j + 1]].getY();
                    pz = v[face.getVertices()[i + j + 1]].getZ();
                    nx = n[face.getNormals()[i + j + 1]].func_195899_a();
                    ny = n[face.getNormals()[i + j + 1]].func_195900_b();
                    nz = n[face.getNormals()[i + j + 1]].func_195902_c();
                    tx = t[face.getTextureCoords()[i + j + 1]].getX();
                    ty = 1.0f - t[face.getTextureCoords()[i + j + 1]].getY();
                    GL11.glNormal3f((float)nx, (float)ny, (float)nz);
                    GL11.glTexCoord2f((float)tx, (float)ty);
                    GL11.glVertex3f((float)px, (float)py, (float)pz);
                }
            }
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public Model loadModel(File file) throws FileNotFoundException {
        Scanner s = new Scanner(file);
        Model obj = this.loadModel(s);
        return obj;
    }

    public Model loadModel(InputStream stream) {
        Scanner s = new Scanner(stream);
        Model obj = this.loadModel(s);
        return obj;
    }

    public Model loadModel(Scanner sc) {
        int i;
        ArrayList<Model.Position3f> vertices = new ArrayList<Model.Position3f>();
        ArrayList<Model.Position2f> textureCoords = new ArrayList<Model.Position2f>();
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        ArrayList<Model.Face> faces = new ArrayList<Model.Face>();
        boolean smooth = false;
        while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln == null || ln.equals("") || ln.startsWith("#")) continue;
            String[] split = ln.split(" ");
            switch (split[0]) {
                case "v": {
                    vertices.add(new Model.Position3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vn": {
                    normals.add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    break;
                }
                case "vt": {
                    textureCoords.add(new Model.Position2f(Float.parseFloat(split[1]), Float.parseFloat(split[2])));
                    break;
                }
                case "f": {
                    if (split.length <= 2) break;
                    int[] v = new int[split.length - 1];
                    int[] t = new int[split.length - 1];
                    int[] n = new int[split.length - 1];
                    for (int i2 = 0; i2 < split.length - 1; ++i2) {
                        v[i2] = this.parseInt(split[i2 + 1].split("/")[0]) - 1;
                        t[i2] = this.parseInt(split[i2 + 1].split("/")[1]) - 1;
                        n[i2] = this.parseInt(split[i2 + 1].split("/")[2]) - 1;
                    }
                    faces.add(new Model.Face(v, t, n));
                    break;
                }
                case "s": {
                    smooth = !ln.contains("off");
                    break;
                }
            }
        }
        Model.Position3f[] v = new Model.Position3f[vertices.size()];
        Model.Position2f[] t = new Model.Position2f[textureCoords.size()];
        Vector3f[] n = new Vector3f[normals.size()];
        Model.Face[] f = new Model.Face[faces.size()];
        for (i = 0; i < v.length; ++i) {
            v[i] = new Model.Position3f(((Model.Position3f)vertices.get(i)).getX(), ((Model.Position3f)vertices.get(i)).getY(), ((Model.Position3f)vertices.get(i)).getZ());
        }
        for (i = 0; i < t.length; ++i) {
            t[i] = new Model.Position2f(((Model.Position2f)textureCoords.get(i)).getX(), ((Model.Position2f)textureCoords.get(i)).getY());
        }
        for (i = 0; i < n.length; ++i) {
            n[i] = new Vector3f(((Vector3f)normals.get(i)).func_195899_a(), ((Vector3f)normals.get(i)).func_195900_b(), ((Vector3f)normals.get(i)).func_195902_c());
        }
        for (i = 0; i < f.length; ++i) {
            f[i] = new Model.Face(((Model.Face)faces.get(i)).getVertices(), ((Model.Face)faces.get(i)).getTextureCoords(), ((Model.Face)faces.get(i)).getNormals());
        }
        return new Model(v, t, n, f, smooth);
    }

    public int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

