/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.block.tiles;

import com.swdteam.wotwmod.client.WOTWGuiHandler;
import com.swdteam.wotwmod.common.block.base.StandardBlock;
import com.swdteam.wotwmod.common.init.WOTWBlocks;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.init.WOTWTiles;
import com.swdteam.wotwmod.common.network.NetworkHandler;
import com.swdteam.wotwmod.common.network.packets.PacketOpenGui;
import com.swdteam.wotwmod.common.tilentity.BaseTileEntity;
import com.swdteam.wotwmod.common.tilentity.martian.MartianTeleporterTileEntity;
import com.swdteam.wotwmod.common.utils.MathUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;

public class MartianTeleporterBlock
extends StandardBlock
implements IShearable {
    protected static VoxelShape SHAPE_A = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public MartianTeleporterBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_200942_a().func_226896_b_());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && (!player.func_213453_ef() && player.func_211513_k(2) || worldIn.func_217369_A().size() == 1)) {
            NetworkHandler.sendTo((ServerPlayerEntity)player, new PacketOpenGui(pos, WOTWGuiHandler.GUI_TELE));
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (!entityIn.func_213453_ef()) return;
        TileEntity te = worldIn.func_175625_s(pos);
        MartianTeleporterTileEntity mte = (MartianTeleporterTileEntity)worldIn.func_175625_s(pos);
        if (mte.activated) {
            BlockPos destination;
            entityIn.func_184185_a((SoundEvent)WOTWSounds.SOUND_ITEM_WARP.get(), 0.5f, 1.0f);
            mte.activated = false;
            if (!worldIn.field_72995_K) {
                ServerPlayerEntity spe = (ServerPlayerEntity)entityIn;
                ServerWorld nextWorld = entityIn.func_184102_h().func_71218_a(DimensionType.field_223227_a_);
                BlockPos destination2 = new BlockPos(te.getTileData().func_74762_e("targetX"), te.getTileData().func_74762_e("targetY"), te.getTileData().func_74762_e("targetZ"));
                if (worldIn.func_180495_p(destination2).func_177230_c() == WOTWBlocks.MARTIAN_TELEPORTER_BLOCK.get()) {
                    spe.func_200619_a(nextWorld, (double)te.getTileData().func_74762_e("targetX") + 0.5, (double)te.getTileData().func_74762_e("targetY"), (double)te.getTileData().func_74762_e("targetZ") + 0.5, spe.field_70177_z, spe.field_70125_A);
                }
            }
            if (worldIn.func_180495_p(destination = new BlockPos(te.getTileData().func_74762_e("targetX"), te.getTileData().func_74762_e("targetY"), te.getTileData().func_74762_e("targetZ"))).func_177230_c() != WOTWBlocks.MARTIAN_TELEPORTER_BLOCK.get()) return;
        }
        entityIn.func_184185_a(SoundEvents.field_194226_id, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        for (int i = 0; i < 5; ++i) {
            MartianTeleporterTileEntity mte = (MartianTeleporterTileEntity)worldIn.func_175625_s(pos);
            if (!mte.activated) continue;
            double d3 = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.1f + MathUtils.randomDouble(0.0, 1.0);
            double d8 = (double)pos.func_177956_o() + rand.nextDouble();
            double d13 = (double)pos.func_177952_p() + rand.nextDouble() + MathUtils.randomDouble(-0.1, 0.2);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197632_y, d3, d8, d13, 0.0, 0.2, 0.0);
        }
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Vec3d vec = entity.func_213303_ch();
        return Direction.func_176737_a((float)((float)(vec.field_72450_a - (double)clickedBlock.func_177958_n())), (float)((float)(vec.field_72448_b - (double)clickedBlock.func_177956_o())), (float)((float)(vec.field_72449_c - (double)clickedBlock.func_177952_p())));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)WOTWTiles.MARTIAN_TELEPORTER.get()).func_200968_a();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            Direction d = MartianTeleporterBlock.getFacingFromEntity(pos, placer).func_176734_d();
            if (d == Direction.DOWN) {
                d = Direction.NORTH;
            }
            if (d == Direction.UP) {
                d = Direction.UP;
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)d));
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof BaseTileEntity) {
                // empty if block
            }
        }
    }
}

