/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.vehicle;

import com.swdteam.wotwmod.common.entity.martian.ScalpEntity;
import com.swdteam.wotwmod.common.init.WOTWItems;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.init.WOTWSpawners;
import com.swdteam.wotwmod.common.utils.ItemUtils;
import com.swdteam.wotwmod.common.utils.MathUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JeepEntity
extends AnimalEntity
implements IJumpingMount {
    protected float jumpPower;
    private boolean allowStandSliding = true;
    protected boolean horseJumping;
    private float deltaRotation;
    private int engineRevTime = 0;
    boolean deathExplosion = false;
    public boolean driving = false;

    public JeepEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public boolean isHorseJumping() {
        return this.horseJumping;
    }

    public void setHorseJumping(boolean jumping) {
        this.horseJumping = jumping;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            if (!player.field_70170_p.field_72995_K) {
                this.func_199701_a_(new ItemStack((IItemProvider)WOTWSpawners.JEEP_SPAWNER.get()));
                this.func_70106_y();
            }
        } else {
            this.mountTo(player);
        }
        return super.func_184645_a(player, hand);
    }

    protected double func_190634_dg() {
        return 0.0;
    }

    protected void mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean isHorseSaddled() {
        return true;
    }

    public boolean isRearing() {
        return false;
    }

    public double func_70042_X() {
        return 0.8;
    }

    public void func_181013_g(float offset) {
        super.func_181013_g(offset += 0.4f);
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isHorseSaddled()) {
                double d3;
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (livingentity instanceof PlayerEntity && !ItemUtils.playerHasItem((PlayerEntity)livingentity, (Item)WOTWItems.FUEL.get(), false) && !((PlayerEntity)livingentity).func_184812_l_()) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (f1 > 0.0f) {
                    PlayerEntity pl;
                    this.driving = true;
                    if (MathUtils.getRANDOM().nextInt(100) == 1 && livingentity instanceof PlayerEntity && ItemUtils.playerHasItem(pl = (PlayerEntity)livingentity, (Item)WOTWItems.FUEL.get(), false) && !pl.func_184812_l_()) {
                        this.func_184185_a(SoundEvents.field_191241_J, 1.0f, (float)MathUtils.randomDouble(0.6, 1.0));
                        if (!this.field_70170_p.field_72995_K) {
                            ItemUtils.consumeItem(pl, (Item)WOTWItems.FUEL.get());
                        }
                    }
                    ++this.engineRevTime;
                    if (this.engineRevTime > 10) {
                        this.func_184185_a((SoundEvent)WOTWSounds.SOUND_ENTITY_JEEP_HUM.get(), 1.0f, 0.4f + f1);
                        this.engineRevTime = 0;
                    }
                } else {
                    this.driving = false;
                }
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (f1 > 0.5f) {
                    f1 = 0.5f;
                }
                if (this.field_70122_E && this.jumpPower == 0.0f && this.isRearing() && !this.allowStandSliding) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.jumpPower > 0.0f && !this.isHorseJumping() && this.field_70122_E) {
                    double d0 = 1.0 * (double)this.jumpPower * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, d1, vec3d.field_72449_c);
                    this.setHorseJumping(true);
                    this.field_70160_al = true;
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_213352_e(new Vec3d((double)f, p_213352_1_.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.jumpPower = 0.0f;
                    this.setHorseJumping(false);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d2 = this.func_226277_ct_() - this.field_70169_q;
                float f4 = MathHelper.func_76133_a((double)(d2 * d2 + (d3 = this.func_226281_cx_() - this.field_70166_s) * d3)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(p_213352_1_);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            float f = -1.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.5f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (this.isHorseSaddled()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            } else {
                this.allowStandSliding = true;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if ((entityIn instanceof AnimalEntity || entityIn instanceof ScalpEntity && this.func_184207_aI()) && !(entityIn instanceof JeepEntity)) {
            entityIn.func_174812_G();
        }
        super.func_82167_n(entityIn);
    }

    public void func_70074_a(LivingEntity entityLivingIn) {
        super.func_70074_a(entityLivingIn);
    }

    public void func_174812_G() {
        super.func_174812_G();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70143_R = 0.0f;
        if (this.func_110143_aJ() < 1.0f && !this.deathExplosion && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.DESTROY);
            this.deathExplosion = true;
        }
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public void func_184777_r_() {
    }
}

