/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.item.gun;

import com.swdteam.wotwmod.common.entity.projectile.MusketBallEntity;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.item.tools.ToolBasicItem;
import com.swdteam.wotwmod.common.utils.ItemUtils;
import com.swdteam.wotwmod.common.utils.MathUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Gun
extends ToolBasicItem {
    int techLevel = 0;
    Item ammo;
    int durability = 0;
    int damage;
    int windupTime;
    Supplier<SoundEvent> shootSound;
    boolean isAutomatic = false;

    public Gun(ItemGroup tab, int durability, Item ammo, int techLevel, int damage, int windupTime) {
        super(tab, durability);
        this.techLevel = techLevel;
        this.durability = durability;
        this.ammo = ammo;
        this.damage = damage;
        this.windupTime = windupTime;
        this.shootSound = WOTWSounds.SOUND_ENTITY_GUNSHOT;
        this.isAutomatic = false;
    }

    public Gun(ItemGroup tab, int durability, Item ammo, int techLevel, int damage, int windupTime, Supplier<SoundEvent> shootSound) {
        super(tab, durability);
        this.techLevel = techLevel;
        this.durability = durability;
        this.ammo = ammo;
        this.damage = damage;
        this.windupTime = windupTime;
        this.shootSound = shootSound;
        this.isAutomatic = false;
    }

    public Gun(ItemGroup tab, int durability, Item ammo, int techLevel, int damage, int windupTime, Supplier<SoundEvent> shootSound, boolean isAutomatic) {
        super(tab, durability);
        this.techLevel = techLevel;
        this.durability = durability;
        this.ammo = ammo;
        this.damage = damage;
        this.windupTime = windupTime;
        this.shootSound = shootSound;
        this.isAutomatic = isAutomatic;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemUtils.addText(tooltip, "Ammo Type: " + this.ammo.func_200296_o().func_150254_d(), TextFormatting.GOLD);
        ItemUtils.addText(tooltip, "Damage: " + this.damage, TextFormatting.RED);
        ItemUtils.addText(tooltip, "Windup Time: " + this.windupTime, TextFormatting.BLUE);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (!this.isAutomatic) {
            return UseAction.BOW;
        }
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        if (!this.isAutomatic) {
            return 72000;
        }
        return 1000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (this.isAutomatic) {
            this.func_77615_a(player.func_184614_ca(), player.field_70170_p, player, 0);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (stack.func_77988_m() - timeLeft > this.windupTime && (ItemUtils.playerHasNumberOfItem(player, this.ammo, 1) || player.func_184812_l_())) {
            this.shoot(player);
            if (!player.func_184812_l_()) {
                ItemUtils.consumeItem(player, this.ammo);
            }
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public void shoot(PlayerEntity player) {
        MusketBallEntity musketball = new MusketBallEntity(player.field_70170_p, (LivingEntity)player, 0.0f, this.damage);
        player.func_184185_a(this.shootSound.get(), 0.4f, (float)MathUtils.randomDouble(0.7, 1.0));
        for (int i = 0; i < 4; ++i) {
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, player.func_226282_d_(0.5), player.func_226279_cv_(), player.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        player.func_184607_cu().func_222118_a(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.func_213334_d(player.func_184600_cs()));
        musketball.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 4.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)musketball);
    }

    @Override
    public void setTechLevel(int techLevel) {
        this.techLevel = techLevel;
    }

    public void setDurability(int durability) {
        this.durability = durability;
    }

    public void setAmmo(Item ammo) {
        this.ammo = ammo;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setShootSound(Supplier<SoundEvent> shootSound) {
        this.shootSound = shootSound;
    }
}

