/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.misc;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="wotwmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WOTWConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue dev_overlay;
        public final ForgeConfigSpec.BooleanValue title_screen;
        public final ForgeConfigSpec.BooleanValue item_overlay;
        public final ForgeConfigSpec.BooleanValue red_fog_effect;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("War of the Worlds Mod Config (Client-Side)").push("WOTWMod");
            this.dev_overlay = builder.comment("Enabled the dev overlay (will be nuked eventually)").translation("wotwmod.config.devui").worldRestart().define("dev_ui", false);
            this.title_screen = builder.comment("Enable or disable the custom title screen").translation("wotwmod.config.title").worldRestart().define("titleScreen", true);
            this.item_overlay = builder.comment("Enable or disable the custom item display at the top right").translation("wotwmod.config.item_overlay").worldRestart().define("item_overlay", true);
            this.red_fog_effect = builder.comment("Red Mist in the overworld").translation("wotwmod.config.red_mist").worldRestart().define("red_fog_effect", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue redweed_spread_enabled;
        public final ForgeConfigSpec.BooleanValue molotov_enabled;
        public final ForgeConfigSpec.BooleanValue martian_mining_laser_enabled;
        public final ForgeConfigSpec.BooleanValue rpg_enabled;
        public final ForgeConfigSpec.BooleanValue nuke_enabled;
        public final ForgeConfigSpec.BooleanValue vanilla_mobs;
        public final ForgeConfigSpec.IntValue dynamite_radius;
        public final ForgeConfigSpec.IntValue redweed_rarity;
        public final ForgeConfigSpec.DoubleValue martian_light_level_spawn;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("War Of The Worlds Mod (Common Config)");
            builder.comment("War of the Worlds Mod Config").push("WOTWMod [General]");
            this.redweed_spread_enabled = builder.comment("Enables and disables the spreading of all redweed blocks").translation("wotwmod.config.redwedspread").worldRestart().define("redweed_spread", true);
            this.redweed_rarity = builder.comment("The higher this value, the slower redweed spreads (default 300)").translation("wotwmod.config.redweed_spread").worldRestart().defineInRange("redweedspread", 300, 30, 100000);
            this.martian_light_level_spawn = builder.comment("Configures the light level martians can spawn in 0.5 is daylight").translation("wotwmod.config.redwedspread").worldRestart().defineInRange("martian_light_level_spawn", 0.5, 0.0, 1.0);
            this.vanilla_mobs = builder.comment("Configures whether hostile vanilla mobs will spawn naturally").translation("wotwmod.config.vanilla_mobs").worldRestart().define("vanilla_mobs", true);
            builder.pop();
            builder.comment("War of the Worlds Mod Config").push("WOTWMod [Greifing]");
            this.molotov_enabled = builder.comment("Enables and disables Molotovs").translation("wotwmod.config.molotov").worldRestart().define("molotov_enabled", true);
            this.martian_mining_laser_enabled = builder.comment("Enables and disables the martian mining laser").translation("wotwmod.config.martian_mining_laser").worldRestart().define("martian_mining_laser_enabled", true);
            this.rpg_enabled = builder.comment("Enables and disables the rpg").translation("wotwmod.config.rpg_enabled").worldRestart().define("rpg_enabled", true);
            this.dynamite_radius = builder.comment("Changes the blast radius of miners tnt").translation("wotwmod.config.tnt_radius").worldRestart().defineInRange("mining_tnt_radius", 5, 0, 30);
            this.nuke_enabled = builder.comment("Enables and disables the nuke block").translation("wotwmod.config.nuke_enabled").worldRestart().define("nuke_enabled", true);
            builder.pop();
        }
    }
}

