/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.registry;

import com.swdteam.wotwmod.common.block.ItemBaseBlock;
import com.swdteam.wotwmod.common.item.SpawnerItem;
import com.swdteam.wotwmod.common.misc.WOTWTabs;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class DashRegistryBuilder {
    public DashRegistryBuilder() {
        System.out.println("DashRegistryBuilder 1.0.0 building for wotwmod");
    }

    public static RegistryObject<Block> buildBlock(DeferredRegister<Block> register, String registryName, Block block) {
        RegistryObject BLOCK = register.register(registryName, () -> block);
        return BLOCK;
    }

    public static RegistryObject<Item> buildBlockItem(DeferredRegister<Item> register, String registryName, Block block, ItemGroup group) {
        RegistryObject ITEM = register.register(registryName, () -> new ItemBaseBlock(block, group));
        return ITEM;
    }

    public static RegistryObject<Item> buildSpawnItem(DeferredRegister<Item> register, String registryName, String mobId) {
        RegistryObject SPAWNER = register.register(registryName, () -> new SpawnerItem(WOTWTabs.TAB_MOBS, mobId));
        return SPAWNER;
    }

    public static RegistryObject<Biome> buildBiome(DeferredRegister<Biome> register, String registryName, Biome biome) {
        RegistryObject BIOME = register.register(registryName, () -> biome);
        return BIOME;
    }

    public static RegistryObject<Item> buildItem(DeferredRegister<Item> register, String registryName, Item item, ItemGroup group) {
        RegistryObject ITEM = register.register(registryName, () -> item);
        return ITEM;
    }

    public static RegistryObject<SoundEvent> buildSound(DeferredRegister<SoundEvent> register, String registryName) {
        RegistryObject SOUND = register.register(registryName, () -> new SoundEvent(new ResourceLocation("wotwmod", registryName)));
        return SOUND;
    }
}

