/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.world.mars;

import com.google.common.collect.ImmutableSet;
import com.swdteam.wotwmod.common.init.WOTWBiomes;
import com.swdteam.wotwmod.common.world.mars.MarsBiomeProviderSettings;
import com.swdteam.wotwmod.common.world.mars.VoronoiGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;

public class MarsBiomeProvider
extends BiomeProvider {
    private static final Set<Biome> biomeList = ImmutableSet.of((Object)WOTWBiomes.MARS_BIOME.get(), (Object)WOTWBiomes.MARS_BIOME_DESERT.get(), (Object)WOTWBiomes.MARS_BIOME_MOUNTAIN.get(), (Object)WOTWBiomes.MARS_BIOME_QUARRY.get(), (Object)WOTWBiomes.MARS_BIOME_LUSH.get(), (Object)WOTWBiomes.MARS_BIOME_LUSH_HEIGHTS.get(), (Object[])new Biome[0]);
    private Random rand = new Random();
    private final double biomeSize = 16.0;
    private VoronoiGenerator biomeNoise = new VoronoiGenerator();

    public MarsBiomeProvider(MarsBiomeProviderSettings settings) {
        super(biomeList);
        this.biomeNoise.setSeed((int)settings.getSeed());
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.getBiome(new LinkedList<Biome>(biomeList), this.biomeNoise.getValue((double)x / 16.0, (double)y / 16.0, (double)z / 16.0));
    }

    public Biome getBiome(List<Biome> biomeList, double noiseVal) {
        for (int i = biomeList.size(); i >= 0; --i) {
            if (!(noiseVal > (double)(2.0f / (float)biomeList.size() * (float)i - 1.0f))) continue;
            return biomeList.get(i);
        }
        return biomeList.get(biomeList.size() - 1);
    }
}

