/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityCanvas;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class RenderEntityCanvas
extends EntityRenderer<EntityCanvas> {
    public static RenderEntityCanvas theInstance;
    private static final ResourceLocation backLocation;
    private static final int[] EMPTY_PIXELS;
    private final TextureManager textureManager;
    private final Map<String, Instance> loadedCanvases = Maps.newHashMap();

    RenderEntityCanvas(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.textureManager = Minecraft.m_91087_().f_90987_;
    }

    @Nullable
    public ResourceLocation getTextureLocation(EntityCanvas entity) {
        return this.getCanvasRendererInstance((EntityCanvas)entity).location;
    }

    public void render(EntityCanvas entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        this.getCanvasRendererInstance(entity).render(entity, entityYaw, entity.m_146909_(), matrixStackIn, bufferIn, entity.m_6350_(), packedLightIn);
    }

    public void updateMapTexture(String name, int version) {
        Instance instance = this.getMapInstanceIfExists(name);
        if (instance != null) {
            instance.updateCanvasTexture(name, version);
        }
    }

    private Instance getCanvasRendererInstance(EntityCanvas canvas) {
        return this.getCanvasRendererInstance(canvas.getCanvasName(), canvas.getCanvasVersion(), canvas.m_7076_(), canvas.m_7068_());
    }

    Instance getCanvasRendererInstance(CompoundTag tag, int width, int height) {
        String name = tag.m_128461_("name");
        int version = tag.m_128451_("v");
        if (!EntityCanvas.PICTURES.containsKey(name) || EntityCanvas.PICTURES.get((Object)name).version < version) {
            EntityCanvas.PICTURES.put(name, new EntityCanvas.Picture(version, tag.m_128465_("pixels")));
        }
        return this.getCanvasRendererInstance(name, version, width, height);
    }

    Instance getCanvasRendererInstance(String name, int version, int width, int height) {
        Instance instance = this.loadedCanvases.get(name);
        if (instance == null) {
            instance = new Instance(name, version, width, height);
            this.loadedCanvases.put(name, instance);
        } else if (instance.version < version || !instance.loaded) {
            instance.updateCanvasTexture(name, version);
        }
        return instance;
    }

    @Nullable
    public Instance getMapInstanceIfExists(String name) {
        return this.loadedCanvases.get(name);
    }

    public void clearLoadedCanvases() {
        for (Instance instance : this.loadedCanvases.values()) {
            instance.close();
        }
        this.loadedCanvases.clear();
    }

    public void close() {
        this.clearLoadedCanvases();
    }

    static {
        backLocation = new ResourceLocation("minecraft", "textures/block/birch_planks.png");
        EMPTY_PIXELS = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            RenderEntityCanvas.EMPTY_PIXELS[i] = PaletteUtil.Color.WHITE.rgbVal();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Instance
    implements AutoCloseable {
        int version = 0;
        int width;
        int height;
        boolean loaded = false;
        boolean started = false;
        public final DynamicTexture canvasTexture;
        public final ResourceLocation location;

        private Instance(String name, int version, int width, int height) {
            this.width = width;
            this.height = height;
            this.canvasTexture = new DynamicTexture(width, height, true);
            this.location = RenderEntityCanvas.this.textureManager.m_118490_("canvas/" + name, this.canvasTexture);
            this.updateCanvasTexture(name, version);
        }

        private int swapColor(int color) {
            int i = (color & 0xFF0000) >> 16;
            int j = (color & 0xFF00) >> 8;
            int k = color & 0xFF;
            return k << 16 | j << 8 | i;
        }

        private void updateCanvasTexture(String name, int version) {
            this.version = version;
            int[] pixels = EMPTY_PIXELS;
            if (EntityCanvas.PICTURES.containsKey(name)) {
                pixels = EntityCanvas.PICTURES.get((Object)name).pixels;
                this.loaded = true;
            }
            if (this.loaded || !this.started) {
                if (pixels.length < this.height * this.width) {
                    XercaPaint.LOGGER.warn("Pixels array length (" + pixels.length + ") is smaller than canvas area (" + this.height * this.width + ")");
                    return;
                }
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int k = j + i * this.width;
                        this.canvasTexture.m_117991_().m_84988_(j, i, this.swapColor(pixels[k]));
                    }
                }
                this.canvasTexture.m_117985_();
            }
            this.started = true;
        }

        public void render(@Nullable EntityCanvas canvas, float yaw, float pitch, PoseStack ms, MultiBufferSource buffer, Direction facing, int packedLight) {
            float wScale = (float)this.width / 16.0f;
            float hScale = (float)this.height / 16.0f;
            ms.m_85836_();
            Matrix3f mn = ms.m_85850_().m_85864_().m_8183_();
            float xOffset = facing.m_122429_();
            float yOffset = facing.m_122430_();
            float zOffset = facing.m_122431_();
            if (canvas != null && canvas.getRotation() > 0) {
                ms.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
                ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
                ms.m_85845_(Vector3f.f_122227_.m_122240_((float)(90 * canvas.getRotation())));
                ms.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f + yaw));
                ms.m_85845_(Vector3f.f_122223_.m_122240_(-pitch));
            }
            ms.m_85850_().m_85864_().m_8169_(mn);
            float f = 0.03125f;
            if (canvas != null) {
                if (facing.m_122434_().m_122479_()) {
                    ms.m_85837_((double)zOffset * 0.5 * (double)wScale, -0.5 * (double)hScale, (double)(-xOffset) * 0.5 * (double)wScale);
                } else {
                    ms.m_85837_(0.5 * (double)wScale, (double)(0.0f * hScale), (yOffset > 0.0f ? 0.5 : -0.5) * (double)wScale);
                }
            } else {
                ms.m_85837_(0.75, 0.5, 0.5);
                f = wScale > 1.0f || hScale > 1.0f ? (f /= 3.3f) : (f /= 2.0f);
            }
            ms.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
            ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
            ms.m_85841_(f, f, f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
            Matrix4f m = ms.m_85850_().m_85861_();
            mn = ms.m_85850_().m_85864_();
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.location));
            this.addVertex(vb, m, mn, 0.0, 32.0f * hScale, -1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0f * wScale, 32.0f * hScale, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0f * wScale, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            vb = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)backLocation));
            float sideWidth = 0.0625f;
            RenderSystem.m_157456_((int)0, (ResourceLocation)backLocation);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, 1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 1.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 1.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 32.0 * (double)hScale, -1.0, 0.0f, 0.0625f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 0.0f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 32.0 * (double)hScale, 1.0, 0.0625f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 0.0625f, 0.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, -1.0, 0.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, -1.0, 1.0f, 1.0f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 32.0 * (double)wScale, 0.0, 1.0, 1.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
            this.addVertex(vb, m, mn, 0.0, 0.0, 1.0, 0.0f, 0.9375f, packedLight, xOffset, yOffset, zOffset);
            ms.m_85849_();
        }

        private void addVertex(VertexConsumer vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
            vb.m_85982_(m, (float)x, (float)y, (float)z).m_6122_(255, 255, 255, 255).m_7421_(tx, ty).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_85977_(mn, xOff, yOff, zOff).m_5752_();
        }

        private void addVertexFront(VertexConsumer vb, Matrix4f m, Matrix3f mn, double x, double y, double z, float tx, float ty, int lightmap, float xOff, float yOff, float zOff) {
            vb.m_85982_(m, (float)x, (float)y, (float)z).m_6122_(255, 255, 255, 255).m_7421_(tx, ty).m_85969_(lightmap).m_5752_();
        }

        @Override
        public void close() {
            this.canvasTexture.close();
        }
    }

    public static class RenderEntityCanvasFactory
    implements EntityRendererProvider<EntityCanvas> {
        public EntityRenderer<EntityCanvas> m_174009_(EntityRendererProvider.Context ctx) {
            theInstance = new RenderEntityCanvas(ctx);
            return theInstance;
        }
    }
}

