/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.lwjgl.system.NonnullDefault;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.entity.EntityCanvas;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.item.RenderProp;

@NonnullDefault
public class ItemCanvas
extends HangingEntityItem {
    private CanvasType canvasType;

    ItemCanvas(String name, CanvasType canvasType) {
        super(Entities.CANVAS, new Item.Properties().m_41491_((CreativeModeTab)Items.paintTab).m_41487_(1));
        this.setRegistryName(name);
        this.canvasType = canvasType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        if (worldIn.f_46443_) {
            XercaPaint.proxy.showCanvasGui(playerIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos pos = blockpos.m_142300_(direction);
        Player playerentity = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        if (playerentity != null && !this.m_5595_(playerentity, direction, itemstack, pos)) {
            if (context.m_43725_().f_46443_) {
                XercaPaint.proxy.showCanvasGui(playerentity);
            }
        } else {
            EntityCanvas entityCanvas;
            Level world = context.m_43725_();
            CompoundTag tag = itemstack.m_41783_();
            if (tag == null || !tag.m_128441_("pixels") || !tag.m_128441_("name")) {
                if (context.m_43725_().f_46443_) {
                    XercaPaint.proxy.showCanvasGui(playerentity);
                }
                return InteractionResult.SUCCESS;
            }
            int rotation = 0;
            if (direction.m_122434_() == Direction.Axis.Y) {
                double xDiff = (double)blockpos.m_123341_() - playerentity.m_20185_();
                double zDiff = (double)blockpos.m_123343_() - playerentity.m_20189_();
                rotation = Math.abs(xDiff) > Math.abs(zDiff) ? (xDiff > 0.0 ? 1 : 3) : (zDiff > 0.0 ? 2 : 0);
                if (direction == Direction.DOWN && Math.abs(xDiff) < Math.abs(zDiff)) {
                    rotation += 2;
                }
            }
            if (!world.f_46443_ && (entityCanvas = new EntityCanvas(world, tag, pos, direction, this.canvasType, rotation)).m_7088_()) {
                entityCanvas.m_7084_();
                world.m_7967_((Entity)entityCanvas);
                itemstack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String s;
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && !StringUtil.m_14408_((String)(s = tag.m_128461_("title")))) {
            return new TextComponent(s);
        }
        return super.m_7626_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            int generation;
            CompoundTag tag = stack.m_41783_();
            String s = tag.m_128461_("author");
            if (!StringUtil.m_14408_((String)s)) {
                tooltip.add((Component)new TranslatableComponent("canvas.byAuthor", new Object[]{s}));
            }
            if ((generation = tag.m_128451_("generation")) > 0) {
                tooltip.add((Component)new TranslatableComponent("canvas.generation." + (generation - 1)).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent("canvas.empty").m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            int generation = tag.m_128451_("generation");
            return generation > 0;
        }
        return false;
    }

    public int getWidth() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int getHeight() {
        return CanvasType.getHeight(this.canvasType);
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }

    protected boolean m_5595_(Player playerIn, Direction directionIn, ItemStack itemStackIn, BlockPos posIn) {
        if (this.canvasType == CanvasType.SMALL) {
            return Level.m_46741_((BlockPos)posIn) && playerIn.m_36204_(posIn, directionIn, itemStackIn);
        }
        return !directionIn.m_122434_().m_122478_() && playerIn.m_36204_(posIn, directionIn, itemStackIn);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(RenderProp.INSTANCE);
    }
}

