/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

public class CanvasUpdatePacketHandler {
    public static void handle(CanvasUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> CanvasUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(CanvasUpdatePacket msg, ServerPlayer pl) {
        ItemStack canvas = pl.m_21205_();
        ItemStack palette = pl.m_21206_();
        if (canvas.m_41720_() == Items.ITEM_PALETTE) {
            ItemStack temp = canvas;
            canvas = palette;
            palette = temp;
        }
        if (!canvas.m_41619_() && canvas.m_41720_() instanceof ItemCanvas) {
            CompoundTag comp = canvas.m_41784_();
            comp.m_128385_("pixels", msg.getPixels());
            comp.m_128359_("name", msg.getName());
            comp.m_128405_("v", msg.getVersion());
            comp.m_128405_("generation", 0);
            if (msg.getSigned()) {
                comp.m_128359_("author", pl.m_7755_().getString());
                comp.m_128359_("title", msg.getTitle().trim());
                comp.m_128405_("generation", 1);
            }
            if (!palette.m_41619_() && palette.m_41720_() == Items.ITEM_PALETTE) {
                CompoundTag paletteComp = palette.m_41784_();
                PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

