/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;
import xerca.xercapaint.client.BasePalette;
import xerca.xercapaint.client.BrushSound;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.SoundEvents;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiCanvasEdit
extends BasePalette {
    private int canvasX;
    private int canvasY = 40;
    private int canvasWidth;
    private int canvasHeight;
    private int brushMeterX = 420;
    private int brushMeterY = 120;
    private int canvasPixelScale;
    private int canvasPixelWidth;
    private int canvasPixelHeight;
    private int brushSize = 0;
    private boolean touchedCanvas = false;
    private boolean undoStarted = false;
    private boolean gettingSigned;
    private Button buttonSign;
    private Button buttonCancel;
    private Button buttonFinalize;
    private int updateCount = 0;
    private BrushSound brushSound = null;
    private final PlayerEntity editingPlayer;
    private CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private String name = "";
    private int version = 0;
    private static final Vector2f[] outlinePoss1 = new Vector2f[]{new Vector2f(0.0f, 199.0f), new Vector2f(12.0f, 199.0f), new Vector2f(34.0f, 199.0f), new Vector2f(76.0f, 199.0f)};
    private static final Vector2f[] outlinePoss2 = new Vector2f[]{new Vector2f(128.0f, 199.0f), new Vector2f(135.0f, 199.0f), new Vector2f(147.0f, 199.0f), new Vector2f(169.0f, 199.0f)};
    private static final int maxUndoLength = 16;
    private Deque<int[]> undoStack = new ArrayDeque<int[]>(16);

    protected GuiCanvasEdit(PlayerEntity player, CompoundNBT canvasTag, CompoundNBT paletteTag, ITextComponent title, CanvasType canvasType) {
        super(title, paletteTag);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        if (canvasType.equals((Object)CanvasType.LONG)) {
            this.canvasY += 40;
        }
        this.editingPlayer = player;
        if (canvasTag != null && !canvasTag.isEmpty()) {
            int[] nbtPixels = canvasTag.func_74759_k("pixels");
            this.authorName = canvasTag.func_74779_i("author");
            this.canvasTitle = canvasTag.func_74779_i("title");
            this.name = canvasTag.func_74779_i("name");
            this.version = canvasTag.func_74762_e("v");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        } else {
            this.isSigned = false;
        }
        if (this.pixels == null) {
            this.pixels = new int[canvasPixelArea];
            Arrays.fill(this.pixels, basicColors[15].rgbVal());
            long secs = System.currentTimeMillis() / 1000L;
            this.name = "" + player.func_110124_au().toString() + "_" + secs;
        }
        if (this.paletteComplete) {
            XercaPaint.LOGGER.warn("Is complete");
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels[y * this.canvasPixelWidth + x];
    }

    private void setPixelAt(int x, int y, PaletteUtil.Color color) {
        if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight) {
            this.pixels[y * this.canvasPixelWidth + x] = color.rgbVal();
        }
    }

    private void setPixelsAt(int mouseX, int mouseY, PaletteUtil.Color color, int brushSize) {
        int pixelHalf = this.canvasPixelScale / 2;
        switch (brushSize) {
            case 0: {
                int x = (mouseX - this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x, y, color);
                break;
            }
            case 1: {
                int x = (mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x, y, color);
                this.setPixelAt(x - 1, y, color);
                this.setPixelAt(x, y - 1, color);
                this.setPixelAt(x - 1, y - 1, color);
                break;
            }
            case 2: {
                int x = (mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 1, color);
                this.setPixelAt(x, y + 1, color);
                this.setPixelAt(x - 2, y, color);
                this.setPixelAt(x - 1, y, color);
                this.setPixelAt(x, y, color);
                this.setPixelAt(x + 1, y, color);
                this.setPixelAt(x - 2, y - 1, color);
                this.setPixelAt(x - 1, y - 1, color);
                this.setPixelAt(x, y - 1, color);
                this.setPixelAt(x + 1, y - 1, color);
                this.setPixelAt(x - 1, y - 2, color);
                this.setPixelAt(x, y - 2, color);
                break;
            }
            case 3: {
                int x = (mouseX - this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 2, color);
                this.setPixelAt(x + 0, y + 2, color);
                this.setPixelAt(x + 1, y + 2, color);
                this.setPixelAt(x - 2, y + 1, color);
                this.setPixelAt(x - 1, y + 1, color);
                this.setPixelAt(x + 0, y + 1, color);
                this.setPixelAt(x + 1, y + 1, color);
                this.setPixelAt(x + 2, y + 1, color);
                this.setPixelAt(x - 2, y, color);
                this.setPixelAt(x - 1, y, color);
                this.setPixelAt(x + 0, y, color);
                this.setPixelAt(x + 1, y, color);
                this.setPixelAt(x + 2, y, color);
                this.setPixelAt(x - 2, y - 1, color);
                this.setPixelAt(x - 1, y - 1, color);
                this.setPixelAt(x + 0, y - 1, color);
                this.setPixelAt(x + 1, y - 1, color);
                this.setPixelAt(x + 2, y - 1, color);
                this.setPixelAt(x - 1, y - 2, color);
                this.setPixelAt(x + 0, y - 2, color);
                this.setPixelAt(x + 1, y - 2, color);
            }
        }
    }

    public void func_231160_c_() {
        int padding = 40;
        int paletteCanvasX = (this.field_230708_k_ - (157 + this.canvasWidth + 40)) / 2;
        this.canvasX = paletteCanvasX + 157 + 40;
        paletteX = paletteCanvasX;
        paletteY = 40;
        this.brushMeterX = this.canvasX + this.canvasWidth + 2;
        GLFW.glfwSetInputMode((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)208897, (int)212994);
        int x = this.canvasX;
        int y = this.canvasY + this.canvasHeight + 10;
        this.buttonSign = (Button)this.func_230480_a_((Widget)new Button(x, y, 98, 20, (ITextComponent)new TranslationTextComponent("canvas.signButton"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = true;
                this.updateButtons();
                GLFW.glfwSetInputMode((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)208897, (int)212993);
            }
        }));
        this.buttonFinalize = (Button)this.func_230480_a_((Widget)new Button(this.canvasX - 100, 100, 98, 20, (ITextComponent)new TranslationTextComponent("canvas.finalizeButton"), button -> {
            if (!this.isSigned) {
                this.dirty = true;
                this.isSigned = true;
                if (this.field_230706_i_ != null) {
                    this.field_230706_i_.func_147108_a(null);
                }
            }
        }));
        this.buttonCancel = (Button)this.func_230480_a_((Widget)new Button(this.canvasX - 100, 130, 98, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = false;
                this.updateButtons();
                GLFW.glfwSetInputMode((long)this.getMinecraft().func_228018_at_().func_198092_i(), (int)208897, (int)212994);
            }
        }));
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.buttonSign.field_230694_p_ = !this.gettingSigned;
            this.buttonCancel.field_230694_p_ = this.gettingSigned;
            this.buttonFinalize.field_230694_p_ = this.gettingSigned;
            this.buttonFinalize.field_230693_o_ = !this.canvasTitle.trim().isEmpty();
        }
    }

    public void func_231023_e_() {
        ++this.updateCount;
        super.func_231023_e_();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float f) {
        int i;
        if (!this.gettingSigned) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, f);
        } else {
            super.superRender(matrixStack, mouseX, mouseY, f);
        }
        for (i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int y = this.canvasY + i * this.canvasPixelScale;
                int x = this.canvasX + j * this.canvasPixelScale;
                GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + this.canvasPixelScale), (int)(y + this.canvasPixelScale), (int)this.getPixelAt(j, i));
            }
        }
        if (!this.gettingSigned) {
            for (i = 0; i < 4; ++i) {
                int y = this.brushMeterY + i * 9;
                GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)this.brushMeterX, (int)y, (int)(this.brushMeterX + 3), (int)(y + 3), (int)this.currentColor.rgbVal());
            }
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(matrixStack, this.brushMeterX, this.brushMeterY + (3 - this.brushSize) * 9, 15, 246, 10, 10);
            this.func_238474_b_(matrixStack, this.brushMeterX, this.brushMeterY, 0, 220, 9, 36);
            this.renderCursor(matrixStack, mouseX, mouseY);
        } else {
            this.drawSigning(matrixStack);
        }
    }

    private void renderCursor(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isCarryingColor) {
            this.carriedColor.setGLColor();
            this.func_238474_b_(matrixStack, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isCarryingWater) {
            waterColor.setGLColor();
            this.func_238474_b_(matrixStack, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isPickingColor) {
            this.drawOutline(matrixStack, mouseX, mouseY, 0);
            PaletteUtil.Color.WHITE.setGLColor();
            this.func_238474_b_(matrixStack, mouseX, mouseY - 14, 25, 242, 14, 14);
        } else {
            this.drawOutline(matrixStack, mouseX, mouseY, this.brushSize);
            GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)mouseX, (int)mouseY, (int)(mouseX + 3), (int)(mouseY + 3), (int)this.currentColor.rgbVal());
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int trueBrushY = 247 - 9 * this.brushSize;
            this.func_238474_b_(matrixStack, mouseX, mouseY, 0, trueBrushY, 9, 9);
        }
    }

    private void drawOutline(MatrixStack matrixStack, int mouseX, int mouseY, int brushSize) {
        if (this.inCanvas(mouseX, mouseY)) {
            int x = 0;
            int y = 0;
            int outlineSize = 0;
            int pixelHalf = this.canvasPixelScale / 2;
            if (brushSize == 0) {
                x = (mouseX - this.canvasX) / this.canvasPixelScale * this.canvasPixelScale + this.canvasX - 1;
                y = (mouseY - this.canvasY) / this.canvasPixelScale * this.canvasPixelScale + this.canvasY - 1;
                outlineSize = this.canvasPixelScale + 2;
            }
            if (brushSize == 1) {
                x = ((mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + this.canvasX - 1;
                y = ((mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 2 + 2;
            }
            if (brushSize == 2) {
                x = ((mouseX - this.canvasX + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasX - 1;
                y = ((mouseY - this.canvasY + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 4 + 2;
            }
            if (brushSize == 3) {
                x = ((mouseX - this.canvasX) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasX - 1;
                y = ((mouseY - this.canvasY) / this.canvasPixelScale - 2) * this.canvasPixelScale + this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 5 + 2;
            }
            Vector2f textureVec = this.canvasPixelScale == 10 ? outlinePoss1[brushSize] : outlinePoss2[brushSize];
            GlStateManager.func_227702_d_((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            this.func_238474_b_(matrixStack, x, y, (int)textureVec.field_189982_i, (int)textureVec.field_189983_j, outlineSize, outlineSize);
        }
    }

    private void drawSigning(MatrixStack matrixStack) {
        int i = this.canvasX;
        int j = this.canvasY;
        GuiCanvasEdit.func_238467_a_((MatrixStack)matrixStack, (int)(i + 10), (int)(j + 10), (int)(i + 150), (int)(j + 150), (int)-1118482);
        String s = this.canvasTitle;
        if (!this.isSigned) {
            s = this.updateCount / 6 % 2 == 0 ? s + "" + TextFormatting.BLACK + "_" : s + "" + TextFormatting.GRAY + "_";
        }
        String s1 = I18n.func_135052_a((String)"canvas.editTitle", (Object[])new Object[0]);
        int k = this.field_230712_o_.func_78256_a(s1);
        this.field_230712_o_.func_238421_b_(matrixStack, s1, (float)(i + 26) + (float)(116 - k) / 2.0f, (float)(j + 16 + 16), 0);
        int l = this.field_230712_o_.func_78256_a(s);
        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(i + 26) + (float)(116 - l) / 2.0f, (float)(j + 48), 0);
        String s2 = I18n.func_135052_a((String)"canvas.byAuthor", (Object[])new Object[]{this.editingPlayer.func_200200_C_().getString()});
        int i1 = this.field_230712_o_.func_78256_a(s2);
        this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + s2, (float)(i + 26 + (116 - i1) / 2), (float)(j + 48 + 10), 0);
        this.field_230712_o_.func_238418_a_((ITextProperties)new TranslationTextComponent("canvas.finalizeWarning"), i + 26, j + 80, 116, 0);
    }

    private void playBrushSound() {
        this.brushSound = new BrushSound();
        this.playSound((ISound)this.brushSound);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.gettingSigned) {
            switch (keyCode) {
                case 259: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.canvasTitle = this.canvasTitle.substring(0, this.canvasTitle.length() - 1);
                    this.updateButtons();
                    break;
                }
                case 257: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.dirty = true;
                    this.isSigned = true;
                    this.field_230706_i_.func_147108_a(null);
                    break;
                }
            }
            return true;
        }
        if (keyCode == 90 && (modifiers & 2) == 2) {
            if (this.undoStack.size() > 0) {
                this.pixels = this.undoStack.pop();
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int something) {
        super.func_231042_a_(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.canvasTitle.length() < 16 && SharedConstants.func_71566_a((char)typedChar)) {
                this.canvasTitle = this.canvasTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        if (!this.gettingSigned && scroll != 0.0) {
            int maxBrushSize = 3;
            this.brushSize += scroll > 0.0 ? 1 : -1;
            if (this.brushSize > 3) {
                this.brushSize = 0;
            } else if (this.brushSize < 0) {
                this.brushSize = 3;
            }
            return true;
        }
        return super.func_231043_a_(x, y, scroll);
    }

    @Override
    public boolean func_231044_a_(double posX, double posY, int mouseButton) {
        int selectedSize;
        if (this.gettingSigned) {
            return super.superMouseClicked(posX, posY, mouseButton);
        }
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        this.undoStarted = true;
        this.touchedCanvas = false;
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        this.undoStack.push((int[])this.pixels.clone());
        if (this.inCanvas(mouseX, mouseY)) {
            if (this.isPickingColor) {
                int x = (mouseX - this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - this.canvasY) / this.canvasPixelScale;
                if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight) {
                    int color = this.getPixelAt(x, y);
                    this.carriedColor = new PaletteUtil.Color(color);
                    this.setCarryingColor();
                    this.playSound(SoundEvents.COLOR_PICKER_SUCK);
                }
            } else {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
                this.playBrushSound();
            }
        }
        if (this.inBrushMeter(mouseX, mouseY) && (selectedSize = 3 - (mouseY - this.brushMeterY) / 9) >= 0) {
            this.brushSize = selectedSize;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private void clickedCanvas(int mouseX, int mouseY, int mouseButton) {
        this.touchedCanvas = true;
        if (mouseButton == 0) {
            this.setPixelsAt(mouseX, mouseY, this.currentColor, this.brushSize);
        } else if (mouseButton == 1) {
            this.setPixelsAt(mouseX, mouseY, PaletteUtil.Color.WHITE, this.brushSize);
        }
        this.dirty = true;
    }

    @Override
    public boolean func_231048_c_(double posX, double posY, int mouseButton) {
        if (this.gettingSigned) {
            return super.superMouseReleased(posX, posY, mouseButton);
        }
        if (this.undoStarted && !this.touchedCanvas) {
            this.undoStarted = false;
            this.undoStack.removeFirst();
        }
        if (this.brushSound != null) {
            this.brushSound.stopSound();
        }
        return super.func_231048_c_(posX, posY, mouseButton);
    }

    public boolean func_231045_a_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        if (this.gettingSigned) {
            return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
        }
        if (!(this.isCarryingColor || this.isCarryingWater || this.isPickingColor)) {
            int mouseY;
            int mouseX = (int)Math.floor(posX);
            if (this.inCanvas(mouseX, mouseY = (int)Math.floor(posY))) {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
            }
            if (this.brushSound != null) {
                this.brushSound.refreshFade();
            }
        }
        return super.func_231045_a_(posX, posY, mouseButton, deltaX, deltaY);
    }

    private boolean inCanvas(int x, int y) {
        return x < this.canvasX + this.canvasWidth && x >= this.canvasX && y < this.canvasY + this.canvasHeight && y >= this.canvasY;
    }

    private boolean inBrushMeter(int x, int y) {
        return x < this.brushMeterX + 9 && x >= this.brushMeterX && y < this.brushMeterY + 36 && y >= this.brushMeterY;
    }

    public void func_231164_f_() {
        if (this.dirty) {
            ++this.version;
            CanvasUpdatePacket pack = new CanvasUpdatePacket(this.pixels, this.isSigned, this.canvasTitle, this.name, this.version, this.customColors, this.canvasType);
            XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
        }
    }
}

