/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercapaint.common.CanvasType;

@OnlyIn(value=Dist.CLIENT)
public class GuiCanvasView
extends Screen {
    private int canvasX;
    private int canvasY = 40;
    private int canvasWidth;
    private int canvasHeight;
    private int canvasPixelScale;
    private int canvasPixelWidth;
    private int canvasPixelHeight;
    private CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private String name = "";
    private int version = 0;
    private int generation = 0;

    protected GuiCanvasView(CompoundNBT canvasTag, ITextComponent title, CanvasType canvasType) {
        super(title);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        if (canvasTag != null && !canvasTag.isEmpty()) {
            int[] nbtPixels = canvasTag.func_74759_k("pixels");
            this.authorName = canvasTag.func_74779_i("author");
            this.canvasTitle = canvasTag.func_74779_i("title");
            this.name = canvasTag.func_74779_i("name");
            this.version = canvasTag.func_74762_e("v");
            this.generation = canvasTag.func_74762_e("generation");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        } else {
            this.isSigned = false;
        }
    }

    public void func_231160_c_() {
        this.canvasX = (this.field_230708_k_ - this.canvasWidth) / 2;
        if (this.canvasType.equals((Object)CanvasType.LONG)) {
            this.canvasY += 40;
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels == null ? -393218 : this.pixels[y * this.canvasPixelWidth + x];
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float f) {
        for (int i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int x = this.canvasX + j * this.canvasPixelScale;
                int y = this.canvasY + i * this.canvasPixelScale;
                GuiCanvasView.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + this.canvasPixelScale), (int)(y + this.canvasPixelScale), (int)this.getPixelAt(j, i));
            }
        }
        if (this.generation > 0 && !this.canvasTitle.isEmpty()) {
            String title = this.canvasTitle + " " + I18n.func_135052_a((String)"canvas.byAuthor", (Object[])new Object[]{this.authorName});
            String gen = "(" + I18n.func_135052_a((String)("canvas.generation." + (this.generation - 1)), (Object[])new Object[0]) + ")";
            int titleWidth = this.field_230712_o_.func_78256_a(title);
            int genWidth = this.field_230712_o_.func_78256_a(gen);
            float titleX = (float)this.canvasX + (float)(this.canvasWidth - titleWidth) / 2.0f;
            float genX = (float)this.canvasX + (float)(this.canvasWidth - genWidth) / 2.0f;
            float minX = Math.min(genX, titleX);
            float maxX = Math.max(genX + (float)genWidth, titleX + (float)titleWidth);
            GuiCanvasView.func_238467_a_((MatrixStack)matrixStack, (int)((int)(minX - 10.0f)), (int)(this.canvasY - 30), (int)((int)(maxX + 10.0f)), (int)(this.canvasY - 4), (int)-1118482);
            this.field_230712_o_.func_238421_b_(matrixStack, title, titleX, (float)(this.canvasY - 25), -15658735);
            this.field_230712_o_.func_238421_b_(matrixStack, gen, genX, (float)(this.canvasY - 14), -12303292);
        }
    }
}

