/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.commands.SCCommand;
import net.geforcemods.securitycraft.compat.lycanitesmobs.LycanitesMobsCompat;
import net.geforcemods.securitycraft.compat.quark.QuarkCompat;
import net.geforcemods.securitycraft.compat.top.TOPDataProvider;
import net.geforcemods.securitycraft.itemgroups.SCDecorationGroup;
import net.geforcemods.securitycraft.itemgroups.SCExplosivesGroup;
import net.geforcemods.securitycraft.itemgroups.SCTechnicalGroup;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.misc.conditions.TileEntityNBTCondition;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.network.ServerProxy;
import net.geforcemods.securitycraft.util.HasManualPage;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.conditions.LootConditionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="securitycraft")
@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SecurityCraft {
    public static final String MODID = "securitycraft";
    public static IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final String PROTOCOL_VERSION = "3";
    public static SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("securitycraft", "securitycraft"), () -> "3", "3"::equals, "3"::equals);
    public static ItemGroup groupSCTechnical = new SCTechnicalGroup();
    public static ItemGroup groupSCMine = new SCExplosivesGroup();
    public static ItemGroup groupSCDecoration = new SCDecorationGroup();
    public static final LootConditionType TILE_ENTITY_NBT_LOOT_CONDITION = LootConditionManager.func_237475_a_((String)"securitycraft:tile_entity_nbt", (ILootSerializer)new TileEntityNBTCondition.Serializer());

    public SecurityCraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigHandler.SERVER_SPEC);
        SCContent.BLOCKS.register(modEventBus);
        SCContent.FLUIDS.register(modEventBus);
        SCContent.ITEMS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        RegistrationHandler.registerPackets();
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", ReinforcedHopperBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadChestBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasswordConvertible", KeypadFurnaceBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", CommonDoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", InventoryScannerBlock.DoorActivator::new);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPDataProvider::new);
        }
        if (ModList.get().isLoaded("lycanitesmobs")) {
            InterModComms.sendTo((String)MODID, (String)"registerSentryAttackTargetCheck", LycanitesMobsCompat::new);
        }
        if (ModList.get().isLoaded("quark")) {
            QuarkCompat.registerChestConversions();
        }
        proxy.tint();
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        for (Field field : SCContent.class.getFields()) {
            try {
                Item item;
                if (field.isAnnotationPresent(Reinforced.class)) {
                    Block block = (Block)((RegistryObject)field.get(null)).get();
                    IReinforcedBlock rb = (IReinforcedBlock)block;
                    IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.put(rb.getVanillaBlock(), block);
                    IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.put(block, rb.getVanillaBlock());
                }
                if (!field.isAnnotationPresent(HasManualPage.class)) continue;
                IForgeRegistryEntry o = ((RegistryObject)field.get(null)).get();
                HasManualPage hmp = field.getAnnotation(HasManualPage.class);
                boolean isBlock = true;
                if (o instanceof Block) {
                    item = ((Block)o).func_199767_j();
                } else {
                    item = (Item)o;
                    isBlock = false;
                }
                String key = hmp.specialInfoKey().isEmpty() ? (isBlock ? "help" : "help.") + item.func_77658_a().substring(5) + ".info" : hmp.specialInfoKey();
                SCManualPage page = new SCManualPage(item, new TranslationTextComponent(key));
                if (!hmp.designedBy().isEmpty()) {
                    page.setDesignedBy(hmp.designedBy());
                }
                if (hmp.hasRecipeDescription()) {
                    page.setHasRecipeDescription(true);
                }
                SCManualItem.PAGES.add(page);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public void registerCommands(RegisterCommandsEvent event) {
        SCCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static String getVersion() {
        return ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().getQualifier();
    }
}

