/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.containers;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class KeycardReaderContainer
extends Container {
    private final Inventory itemInventory = new Inventory(1);
    public final Slot keycardSlot;
    public KeycardReaderTileEntity te;
    private IWorldPosCallable worldPosCallable;

    public KeycardReaderContainer(int windowId, PlayerInventory inventory, World world, BlockPos pos) {
        super(SCContent.cTypeKeycardReader, windowId);
        int i;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof KeycardReaderTileEntity) {
            this.te = (KeycardReaderTileEntity)tile;
        }
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, 9 + j + i * 9, 8 + j * 18, 167 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 225));
        }
        this.keycardSlot = this.func_75146_a(new Slot((IInventory)this.itemInventory, 0, 35, 86){

            public boolean func_75214_a(ItemStack stack) {
                if (!(stack.func_77973_b() instanceof KeycardItem) || stack.func_77973_b() == SCContent.LIMITED_USE_KEYCARD.get()) {
                    return false;
                }
                boolean hasTag = stack.func_77942_o();
                String ownerUUID = hasTag ? stack.func_77978_p().func_74779_i("ownerUUID") : "";
                return !hasTag || ownerUUID.isEmpty() || ownerUUID.equals(KeycardReaderContainer.this.te.getOwner().getUUID());
            }
        });
    }

    public void link() {
        ItemStack keycard = this.keycardSlot.func_75211_c();
        if (!keycard.func_190926_b()) {
            CompoundNBT tag = keycard.func_196082_o();
            tag.func_74757_a("linked", true);
            tag.func_74768_a("signature", this.te.getSignature());
            tag.func_74778_a("ownerName", this.te.getOwner().getName());
            tag.func_74778_a("ownerUUID", this.te.getOwner().getUUID());
        }
    }

    public void setKeycardUses(int uses) {
        CompoundNBT tag;
        ItemStack keycard = this.keycardSlot.func_75211_c();
        if (!keycard.func_190926_b() && (tag = keycard.func_196082_o()).func_74767_n("limited")) {
            tag.func_74768_a("uses", uses);
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.func_193327_a(player, this.te.func_145831_w(), (IInventory)this.itemInventory);
    }

    public ItemStack func_82846_b(PlayerEntity player, int id) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(id);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            if (id >= 36) {
                if (!this.func_75135_a(slotStack, 0, 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, slotStackCopy);
            } else if (id < 36 && !this.func_75135_a(slotStack, 36, 37, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return slotStackCopy;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return KeycardReaderContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)player, (Block)((Block)SCContent.KEYCARD_READER.get()));
    }
}

