/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.SecretSignTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AdminToolItem
extends Item {
    public AdminToolItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        TranslationTextComponent adminToolName = Utils.localize(this.func_77658_a(), new Object[0]);
        if (((Boolean)ConfigHandler.SERVER.allowAdminTool.get()).booleanValue()) {
            if (!player.func_184812_l_()) {
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), TextFormatting.DARK_PURPLE);
                return ActionResultType.FAIL;
            }
            ActionResultType briefcaseResult = this.handleBriefcase(player, ctx.func_221531_n()).func_188397_a();
            if (briefcaseResult != ActionResultType.PASS) {
                return briefcaseResult;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                ArrayList<ModuleType> modules;
                boolean hasInfo = false;
                if (te instanceof IOwnable) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.owner.name", ((IOwnable)te).getOwner().getName() == null ? "????" : ((IOwnable)te).getOwner().getName()), TextFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.owner.uuid", ((IOwnable)te).getOwner().getUUID() == null ? "????" : ((IOwnable)te).getOwner().getUUID()), TextFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (te instanceof IPasswordProtected) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.password", ((IPasswordProtected)te).getPassword() == null ? "????" : ((IPasswordProtected)te).getPassword()), TextFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (te instanceof IModuleInventory && !(modules = ((IModuleInventory)te).getInsertedModules()).isEmpty()) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.equippedModules", new Object[0]), TextFormatting.DARK_PURPLE);
                    for (ModuleType module : modules) {
                        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(module.getTranslationKey())), TextFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (te instanceof SecretSignTileEntity) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)new StringTextComponent(""), TextFormatting.DARK_PURPLE);
                    for (int i = 0; i < 4; ++i) {
                        ITextComponent text = ((SecretSignTileEntity)te).field_145915_a[i];
                        if (!(text instanceof IFormattableTextComponent)) continue;
                        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)text, TextFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (!hasInfo) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), TextFormatting.DARK_PURPLE);
                }
                return ActionResultType.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), TextFormatting.DARK_PURPLE);
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.disabled", new Object[0]), TextFormatting.DARK_PURPLE);
        }
        return ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.func_184812_l_()) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), TextFormatting.DARK_PURPLE);
            return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
        }
        return this.handleBriefcase(player, hand);
    }

    private ActionResult<ItemStack> handleBriefcase(PlayerEntity player, Hand hand) {
        ItemStack adminTool = player.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.func_184592_cb();
            TranslationTextComponent adminToolName = Utils.localize(this.func_77658_a(), new Object[0]);
            String ownerName = BriefcaseItem.getOwnerName(briefcase);
            String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.owner.name", ownerName.isEmpty() ? "????" : ownerName), TextFormatting.DARK_PURPLE);
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.owner.uuid", ownerUUID.isEmpty() ? "????" : ownerUUID), TextFormatting.DARK_PURPLE);
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)adminToolName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:adminTool.password", briefcase.func_77942_o() ? briefcase.func_77978_p().func_74779_i("passcode") : "????"), TextFormatting.DARK_PURPLE);
            return ActionResult.func_226248_a_((Object)adminTool);
        }
        return ActionResult.func_226250_c_((Object)adminTool);
    }
}

