/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import java.util.Calendar;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeypadChestTileEntityRenderer
extends ChestTileEntityRenderer<KeypadChestTileEntity> {
    private static final RenderMaterial ACTIVE = KeypadChestTileEntityRenderer.createMaterial("active");
    private static final RenderMaterial INACTIVE = KeypadChestTileEntityRenderer.createMaterial("inactive");
    private static final RenderMaterial LEFT_ACTIVE = KeypadChestTileEntityRenderer.createMaterial("left_active");
    private static final RenderMaterial LEFT_INACTIVE = KeypadChestTileEntityRenderer.createMaterial("left_inactive");
    private static final RenderMaterial RIGHT_ACTIVE = KeypadChestTileEntityRenderer.createMaterial("right_active");
    private static final RenderMaterial RIGHT_INACTIVE = KeypadChestTileEntityRenderer.createMaterial("right_inactive");
    private static final RenderMaterial CHRISTMAS = KeypadChestTileEntityRenderer.createMaterial("christmas");
    private static final RenderMaterial CHRISTMAS_LEFT = KeypadChestTileEntityRenderer.createMaterial("christmas_left");
    private static final RenderMaterial CHRISTMAS_RIGHT = KeypadChestTileEntityRenderer.createMaterial("christmas_right");
    protected boolean field_147509_j;

    public KeypadChestTileEntityRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.field_147509_j = true;
        }
    }

    protected RenderMaterial getMaterial(KeypadChestTileEntity te, ChestType type) {
        if (this.field_147509_j) {
            return this.getMaterialForType(type, CHRISTMAS_LEFT, CHRISTMAS_RIGHT, CHRISTMAS);
        }
        if (te.func_195480_a(0.0f) >= 0.9f) {
            return this.getMaterialForType(type, LEFT_ACTIVE, RIGHT_ACTIVE, ACTIVE);
        }
        return this.getMaterialForType(type, LEFT_INACTIVE, RIGHT_INACTIVE, INACTIVE);
    }

    private RenderMaterial getMaterialForType(ChestType type, RenderMaterial left, RenderMaterial right, RenderMaterial single) {
        switch (type) {
            case LEFT: {
                return left;
            }
            case RIGHT: {
                return right;
            }
        }
        return single;
    }

    private static RenderMaterial createMaterial(String name) {
        return new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("securitycraft", "entity/chest/" + name));
    }
}

