/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.KeycardReaderContainer;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class KeycardReaderScreen
extends ContainerScreen<KeycardReaderContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/keycard_reader.png");
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation RESET_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset.png");
    private static final ResourceLocation RESET_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset_inactive.png");
    private static final ResourceLocation RETURN_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return.png");
    private static final ResourceLocation RETURN_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/return_inactive.png");
    private static final ResourceLocation WORLD_SELECTION_ICONS = new ResourceLocation("textures/gui/world_selection.png");
    private static final ITextComponent EQUALS = new StringTextComponent("=");
    private static final ITextComponent GREATER_THAN_EQUALS = new StringTextComponent(">=");
    private final ITextComponent blockName = Utils.localize(((Block)SCContent.KEYCARD_READER.get()).func_149739_a(), new Object[0]);
    private final ITextComponent inventoryText = Utils.localize("container.inventory", new Object[0]);
    private final ITextComponent keycardLevelsText = Utils.localize("gui.securitycraft:keycard_reader.keycard_levels", new Object[0]);
    private final ITextComponent linkText = Utils.localize("gui.securitycraft:keycard_reader.link", new Object[0]);
    private final ITextComponent noSmartModule = Utils.localize("gui.securitycraft:keycard_reader.noSmartModule", new Object[0]);
    private final ITextComponent smartModule = Utils.localize("gui.securitycraft:keycard_reader.smartModule", new Object[0]);
    private final ITextComponent levelMismatchInfo = Utils.localize("gui.securitycraft:keycard_reader.level_mismatch", new Object[0]);
    private final ITextComponent limitedInfo = Utils.localize("tooltip.securitycraft:keycard.limited_info", new Object[0]);
    private final KeycardReaderTileEntity te;
    private final boolean isSmart;
    private final boolean isOwner;
    private boolean isExactLevel = true;
    private int previousSignature;
    private int signature;
    private boolean[] acceptedLevels;
    private TranslationTextComponent signatureText;
    private int signatureTextLength;
    private int signatureTextStartX;
    private Button minusThree;
    private Button minusTwo;
    private Button minusOne;
    private Button reset;
    private Button plusOne;
    private Button plusTwo;
    private Button plusThree;
    private TogglePictureButton[] toggleButtons = new TogglePictureButton[5];
    private TextFieldWidget usesTextField;
    private TextHoverChecker usesHoverChecker;
    private Button setUsesButton;
    private Button linkButton;
    private boolean firstTick = true;

    public KeycardReaderScreen(KeycardReaderContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.te = container.te;
        this.signature = this.previousSignature = this.te.getSignature();
        this.acceptedLevels = this.te.getAcceptedLevels();
        this.isSmart = this.te.hasModule(ModuleType.SMART);
        this.isOwner = this.te.getOwner().isOwner(inv.field_70458_d);
        this.field_147000_g = 249;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int buttonHeight = 13;
        int buttonY = this.field_147009_r + 35;
        int activeButtons = 0;
        int firstActiveButton = -1;
        for (int i = 0; i < 5; ++i) {
            this.toggleButtons[i] = (TogglePictureButton)this.func_230480_a_((Widget)new TogglePictureButton(i, this.field_147003_i + 100, this.field_147009_r + 50 + (i + 1) * 17, 15, 15, BEACON_GUI, new int[]{110, 88}, new int[]{219, 219}, -1, 17, 17, 21, 22, 256, 256, 2, thisButton -> {
                if (!this.isSmart) {
                    for (int otherButtonId = 0; otherButtonId < 5; ++otherButtonId) {
                        boolean active = this.isExactLevel ? otherButtonId == thisButton.id : otherButtonId >= thisButton.id;
                        this.changeLevelState(otherButtonId, active);
                    }
                } else {
                    this.acceptedLevels[thisButton.id] = !this.acceptedLevels[thisButton.id];
                }
            }));
            this.toggleButtons[i].setCurrentIndex(this.acceptedLevels[i] ? 1 : 0);
            this.toggleButtons[i].field_230693_o_ = this.isOwner;
            if (this.isSmart || !this.acceptedLevels[i]) continue;
            if (firstActiveButton == -1) {
                firstActiveButton = i;
            }
            ++activeButtons;
        }
        this.minusThree = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 22, buttonY, 24, buttonHeight, (ITextComponent)new StringTextComponent("---"), b -> this.changeSignature(this.signature - 100)));
        this.minusTwo = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 48, buttonY, 18, buttonHeight, (ITextComponent)new StringTextComponent("--"), b -> this.changeSignature(this.signature - 10)));
        this.minusOne = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 68, buttonY, 12, buttonHeight, (ITextComponent)new StringTextComponent("-"), b -> this.changeSignature(this.signature - 1)));
        this.reset = (Button)this.func_230480_a_((Widget)new PictureButton(-1, this.field_147003_i + 82, buttonY, 12, buttonHeight, RESET_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSignature(this.previousSignature)){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_230693_o_ ? RESET_TEXTURE : RESET_INACTIVE_TEXTURE;
            }
        });
        this.plusOne = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 96, buttonY, 12, buttonHeight, (ITextComponent)new StringTextComponent("+"), b -> this.changeSignature(this.signature + 1)));
        this.plusTwo = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 110, buttonY, 18, buttonHeight, (ITextComponent)new StringTextComponent("++"), b -> this.changeSignature(this.signature + 10)));
        this.plusThree = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 130, buttonY, 24, buttonHeight, (ITextComponent)new StringTextComponent("+++"), b -> this.changeSignature(this.signature + 100)));
        this.changeSignature(this.signature);
        this.linkButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 8, this.field_147009_r + 126, 70, 20, this.linkText, b -> {
            this.previousSignature = this.signature;
            this.changeSignature(this.signature);
            SecurityCraft.channel.sendToServer((Object)new SyncKeycardSettings(this.te.func_174877_v(), this.acceptedLevels, this.signature, true));
            if (((KeycardReaderContainer)this.field_147002_h).keycardSlot.func_75211_c().func_200301_q().getString().equalsIgnoreCase("Zelda")) {
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SCSounds.GET_ITEM.event, (float)1.0f, (float)1.25f));
            }
        }));
        this.linkButton.field_230693_o_ = false;
        this.setUsesButton = (Button)this.func_230480_a_((Widget)new PictureButton(-1, this.field_147003_i + 62, this.field_147009_r + 106, 16, 17, RETURN_TEXTURE, 14, 14, 2, 2, 14, 14, 14, 14, b -> SecurityCraft.channel.sendToServer((Object)new SetKeycardUses(this.te.func_174877_v(), Integer.parseInt(this.usesTextField.func_146179_b())))){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_230693_o_ ? RETURN_TEXTURE : RETURN_INACTIVE_TEXTURE;
            }
        });
        this.setUsesButton.field_230693_o_ = false;
        this.usesTextField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 28, this.field_147009_r + 107, 30, 15, StringTextComponent.field_240750_d_));
        this.usesTextField.func_200675_a(s -> s.matches("[0-9]*"));
        this.usesTextField.func_146203_f(3);
        this.usesHoverChecker = new TextHoverChecker(this.field_147009_r + 107, this.field_147009_r + 122, this.field_147003_i + 28, this.field_147003_i + 58, this.limitedInfo);
        if (!this.isSmart) {
            if (activeButtons == 1) {
                this.isExactLevel = true;
            } else if (activeButtons == 0) {
                this.isExactLevel = true;
                this.changeLevelState(0, true);
            } else {
                boolean active = false;
                this.isExactLevel = false;
                for (int i = 0; i < 5; ++i) {
                    if (i == firstActiveButton) {
                        active = true;
                    }
                    this.changeLevelState(i, active);
                }
            }
            ((ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton((int)(this.field_147003_i + 135), (int)(this.field_147009_r + 67), (int)18, (int)18, (ITextComponent)(this.isExactLevel ? KeycardReaderScreen.EQUALS : KeycardReaderScreen.GREATER_THAN_EQUALS), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$init$11(net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((KeycardReaderScreen)this)))).field_230693_o_ = this.isOwner;
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, this.blockName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockName) / 2), 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.signatureText, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.signatureText) / 2), 23.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, this.keycardLevelsText, (float)(170 - this.field_230712_o_.func_238414_a_((ITextProperties)this.keycardLevelsText)), 56.0f, 0x404040);
        for (int i = 1; i <= 5; ++i) {
            this.field_230712_o_.func_238421_b_(matrix, "" + i, 91.0f, (float)(55 + 17 * i), 0x404040);
        }
        this.field_230712_o_.func_243248_b(matrix, this.inventoryText, 8.0f, (float)(this.field_147000_g - 93), 0x404040);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ItemStack stack = ((KeycardReaderContainer)this.field_147002_h).keycardSlot.func_75211_c();
        boolean isEmpty = stack.func_190926_b();
        boolean wasActive = this.usesTextField.field_230693_o_;
        boolean hasTag = stack.func_77942_o();
        boolean enabled = !isEmpty && hasTag && stack.func_77978_p().func_74767_n("limited");
        int cardSignature = stack.func_77942_o() ? stack.func_77978_p().func_74762_e("signature") : -1;
        this.usesTextField.func_146184_c(enabled);
        this.usesTextField.field_230693_o_ = enabled;
        if (!wasActive && enabled) {
            this.usesTextField.func_146180_a("" + stack.func_77978_p().func_74762_e("uses"));
        } else if (wasActive && !enabled) {
            this.usesTextField.func_146180_a("");
        }
        if (this.firstTick) {
            this.setUsesButton.field_230693_o_ = false;
            this.linkButton.field_230693_o_ = false;
            this.firstTick = false;
        } else {
            this.setUsesButton.field_230693_o_ = enabled && this.usesTextField.func_146179_b() != null && !this.usesTextField.func_146179_b().isEmpty() && !("" + stack.func_77978_p().func_74762_e("uses")).equals(this.usesTextField.func_146179_b());
            this.linkButton.field_230693_o_ = !isEmpty && cardSignature != this.signature;
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        ItemStack stack = ((KeycardReaderContainer)this.field_147002_h).keycardSlot.func_75211_c();
        if (!stack.func_190926_b() && !this.acceptedLevels[((KeycardItem)stack.func_77973_b()).getLevel()]) {
            int left = this.field_147003_i + 40;
            int top = this.field_147009_r + 60;
            this.field_230706_i_.func_110434_K().func_110577_a(WORLD_SELECTION_ICONS);
            KeycardReaderScreen.func_238466_a_((MatrixStack)matrix, (int)left, (int)top, (int)22, (int)22, (float)70.0f, (float)37.0f, (int)22, (int)22, (int)256, (int)256);
            if (mouseX >= left - 7 && mouseX < left + 13 && mouseY >= top && mouseY <= top + 22) {
                GuiUtils.drawHoveringText((MatrixStack)matrix, Arrays.asList(this.levelMismatchInfo), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
            }
        }
        if (!this.usesTextField.field_230693_o_ && !stack.func_190926_b() && this.usesHoverChecker.checkHover(mouseX, mouseY)) {
            GuiUtils.drawHoveringText((MatrixStack)matrix, this.usesHoverChecker.getLines(), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        this.func_230459_a_(matrix, mouseX, mouseY);
        ClientUtils.renderModuleInfo(matrix, ModuleType.SMART, this.smartModule, this.noSmartModule, this.isSmart, this.field_147003_i + 5, this.field_147009_r + 5, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrix, (this.field_230708_k_ - this.field_146999_f) / 2, (this.field_230709_l_ - this.field_147000_g) / 2, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.isOwner && mouseX >= (double)(this.field_147003_i + this.signatureTextStartX) && mouseY >= (double)(this.field_147009_r + 23) && mouseX <= (double)(this.field_147003_i + this.signatureTextStartX + this.signatureTextLength) && mouseY <= (double)(this.field_147009_r + 43)) {
            this.changeSignature(this.signature + (int)Math.signum(delta));
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.isOwner) {
            this.te.setAcceptedLevels(this.acceptedLevels);
            this.te.setSignature(this.signature);
            SecurityCraft.channel.sendToServer((Object)new SyncKeycardSettings(this.te.func_174877_v(), this.acceptedLevels, this.signature, false));
        }
    }

    public void changeSignature(int newSignature) {
        boolean enableMinusButtons;
        if (this.isOwner) {
            this.signature = Math.max(0, Math.min(newSignature, Short.MAX_VALUE));
        }
        this.signatureText = new TranslationTextComponent("gui.securitycraft:keycard_reader.signature", new Object[]{StringUtils.leftPad((String)("" + this.signature), (int)5, (String)"0")});
        this.signatureTextLength = this.field_230712_o_.func_238414_a_((ITextProperties)this.signatureText);
        this.signatureTextStartX = this.field_146999_f / 2 - this.signatureTextLength / 2;
        boolean enablePlusButtons = this.isOwner && this.signature != Short.MAX_VALUE;
        this.minusThree.field_230693_o_ = enableMinusButtons = this.isOwner && this.signature != 0;
        this.minusTwo.field_230693_o_ = enableMinusButtons;
        this.minusOne.field_230693_o_ = enableMinusButtons;
        this.reset.field_230693_o_ = this.isOwner && this.signature != this.previousSignature;
        this.plusOne.field_230693_o_ = enablePlusButtons;
        this.plusTwo.field_230693_o_ = enablePlusButtons;
        this.plusThree.field_230693_o_ = enablePlusButtons;
    }

    public void changeLevelState(int i, boolean active) {
        if (this.isOwner) {
            this.toggleButtons[i].setCurrentIndex(active ? 1 : 0);
            this.acceptedLevels[i] = active;
        }
    }

    private /* synthetic */ void lambda$init$11(Button b) {
        boolean change = false;
        this.isExactLevel = !this.isExactLevel;
        for (int i = 0; i < 5; ++i) {
            if (change) {
                this.changeLevelState(i, !this.isExactLevel);
                continue;
            }
            change = this.acceptedLevels[i];
        }
        b.func_238482_a_(this.isExactLevel ? EQUALS : GREATER_THAN_EQUALS);
    }
}

