/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeypadTileEntity
extends DisguisableTileEntity
implements IPasswordProtected {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            KeypadTileEntity.this.field_145850_b.func_175656_a(KeypadTileEntity.this.field_174879_c, (BlockState)KeypadTileEntity.this.func_195044_w().func_206870_a((Property)KeypadBlock.POWERED, (Comparable)this.get()));
            KeypadTileEntity.this.field_145850_b.func_195593_d(KeypadTileEntity.this.field_174879_c, (Block)SCContent.KEYPAD.get());
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeypadTileEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);

    public KeypadTileEntity() {
        super(SCContent.teTypeKeypad);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.passcode = tag.func_74779_i("passcode");
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.func_195044_w().func_177230_c() instanceof KeypadBlock) {
            KeypadBlock.activate(this.field_145850_b, this.field_174879_c, (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeCheckPassword, windowId, KeypadTileEntity.this.field_145850_b, KeypadTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(((Block)SCContent.KEYPAD.get()).func_149739_a());
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeSetPassword, windowId, KeypadTileEntity.this.field_145850_b, KeypadTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(((Block)SCContent.KEYPAD.get()).func_149739_a());
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player) {
        if (!((Boolean)blockState.func_177229_b((Property)KeypadBlock.POWERED)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }
}

