/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.RequestTEOwnableUpdate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ReinforcedHopperTileEntity
extends LockableLootTileEntity
implements IHopper,
ITickableTileEntity,
IOwnable,
IModuleInventory {
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Owner owner = new Owner();
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int transferCooldown = -1;
    private long tickedGameTime;

    public ReinforcedHopperTileEntity() {
        super(SCContent.teTypeReinforcedHopper);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(tag)) {
            ItemStackHelper.func_191283_b((CompoundNBT)tag, this.inventory);
        }
        this.owner.setOwnerName(tag.func_74779_i("owner"));
        this.owner.setOwnerUUID(tag.func_74779_i("ownerUUID"));
        this.transferCooldown = tag.func_74762_e("TransferCooldown");
        this.modules = this.readModuleInventory(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.func_184282_c(tag)) {
            ItemStackHelper.func_191282_a((CompoundNBT)tag, this.inventory);
        }
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.getName());
            tag.func_74778_a("ownerUUID", this.owner.getUUID());
        }
        tag.func_74768_a("TransferCooldown", this.transferCooldown);
        this.writeModuleInventory(tag);
        return tag;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hopper");
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper(() -> ReinforcedHopperTileEntity.pullItems(this));
            }
        }
    }

    private boolean updateHopper(Supplier<Boolean> idk) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown() && ((Boolean)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176429_b)).booleanValue()) {
                boolean hasChanged = false;
                if (!this.isInventoryEmpty()) {
                    hasChanged = this.transferItemsOut();
                }
                if (!this.isFull()) {
                    hasChanged |= idk.get().booleanValue();
                }
                if (hasChanged) {
                    this.setTransferCooldown(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack stack : this.inventory) {
            if (!stack.func_190926_b() && stack.func_190916_E() == stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        if (this.insertHook()) {
            return true;
        }
        IInventory inv = this.getInventoryForHopperTransfer();
        if (inv != null) {
            Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a)).func_176734_d();
            if (this.isInventoryFull(inv, direction)) {
                return false;
            }
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                ItemStack copy = this.func_70301_a(i).func_77946_l();
                ItemStack remainder = ReinforcedHopperTileEntity.putStackInInventoryAllSlots((IInventory)this, inv, this.func_70298_a(i, 1), direction);
                if (remainder.func_190926_b()) {
                    inv.func_70296_d();
                    return true;
                }
                this.func_70299_a(i, copy);
            }
        }
        return false;
    }

    private static IntStream getSlotStreamForSide(IInventory inv, Direction dir) {
        return inv instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inv).func_180463_a(dir)) : IntStream.range(0, inv.func_70302_i_());
    }

    private boolean isInventoryFull(IInventory inventory, Direction side) {
        return ReinforcedHopperTileEntity.getSlotStreamForSide(inventory, side).allMatch(slot -> {
            ItemStack stack = inventory.func_70301_a(slot);
            return stack.func_190916_E() >= stack.func_77976_d();
        });
    }

    private static boolean isInventoryEmpty(IInventory inventory, Direction side) {
        return ReinforcedHopperTileEntity.getSlotStreamForSide(inventory, side).allMatch(slot -> inventory.func_70301_a(slot).func_190926_b());
    }

    public static boolean pullItems(IHopper hopper) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)hopper);
        if (ret != null) {
            return ret;
        }
        IInventory inv = ReinforcedHopperTileEntity.getSourceInventory(hopper);
        if (inv != null) {
            Direction direction = Direction.DOWN;
            return ReinforcedHopperTileEntity.isInventoryEmpty(inv, direction) ? false : ReinforcedHopperTileEntity.getSlotStreamForSide(inv, direction).anyMatch(slot -> ReinforcedHopperTileEntity.pullItemFromSlot(hopper, inv, slot, direction));
        }
        for (ItemEntity entity : ReinforcedHopperTileEntity.getCaptureItems(hopper)) {
            if (!ReinforcedHopperTileEntity.captureItem((IInventory)hopper, entity)) continue;
            return true;
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventory, int index, Direction direction) {
        ItemStack stack = inventory.func_70301_a(index);
        if (!stack.func_190926_b() && ReinforcedHopperTileEntity.canExtractItemFromSlot(inventory, stack, index, direction)) {
            ItemStack copy = stack.func_77946_l();
            ItemStack remainder = ReinforcedHopperTileEntity.putStackInInventoryAllSlots(inventory, (IInventory)hopper, inventory.func_70298_a(index, 1), null);
            if (remainder.func_190926_b()) {
                inventory.func_70296_d();
                return true;
            }
            inventory.func_70299_a(index, copy);
        }
        return false;
    }

    public static boolean captureItem(IInventory inv, ItemEntity entity) {
        boolean capturedEverything = false;
        ItemStack copy = entity.func_92059_d().func_77946_l();
        ItemStack remainder = ReinforcedHopperTileEntity.putStackInInventoryAllSlots(null, inv, copy, null);
        if (remainder.func_190926_b()) {
            capturedEverything = true;
            entity.func_70106_y();
        } else {
            entity.func_92058_a(remainder);
        }
        return capturedEverything;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory source, IInventory destination, ItemStack stack, Direction direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory inv = (ISidedInventory)destination;
            int[] slots = inv.func_180463_a(direction);
            for (int k = 0; k < slots.length && !stack.func_190926_b(); ++k) {
                stack = ReinforcedHopperTileEntity.insertStack(source, destination, stack, slots[k], direction);
            }
        } else {
            int destSize = destination.func_70302_i_();
            for (int j = 0; j < destSize && !stack.func_190926_b(); ++j) {
                stack = ReinforcedHopperTileEntity.insertStack(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventory, ItemStack stack, int index, Direction side) {
        if (!inventory.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180462_a(index, stack, side);
    }

    private static boolean canExtractItemFromSlot(IInventory inventory, ItemStack stack, int index, Direction side) {
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180461_b(index, stack, side);
    }

    private static ItemStack insertStack(IInventory source, IInventory destination, ItemStack stack, int index, Direction direction) {
        ItemStack destStack = destination.func_70301_a(index);
        if (ReinforcedHopperTileEntity.canInsertItemInSlot(destination, stack, index, direction)) {
            boolean hasChanged = false;
            boolean isDestEmpty = destination.func_191420_l();
            if (destStack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                hasChanged = true;
            } else if (ReinforcedHopperTileEntity.canCombine(destStack, stack)) {
                int sizeDifference = stack.func_77976_d() - destStack.func_190916_E();
                int minSize = Math.min(stack.func_190916_E(), sizeDifference);
                stack.func_190918_g(minSize);
                destStack.func_190917_f(minSize);
                boolean bl = hasChanged = minSize > 0;
            }
            if (hasChanged) {
                ReinforcedHopperTileEntity te;
                if (isDestEmpty && destination instanceof ReinforcedHopperTileEntity && !(te = (ReinforcedHopperTileEntity)destination).mayTransfer()) {
                    int k = 0;
                    if (source instanceof ReinforcedHopperTileEntity) {
                        ReinforcedHopperTileEntity te2 = (ReinforcedHopperTileEntity)source;
                        if (te.tickedGameTime >= te2.tickedGameTime) {
                            k = 1;
                        }
                    }
                    te.setTransferCooldown(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    @Nullable
    private IInventory getInventoryForHopperTransfer() {
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a);
        return ReinforcedHopperTileEntity.getInventoryAtPosition(this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
    }

    @Nullable
    public static IInventory getSourceInventory(IHopper hopper) {
        return ReinforcedHopperTileEntity.getInventoryAtPosition(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB() + 1.0, hopper.func_96108_aC());
    }

    public static List<ItemEntity> getCaptureItems(IHopper hopper) {
        return hopper.func_200100_i().func_197756_d().stream().flatMap(box -> hopper.func_145831_w().func_175647_a(ItemEntity.class, box.func_72317_d(hopper.func_96107_aA() - 0.5, hopper.func_96109_aB() - 0.5, hopper.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory getInventoryAtPosition(World world, BlockPos pos) {
        return ReinforcedHopperTileEntity.getInventoryAtPosition(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @Nullable
    public static IInventory getInventoryAtPosition(World world, double x, double y, double z) {
        List list;
        TileEntity te;
        ISidedInventory inv = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ISidedInventoryProvider) {
            inv = ((ISidedInventoryProvider)block).func_219966_a(state, (IWorld)world, pos);
        } else if (state.hasTileEntity() && (te = world.func_175625_s(pos)) instanceof IInventory && (inv = (IInventory)te) instanceof ChestTileEntity && block instanceof ChestBlock) {
            inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)state, (World)world, (BlockPos)pos, (boolean)true);
        }
        if (inv == null && !(list = world.func_175674_a(null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            inv = (IInventory)list.get(world.field_73012_v.nextInt(list.size()));
        }
        return inv;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> items) {
        this.inventory = items;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos pos = this.func_174877_v();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()))), (VoxelShape)this.func_200100_i(), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.updateHopper(() -> ReinforcedHopperTileEntity.captureItem((IInventory)this, (ItemEntity)entity));
            }
        }
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new HopperContainer(id, player, (IInventory)this);
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            SecurityCraft.channel.sendToServer((Object)new RequestTEOwnableUpdate(this.func_174877_v()));
        }
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.func_70301_a(slot);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    private boolean insertHook() {
        Direction hopperFacing = (Direction)this.func_195044_w().func_177229_b((Property)HopperBlock.field_176430_a);
        return this.getItemHandler(this, hopperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (this.isFull()) {
                return false;
            }
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                ItemStack originalSlotContents = this.func_70301_a(i).func_77946_l();
                ItemStack insertStack = this.func_70298_a(i, 1);
                ItemStack remainder = ReinforcedHopperTileEntity.putStackInInventoryAllSlots((TileEntity)this, destination, itemHandler, insertStack);
                if (remainder.func_190926_b()) {
                    return true;
                }
                this.func_70299_a(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private Optional<Pair<IItemHandler, Object>> getItemHandler(IHopper hopper, Direction hopperFacing) {
        double x = hopper.func_96107_aA() + (double)hopperFacing.func_82601_c();
        double y = hopper.func_96109_aB() + (double)hopperFacing.func_96559_d();
        double z = hopper.func_96108_aC() + (double)hopperFacing.func_82599_e();
        return VanillaInventoryCodeHooks.getItemHandler((World)hopper.func_145831_w(), (double)x, (double)y, (double)z, (Direction)hopperFacing.func_176734_d());
    }

    private static ItemStack putStackInInventoryAllSlots(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.func_190926_b(); ++slot) {
            stack = ReinforcedHopperTileEntity.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).func_190926_b()) {
            HopperTileEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = ReinforcedHopperTileEntity.isEmpty(destInventory);
            if (itemstack.func_190926_b()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.field_190927_a;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.func_190916_E();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).func_190916_E();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof HopperTileEntity && !(destinationHopper = (HopperTileEntity)destination).func_174914_o()) {
                destinationHopper.func_145896_c(8);
            }
        }
        return stack;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }
}

