/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCClientEventHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedSnowyDirtBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.models.BulletModel;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.models.IMSBombModel;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.EmptyRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemTileEntityRenderer;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcaseInventoryScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasswordScreen;
import net.geforcemods.securitycraft.screen.BriefcaseSetupScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasswordScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.IMSScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasswordScreen;
import net.geforcemods.securitycraft.screen.TrophySystemScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static final ModelLayerLocation BULLET_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "bullet"), "main");
    public static final ModelLayerLocation IMS_BOMB_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "ims_bomb"), "main");
    public static final ModelLayerLocation SENTRY_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "sentry"), "main");
    public static final ModelLayerLocation SECURITY_CAMERA_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "security_camera"), "main");

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        String[] facings = new String[]{"east", "north", "south", "west"};
        String[] bools = new String[]{"true", "false"};
        ResourceLocation[] facingPoweredBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "keycard_reader"), new ResourceLocation("securitycraft", "keypad"), new ResourceLocation("securitycraft", "retinal_scanner")};
        ResourceLocation[] facingBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "projector"), new ResourceLocation("securitycraft", "username_logger")};
        ResourceLocation[] poweredBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "laser_block")};
        String[] mines = new String[]{"coal_ore", "cobblestone", "diamond_ore", "dirt", "emerald_ore", "gravel", "gold_ore", "gilded_blackstone", "furnace", "iron_ore", "lapis_ore", "nether_gold_ore", "redstone_ore", "sand", "stone"};
        for (String facing : facings) {
            for (String string : bools) {
                for (ResourceLocation facingPoweredBlock : facingPoweredBlocks) {
                    ClientHandler.registerDisguisedModel(event, facingPoweredBlock, "facing=" + facing + ",powered=" + string);
                }
            }
            for (String string : facingBlocks) {
                ClientHandler.registerDisguisedModel(event, (ResourceLocation)string, "facing=" + facing);
            }
        }
        for (String bool : bools) {
            for (String string : poweredBlocks) {
                ClientHandler.registerDisguisedModel(event, (ResourceLocation)string, "powered=" + bool);
            }
        }
        ResourceLocation cageTrapRl = new ResourceLocation("securitycraft", "cage_trap");
        ResourceLocation invScanRL = new ResourceLocation("securitycraft", "inventory_scanner");
        ClientHandler.registerDisguisedModel(event, cageTrapRl, "deactivated=true");
        ClientHandler.registerDisguisedModel(event, cageTrapRl, "deactivated=false");
        for (String facing : facings) {
            ClientHandler.registerDisguisedModel(event, invScanRL, "facing=" + facing + ",horizontal=true");
            ClientHandler.registerDisguisedModel(event, invScanRL, "facing=" + facing + ",horizontal=false");
        }
        for (String mine : mines) {
            ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", mine.replace("_ore", "") + "_mine"), new ResourceLocation(mine));
        }
        ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerDisguisedModel(ModelBakeEvent event, ResourceLocation rl, String stateString) {
        ModelResourceLocation mrl = new ModelResourceLocation(rl, stateString);
        event.getModelRegistry().put(mrl, new DisguisableDynamicBakedModel(rl, (BakedModel)event.getModelRegistry().get(mrl)));
    }

    private static void registerBlockMineModel(ModelBakeEvent event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModelRegistry().put(mineMrl, new BlockMineModel((BakedModel)event.getModelRegistry().get(new ModelResourceLocation(realBlockRl, "inventory")), (BakedModel)event.getModelRegistry().get(mineMrl)));
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getMap().m_118330_().equals((Object)Sheets.f_110740_)) {
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_left"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_right"));
        }
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.m_110463_();
        RenderType cutoutMipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.BLOCK_POCKET_MANAGER.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.BLOCK_POCKET_WALL.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.CAGE_TRAP.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.INVENTORY_SCANNER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.INVENTORY_SCANNER_FIELD.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.KEYCARD_READER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.KEYPAD.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.KEYPAD_DOOR.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.LASER_BLOCK.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.LASER_FIELD.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_CHAIN.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_COBWEB.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_DOOR.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS_PANE.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRASS_BLOCK.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_HOPPER.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_ICE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_BARS.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_TRAPDOOR.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LANTERN.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_SOUL_LANTERN.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.RETINAL_SCANNER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.SCANNER_DOOR.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.TRACK_MINE.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.TROPHY_SYSTEM.get()), (RenderType)cutoutMipped);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.USERNAME_LOGGER.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCContent.PROJECTOR.get()), (RenderType)cutoutMipped);
        event.enqueueWork(() -> {
            MenuScreens.m_96206_(SCContent.mTypeBlockReinforcer, BlockReinforcerScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeBriefcase, BriefcasePasswordScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeBriefcaseInventory, BriefcaseInventoryScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeBriefcaseSetup, BriefcaseSetupScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeCustomizeBlock, CustomizeBlockScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeDisguiseModule, DisguiseModuleScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeInventoryScanner, InventoryScannerScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeKeypadFurnace, KeypadFurnaceScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeCheckPassword, CheckPasswordScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeSetPassword, SetPasswordScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeUsernameLogger, UsernameLoggerScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeIMS, IMSScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeKeycardReader, KeycardReaderScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeKeyChanger, KeyChangerScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeBlockPocketManager, BlockPocketManagerScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeProjector, ProjectorScreen::new);
            MenuScreens.m_96206_(SCContent.mTypeTrophySystem, TrophySystemScreen::new);
        });
        KeyBindings.init();
        OverlayRegistry.registerOverlayTop((String)"securitycraft:camera_overlay", SCClientEventHandler::cameraOverlay);
        OverlayRegistry.registerOverlayTop((String)"securitycraft:hotbar_bind_overlay", SCClientEventHandler::hotbarBindOverlay);
        ClientHandler.tint();
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(SCContent.eTypeBouncingBetty, BouncingBettyRenderer::new);
        event.registerEntityRenderer(SCContent.eTypeImsBomb, IMSBombRenderer::new);
        event.registerEntityRenderer(SCContent.eTypeSecurityCamera, EmptyRenderer::new);
        event.registerEntityRenderer(SCContent.eTypeSentry, SentryRenderer::new);
        event.registerEntityRenderer(SCContent.eTypeBullet, BulletRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeBlockPocketManager, BlockPocketManagerTileEntityRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeKeypadChest, KeypadChestTileEntityRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeRetinalScanner, RetinalScannerTileEntityRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeSecurityCamera, SecurityCameraTileEntityRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeSecretSign, SecretSignTileEntityRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeTrophySystem, TrophySystemTileEntityRenderer::new);
        event.registerBlockEntityRenderer(SCContent.beTypeProjector, ProjectorTileEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BULLET_LOCATION, BulletModel::createLayer);
        event.registerLayerDefinition(IMS_BOMB_LOCATION, IMSBombModel::createLayer);
        event.registerLayerDefinition(SENTRY_LOCATION, SentryModel::createLayer);
        event.registerLayerDefinition(SECURITY_CAMERA_LOCATION, SecurityCameraModel::createLayer);
    }

    private static void tint() {
        HashSet<Block> reinforcedTint = new HashSet<Block>();
        HashMap<Block, Integer> toTint = new HashMap<Block, Integer>();
        HashMap<Block, BlockColor> specialBlockTint = new HashMap<Block, BlockColor>();
        HashMap<Block, ItemColor> specialItemTint = new HashMap<Block, ItemColor>();
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class)) continue;
            try {
                if (field.getAnnotation(Reinforced.class).hasReinforcedTint()) {
                    reinforcedTint.add((Block)((RegistryObject)field.get(null)).get());
                }
                if (!field.getAnnotation(Reinforced.class).hasReinforcedTint() && field.getAnnotation(Reinforced.class).customTint() == 0xFFFFFF) continue;
                toTint.put((Block)((RegistryObject)field.get(null)).get(), field.getAnnotation(Reinforced.class).customTint());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        int noTint = 0xFFFFFF;
        int crystalQuartzTint = 1422242;
        toTint.put((Block)SCContent.BLOCK_POCKET_MANAGER.get(), crystalQuartzTint);
        reinforcedTint.add((Block)SCContent.BLOCK_POCKET_MANAGER.get());
        toTint.put((Block)SCContent.BLOCK_POCKET_WALL.get(), crystalQuartzTint);
        reinforcedTint.add((Block)SCContent.BLOCK_POCKET_WALL.get());
        toTint.put((Block)SCContent.CHISELED_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.put((Block)SCContent.CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.put((Block)SCContent.CRYSTAL_QUARTZ_PILLAR.get(), crystalQuartzTint);
        toTint.put((Block)SCContent.CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        toTint.put((Block)SCContent.STAIRS_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        specialBlockTint.put((Block)SCContent.REINFORCED_GRASS_BLOCK.get(), (state, world, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.m_61143_((Property)ReinforcedSnowyDirtBlock.f_56637_)).booleanValue()) {
                int grassTint = world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return noTint;
        });
        specialBlockTint.put((Block)SCContent.REINFORCED_WATER_CAULDRON.get(), (state, world, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return world != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos) : -1;
            }
            return noTint;
        });
        specialItemTint.put((Block)SCContent.REINFORCED_GRASS_BLOCK.get(), (stack, tintIndex) -> {
            if (tintIndex == 1) {
                int grassTint = GrassColor.m_46415_((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return noTint;
        });
        toTint.forEach((block, tint) -> Minecraft.m_91087_().m_91298_().m_92589_((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return reinforcedTint.contains(block) ? ClientHandler.mixWithReinforcedTintIfEnabled(tint) : tint;
            }
            if (specialBlockTint.containsKey(block)) {
                return ((BlockColor)specialBlockTint.get(block)).m_92566_(state, world, pos, tintIndex);
            }
            return noTint;
        }, new Block[]{block}));
        toTint.forEach((item, tint) -> Minecraft.m_91087_().getItemColors().m_92689_((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return reinforcedTint.contains(item) ? ClientHandler.mixWithReinforcedTintIfEnabled(tint) : tint;
            }
            if (specialItemTint.containsKey(item)) {
                return ((ItemColor)specialItemTint.get(item)).m_92671_(stack, tintIndex);
            }
            return noTint;
        }, new ItemLike[]{item}));
        Minecraft.m_91087_().m_91298_().m_92589_((state, world, pos, tintIndex) -> {
            DisguisableBlock disguisedBlock;
            Block blockFromItem;
            BlockState defaultBlockState;
            Block block = state.m_60734_();
            Block disguisedBlock$temp = block;
            if (disguisedBlock$temp instanceof DisguisableBlock && !(defaultBlockState = (blockFromItem = Block.m_49814_((Item)(disguisedBlock = (DisguisableBlock)disguisedBlock$temp).getDisguisedStack((BlockGetter)world, pos).m_41720_())).m_49966_()).m_60795_() && !(blockFromItem instanceof DisguisableBlock)) {
                return Minecraft.m_91087_().m_91298_().m_92577_(defaultBlockState, world, pos, tintIndex);
            }
            return noTint;
        }, new Block[]{(Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.USERNAME_LOGGER.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, tintIndex) -> {
            if (tintIndex == 0) {
                DyeableLeatherItem item = (DyeableLeatherItem)stack.m_41720_();
                if (item.m_41113_(stack)) {
                    return item.m_41121_(stack);
                }
                return 0x333333;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)SCContent.BRIEFCASE.get()});
    }

    private static int mixWithReinforcedTintIfEnabled(int tint1) {
        boolean tintReinforcedBlocks = (Boolean)ConfigHandler.SERVER.forceReinforcedBlockTint.get() != false ? (Boolean)ConfigHandler.SERVER.reinforcedBlockTint.get() : (Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get();
        return tintReinforcedBlocks ? ClientHandler.mixTints(tint1, 0x999999) : tint1;
    }

    private static int mixTints(int tint1, int tint2) {
        int red = tint1 >> 16 & 0xFF;
        int green = tint1 >> 8 & 0xFF;
        int blue = tint1 & 0xFF;
        red = (int)((float)red * ((float)(tint2 >> 16 & 0xFF) / 255.0f));
        green = (int)((float)green * ((float)(tint2 >> 8 & 0xFF) / 255.0f));
        blue = (int)((float)blue * ((float)(tint2 & 0xFF) / 255.0f));
        return ((red << 8) + green << 8) + blue;
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void displayMRATGui(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new MineRemoteAccessToolScreen(stack));
    }

    public static void displaySRATGui(ItemStack stack, int viewDistance) {
        Minecraft.m_91087_().m_91152_((Screen)new SentryRemoteAccessToolScreen(stack, viewDistance));
    }

    public static void displayEditModuleGui(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new EditModuleScreen(stack));
    }

    public static void displayCameraMonitorGui(Inventory inv, CameraMonitorItem item, CompoundTag stackTag) {
        Minecraft.m_91087_().m_91152_((Screen)new CameraMonitorScreen(inv, item, stackTag));
    }

    public static void displaySCManualGui() {
        Minecraft.m_91087_().m_91152_((Screen)new SCManualScreen());
    }

    public static void displayEditSecretSignGui(SecretSignBlockEntity te) {
        Minecraft.m_91087_().m_91152_((Screen)new SignEditScreen((SignBlockEntity)te, Minecraft.m_91087_().m_167974_()));
    }

    public static void refreshModelData(BlockEntity te) {
        BlockPos pos = te.m_58899_();
        ModelDataManager.requestModelDataRefresh((BlockEntity)te);
        Minecraft.m_91087_().f_91060_.m_109494_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }
}

