/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.SecurityCamera;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("textures/mob_effect/night_vision.png");
    private static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.f_42451_);

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCamera camera = (SecurityCamera)player.m_20202_();
            if (camera.screenshotSoundCooldown == 0) {
                camera.screenshotSoundCooldown = 7;
                Minecraft.m_91087_().f_91073_.m_104677_(player.m_142538_(), SCSounds.CAMERASNAP.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRendered(RenderPlayerEvent.Pre event) {
        LivingEntity e;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && PlayerUtils.isPlayerMountedOnCamera(e = (LivingEntity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91074_.m_20202_().m_142538_().equals((Object)event.getTarget().m_82425_())) {
            event.setCanceled(true);
        }
    }

    public static void cameraOverlay(ForgeIngameGui gui, PoseStack pose, float partialTicks, int width, int height) {
        ClientLevel level;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && (level = mc.f_91073_).m_8055_(player.m_20202_().m_142538_()).m_60734_() instanceof SecurityCameraBlock) {
            SCClientEventHandler.drawCameraOverlay(pose, mc, (GuiComponent)gui, mc.m_91268_(), (Player)player, (Level)level, player.m_20202_().m_142538_());
        }
    }

    public static void hotbarBindOverlay(ForgeIngameGui gui, PoseStack pose, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Level world = player.m_20193_();
        for (InteractionHand hand : InteractionHand.values()) {
            Entity hitEntity;
            int uCoord = 0;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == SCContent.CAMERA_MONITOR.get()) {
                double eyeHeight = player.m_20192_();
                Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * 5.0, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * 5.0, player.m_20189_() + player.m_20154_().f_82481_ * 5.0);
                mop = world.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                BlockHitResult blockHitResult = mop;
                if (blockHitResult instanceof BlockHitResult && world.m_7702_((bhr = blockHitResult).m_82425_()) instanceof SecurityCameraBlockEntity) {
                    cameras = stack.m_41783_();
                    uCoord = 110;
                    if (cameras != null) {
                        for (i = 1; i < 31; ++i) {
                            if (!cameras.m_128441_("Camera" + i) || Integer.parseInt((coords = cameras.m_128461_("Camera" + i).split(" "))[0]) != bhr.m_82425_().m_123341_() || Integer.parseInt(coords[1]) != bhr.m_82425_().m_123342_() || Integer.parseInt(coords[2]) != bhr.m_82425_().m_123343_()) continue;
                            uCoord = 88;
                            break;
                        }
                    }
                }
            } else if (stack.m_41720_() == SCContent.REMOTE_ACCESS_MINE.get()) {
                double eyeHeight = player.m_20192_();
                Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * 5.0, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * 5.0, player.m_20189_() + player.m_20154_().f_82481_ * 5.0);
                mop = world.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                cameras = mop;
                if (cameras instanceof BlockHitResult && world.m_8055_((bhr = cameras).m_82425_()).m_60734_() instanceof IExplosive) {
                    uCoord = 110;
                    CompoundTag mines = stack.m_41783_();
                    if (mines != null) {
                        for (i = 1; i <= 6; ++i) {
                            if (stack.m_41783_().m_128465_("mine" + i).length <= 0 || (coords = (Object[])mines.m_128465_("mine" + i))[0] != bhr.m_82425_().m_123341_() || coords[1] != bhr.m_82425_().m_123342_() || coords[2] != bhr.m_82425_().m_123343_()) continue;
                            uCoord = 88;
                            break;
                        }
                    }
                }
            } else if (stack.m_41720_() == SCContent.REMOTE_ACCESS_SENTRY.get() && (hitEntity = Minecraft.m_91087_().f_91076_) instanceof Sentry) {
                uCoord = 110;
                CompoundTag sentries = stack.m_41783_();
                if (sentries != null) {
                    for (int i = 1; i <= 12; ++i) {
                        int[] coords;
                        if (stack.m_41783_().m_128465_("sentry" + i).length <= 0 || (coords = sentries.m_128465_("sentry" + i))[0] != hitEntity.m_142538_().m_123341_() || coords[1] != hitEntity.m_142538_().m_123342_() || coords[2] != hitEntity.m_142538_().m_123343_()) continue;
                        uCoord = 88;
                        break;
                    }
                }
            }
            if (uCoord == 0) continue;
            RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
            GuiComponent.m_93133_((PoseStack)pose, (int)(Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 90 + (hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ * 20 : -29)), (int)(Minecraft.m_91087_().m_91268_().m_85446_() - 22), (float)uCoord, (float)219.0f, (int)21, (int)22, (int)256, (int)256);
        }
    }

    @SubscribeEvent
    public static void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setNewfov(((SecurityCamera)event.getEntity().m_20202_()).getZoomAmount());
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (Minecraft.m_91087_().f_91073_ != null && event.getButton() != 1 && Minecraft.m_91087_().f_91074_.f_36096_ == null && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91074_.m_150109_().m_36056_().m_41720_() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    private static void drawCameraOverlay(PoseStack matrix, Minecraft mc, GuiComponent gui, Window resolution, Player player, Level world, BlockPos pos) {
        Font font = Minecraft.m_91087_().f_91062_;
        Options settings = Minecraft.m_91087_().f_91066_;
        SecurityCameraBlockEntity te = (SecurityCameraBlockEntity)world.m_7702_(pos);
        boolean hasRedstoneModule = te.hasModule(ModuleType.REDSTONE);
        TranslatableComponent lookAround = Utils.localize("gui.securitycraft:camera.lookAround", settings.f_92085_.m_90863_(), settings.f_92086_.m_90863_(), settings.f_92087_.m_90863_(), settings.f_92088_.m_90863_());
        TranslatableComponent exit = Utils.localize("gui.securitycraft:camera.exit", settings.f_92090_.m_90863_());
        TranslatableComponent zoom = Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.m_90863_(), KeyBindings.cameraZoomOut.m_90863_());
        TranslatableComponent nightVision = Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.m_90863_());
        TranslatableComponent redstone = Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.m_90863_());
        TranslatableComponent redstoneNote = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
        String time = ClientUtils.getFormattedMinecraftTime();
        int timeY = 25;
        if (te.hasCustomSCName()) {
            Component cameraName = te.getCustomSCName();
            font.m_92763_(matrix, cameraName, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.m_92750_(matrix, time, (float)(resolution.m_85445_() - font.m_92895_(time) - 8), (float)timeY, 0xFFFFFF);
        font.m_92763_(matrix, (Component)lookAround, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)lookAround) - 8), (float)(resolution.m_85446_() - 80), 0xFFFFFF);
        font.m_92763_(matrix, (Component)exit, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)exit) - 8), (float)(resolution.m_85446_() - 70), 0xFFFFFF);
        font.m_92763_(matrix, (Component)zoom, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)zoom) - 8), (float)(resolution.m_85446_() - 60), 0xFFFFFF);
        font.m_92763_(matrix, (Component)nightVision, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)nightVision) - 8), (float)(resolution.m_85446_() - 50), 0xFFFFFF);
        font.m_92763_(matrix, (Component)redstone, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)redstone) - 8), (float)(resolution.m_85446_() - 40), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        font.m_92763_(matrix, (Component)redstoneNote, (float)(resolution.m_85445_() - font.m_92852_((FormattedText)redstoneNote) - 8), (float)(resolution.m_85446_() - 30), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        RenderSystem.m_157179_((int)0, (ResourceLocation)CAMERA_DASHBOARD);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_93228_(matrix, 5, 0, 0, 0, 90, 20);
        gui.m_93228_(matrix, resolution.m_85445_() - 55, 5, 205, 0, 50, 30);
        if (!player.m_21023_(MobEffects.f_19611_)) {
            gui.m_93228_(matrix, 28, 4, 90, 12, 16, 11);
        } else {
            RenderSystem.m_157179_((int)0, (ResourceLocation)NIGHT_VISION);
            GuiComponent.m_93133_((PoseStack)matrix, (int)27, (int)-1, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            RenderSystem.m_157179_((int)0, (ResourceLocation)CAMERA_DASHBOARD);
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60746_((BlockGetter)world, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0 && !te.hasModule(ModuleType.REDSTONE)) {
            gui.m_93228_(matrix, 12, 2, 104, 0, 12, 12);
        } else if (state.m_60746_((BlockGetter)world, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0 && te.hasModule(ModuleType.REDSTONE)) {
            gui.m_93228_(matrix, 12, 3, 90, 0, 12, 11);
        } else {
            Minecraft.m_91087_().m_91291_().m_115203_(REDSTONE, 10, 0);
        }
    }
}

