/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCarpetBlock;
import net.geforcemods.securitycraft.entity.SecurityCamera;
import net.geforcemods.securitycraft.entity.Sentry;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.geforcemods.securitycraft.network.client.SendTip;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    private static final String PREVIOUS_PLAYER_POS_NBT = "SecurityCraftPreviousPlayerPos";

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player.getPersistentData().m_128441_(PREVIOUS_PLAYER_POS_NBT)) {
            BlockPos pos = BlockPos.m_122022_((long)player.getPersistentData().m_128454_(PREVIOUS_PLAYER_POS_NBT));
            player.getPersistentData().m_128473_(PREVIOUS_PLAYER_POS_NBT);
            player.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SendTip());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            BlockPos pos = new BlockPos(((SecurityCamera)player.m_20202_()).getPreviousPlayerPos());
            player.m_20202_().m_6074_();
            player.getPersistentData().m_128356_(PREVIOUS_PLAYER_POS_NBT, pos.m_121878_());
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (event.getEntity() != null && PlayerUtils.isPlayerMountedOnCamera(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), SCSounds.ELECTRIFIED.path, 0.25, "blocks"));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        List sentries;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            return;
        }
        Level world = event.getWorld();
        if (!world.f_46443_) {
            INameable nameable;
            BlockEntity tileEntity = world.m_7702_(event.getPos());
            BlockState state = world.m_8055_(event.getPos());
            Block block = state.m_60734_();
            if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.KEY_PANEL, event.getHand())) {
                for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                    if (pc.getOriginalBlock() != block) continue;
                    event.setUseBlock(Event.Result.DENY);
                    event.setUseItem(Event.Result.ALLOW);
                }
                return;
            }
            if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.CODEBREAKER, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
                event.setCanceled(true);
                return;
            }
            BlockEntity pc = tileEntity;
            if (pc instanceof INameable && (nameable = (INameable)pc).canBeNamed() && PlayerUtils.isHoldingItem(event.getPlayer(), Items.f_42656_, event.getHand()) && event.getPlayer().m_21120_(event.getHand()).m_41788_()) {
                ItemStack nametag = event.getPlayer().m_21120_(event.getHand());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                if (nameable.getCustomSCName().equals(nametag.m_41786_())) {
                    PlayerUtils.sendMessageToPlayer(event.getPlayer(), (MutableComponent)new TranslatableComponent(tileEntity.m_58900_().m_60734_().m_7705_()), (MutableComponent)Utils.localize("messages.securitycraft:naming.alreadyMatches", nameable.getCustomSCName()), ChatFormatting.RED);
                    return;
                }
                if (!event.getPlayer().m_7500_()) {
                    nametag.m_41774_(1);
                }
                nameable.setCustomSCName(nametag.m_41786_());
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (MutableComponent)new TranslatableComponent(tileEntity.m_58900_().m_60734_().m_7705_()), (MutableComponent)Utils.localize("messages.securitycraft:naming.named", nameable.getCustomSCName()), ChatFormatting.RED);
                return;
            }
        }
        if (!(sentries = world.m_45976_(Sentry.class, new AABB(event.getPos()))).isEmpty()) {
            event.setCanceled(((Sentry)((Object)sentries.get(0))).m_6071_(event.getPlayer(), event.getHand()) == InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteracted(PlayerInteractEvent.EntityInteract event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        ItemStack disguiseModule;
        ArrayList<Block> blocks;
        List sentries;
        BlockEntity tile;
        BlockEntity blockEntity;
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (!level.m_5776_() && (blockEntity = (tile = level.m_7702_(event.getPos()))) instanceof IModuleInventory) {
            IModuleInventory te = (IModuleInventory)blockEntity;
            for (int i = 0; i < te.getMaxNumberOfModules(); ++i) {
                if (((ItemStack)te.getInventory().get(i)).m_41619_()) continue;
                ItemStack stack = (ItemStack)te.getInventory().get(i);
                ItemEntity item = new ItemEntity(level, (double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_(), stack);
                WorldUtils.addScheduledTask((LevelAccessor)level, () -> level.m_7967_((Entity)item));
                te.onModuleRemoved(stack, ((ModuleItem)stack.m_41720_()).getModuleType());
                IModuleInventory iModuleInventory = te;
                if (iModuleInventory instanceof CustomizableBlockEntity) {
                    CustomizableBlockEntity cte = (CustomizableBlockEntity)iModuleInventory;
                    cte.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, new Object[]{stack, ((ModuleItem)stack.m_41720_()).getModuleType()}, cte);
                }
                if (!((iModuleInventory = te) instanceof SecurityCameraBlockEntity)) continue;
                SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)iModuleInventory;
                level.m_46672_(cam.m_58899_().m_5484_((Direction)level.m_8055_(cam.m_58899_()).m_61143_((Property)SecurityCameraBlock.FACING), -1), level.m_8055_(cam.m_58899_()).m_60734_());
            }
        }
        if (!(sentries = ((Level)event.getWorld()).m_45976_(Sentry.class, new AABB(event.getPos()))).isEmpty() && !((Sentry)((Object)sentries.get(0))).getDisguiseModule().m_41619_() && (blocks = ((ModuleItem)(disguiseModule = ((Sentry)((Object)sentries.get(0))).getDisguiseModule()).m_41720_()).getBlockAddons(disguiseModule.m_41783_())).size() > 0 && blocks.get(0) == event.getWorld().m_8055_(event.getPos()).m_60734_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        BlockEntity te = event.getWorld().m_7702_(event.getPos());
        BlockEntity blockEntity = te;
        if (blockEntity instanceof IOwnable) {
            IOwnable ownable = (IOwnable)blockEntity;
            String name = event.getPlayer().m_7755_().getString();
            String uuid = event.getPlayer().m_36316_().getId().toString();
            ownable.setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        Player player;
        LivingEntity livingEntity = event.getTarget();
        if (livingEntity instanceof Player && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)(player = (Player)livingEntity)) || event.getTarget() instanceof Sentry) {
            ((Mob)event.getEntity()).m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block;
        Item held;
        if (event.getPlayer() != null && ((held = event.getPlayer().m_21205_().m_41720_()) == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) && (block = IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(event.getState().m_60734_())) != null) {
            event.setNewSpeed(10000.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof WitherBoss && event.getState().m_60734_() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof SecurityCamera) {
            SecurityCamera camera = (SecurityCamera)entity;
            entity = event.getEntityMounting();
            if (entity instanceof Player) {
                SecurityCameraBlockEntity te;
                BlockEntity blockEntity;
                Player player = (Player)entity;
                BlockEntity tile = event.getWorldObj().m_7702_(camera.m_142538_());
                if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && (blockEntity = tile) instanceof SecurityCameraBlockEntity && (te = (SecurityCameraBlockEntity)blockEntity).hasModule(ModuleType.SMART)) {
                    te.lastPitch = player.m_146909_();
                    te.lastYaw = player.m_146908_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer()) && event.getItemStack().m_41720_() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        BlockItem blockItem;
        Item item = event.getItemStack().m_41720_();
        Item item2 = item;
        if (item2 instanceof BlockItem && (blockItem = (BlockItem)item2).m_40614_() instanceof ReinforcedCarpetBlock) {
            event.setBurnTime(0);
        }
    }

    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        IPasswordProtected passwordProtected;
        Level world = event.getPlayer().f_19853_;
        BlockEntity tile = world.m_7702_(event.getPos());
        BlockEntity blockEntity = tile;
        if (blockEntity instanceof IPasswordProtected && (passwordProtected = (IPasswordProtected)blockEntity).isCodebreakable()) {
            if (((Boolean)ConfigHandler.SERVER.allowCodebreakerItem.get()).booleanValue()) {
                if (event.getPlayer().m_21120_(event.getHand()).m_41720_() == SCContent.CODEBREAKER.get()) {
                    event.getPlayer().m_21120_(event.getHand()).m_41622_(1, (LivingEntity)event.getPlayer(), p -> p.m_21190_(event.getHand()));
                }
                if (event.getPlayer().m_7500_() || new Random().nextInt(3) == 1) {
                    return passwordProtected.onCodebreakerUsed(world.m_8055_(event.getPos()), event.getPlayer());
                }
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (MutableComponent)new TranslatableComponent(((Item)SCContent.CODEBREAKER.get()).m_5524_()), (MutableComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                return true;
            }
            Block block = world.m_8055_(event.getPos()).m_60734_();
            PlayerUtils.sendMessageToPlayer(event.getPlayer(), (MutableComponent)Utils.localize(block.m_7705_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
        }
        return false;
    }
}

