/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.SecurityCraftBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CustomizableBlockEntity
extends SecurityCraftBlockEntity
implements IModuleInventory,
ICustomizable {
    private boolean linkable = false;
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private ListTag nbtTagStorage = null;
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);

    public CustomizableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state) {
        super.tick(world, pos, state);
        if (this.m_58898_() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        if (tag.m_128441_("linkable")) {
            this.linkable = tag.m_128471_("linkable");
        }
        if (this.linkable && tag.m_128441_("linkedBlocks")) {
            if (!this.m_58898_()) {
                this.nbtTagStorage = tag.m_128437_("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.m_128437_("linkedBlocks", 10));
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        tag.m_128379_("linkable", this.linkable);
        if (this.linkable && this.m_58898_() && this.linkedBlocks.size() > 0) {
            ListTag tagList = new ListTag();
            WorldUtils.addScheduledTask((LevelAccessor)this.f_58857_, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    CompoundTag toAppend = new CompoundTag();
                    if (block != null) {
                        if (!block.validate(this.f_58857_)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.m_128359_("blockName", block.blockName);
                        toAppend.m_128405_("blockX", block.getX());
                        toAppend.m_128405_("blockY", block.getY());
                        toAppend.m_128405_("blockZ", block.getZ());
                    }
                    tagList.add((Object)toAppend);
                }
                tag.m_128365_("linkedBlocks", (Tag)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(ListTag list) {
        if (!this.linkable) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String name = list.m_128728_(i).m_128461_("blockName");
            int x = list.m_128728_(i).m_128451_("blockX");
            int y = list.m_128728_(i).m_128451_("blockY");
            int z = list.m_128728_(i).m_128451_("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (this.m_58898_() && !block.validate(this.f_58857_)) {
                list.remove(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            CustomizableBlockEntity.link(this, block.asTileEntity(this.f_58857_));
        }
    }

    @Override
    public boolean hasCustomSCName() {
        return this.getCustomSCName() != null && !this.getCustomSCName().getString().equals("name");
    }

    @Override
    public void onTileEntityDestroyed() {
        if (this.linkable) {
            for (LinkedBlock block : this.linkedBlocks) {
                CustomizableBlockEntity.unlink(block.asTileEntity(this.f_58857_), this);
            }
        }
    }

    @Override
    public BlockEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleInserted(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, stack, this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        IModuleInventory.super.onModuleRemoved(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, stack, this);
    }

    public CustomizableBlockEntity linkable() {
        this.linkable = true;
        return this;
    }

    public boolean canBeLinkedWith() {
        return this.linkable;
    }

    public static void link(CustomizableBlockEntity tileEntity1, CustomizableBlockEntity tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        if (CustomizableBlockEntity.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(CustomizableBlockEntity tileEntity1, CustomizableBlockEntity tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(CustomizableBlockEntity tileEntity1, CustomizableBlockEntity tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return false;
        }
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, CustomizableBlockEntity excludedTE) {
        ArrayList<CustomizableBlockEntity> list = new ArrayList<CustomizableBlockEntity>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableBlockEntity> excludedTEs) {
        if (!this.linkable) {
            return;
        }
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.f_58857_))) continue;
            block.asTileEntity(this.f_58857_).onLinkedBlockAction(action, parameters, excludedTEs);
            block.asTileEntity(this.f_58857_).sync();
        }
    }

    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableBlockEntity> excludedTEs) {
    }
}

