/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IModuleInventory
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getInventory();

    public ModuleType[] acceptedModules();

    public BlockEntity getTileEntity();

    default public int getMaxNumberOfModules() {
        return this.acceptedModules().length;
    }

    default public void onModuleInserted(ItemStack stack, ModuleType module) {
        BlockEntity te = this.getTileEntity();
        if (!te.m_58904_().f_46443_) {
            te.m_58904_().m_7260_(te.m_58899_(), te.m_58900_(), te.m_58900_(), 3);
        }
    }

    default public void onModuleRemoved(ItemStack stack, ModuleType module) {
        BlockEntity te = this.getTileEntity();
        if (!te.m_58904_().f_46443_) {
            te.m_58904_().m_7260_(te.m_58899_(), te.m_58900_(), te.m_58900_(), 3);
        }
    }

    default public boolean enableHack() {
        return false;
    }

    default public int fixSlotId(int id) {
        return id >= 100 ? id - 100 : id;
    }

    default public int getSlots() {
        return this.acceptedModules().length;
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.getModuleInSlot(slot);
    }

    default public ItemStack getModuleInSlot(int slot) {
        return (slot = this.fixSlotId(slot)) < 0 || slot >= this.getSlots() ? ItemStack.f_41583_ : (ItemStack)this.getInventory().get(slot);
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getModuleInSlot(slot = this.fixSlotId(slot)).m_41777_();
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!simulate) {
            BlockEntity tile = this.getTileEntity();
            Item item = stack.m_41720_();
            if (item instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                this.onModuleRemoved(stack, module.getModuleType());
                BlockEntity blockEntity = tile;
                if (blockEntity instanceof CustomizableBlockEntity) {
                    CustomizableBlockEntity te = (CustomizableBlockEntity)blockEntity;
                    ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, stack, te);
                }
            }
            return ((ItemStack)this.getInventory().set(slot, (Object)ItemStack.f_41583_)).m_41777_();
        }
        return stack.m_41777_();
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).m_41619_()) {
            return stack;
        }
        int returnSize = 0;
        if (stack.m_41613_() > 1) {
            returnSize = stack.m_41613_() - 1;
        }
        if (!simulate) {
            ItemStack copy = stack.m_41777_();
            BlockEntity tile = this.getTileEntity();
            copy.m_41764_(1);
            this.getInventory().set(slot, (Object)copy);
            Item item = stack.m_41720_();
            if (item instanceof ModuleItem) {
                ModuleItem module = (ModuleItem)item;
                this.onModuleInserted(stack, module.getModuleType());
                BlockEntity blockEntity = tile;
                if (blockEntity instanceof CustomizableBlockEntity) {
                    CustomizableBlockEntity te = (CustomizableBlockEntity)blockEntity;
                    ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, copy, te);
                }
            }
        }
        if (returnSize != 0) {
            ItemStack toReturn = stack.m_41777_();
            toReturn.m_41764_(returnSize);
            return toReturn;
        }
        return ItemStack.f_41583_;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        BlockEntity blockEntity;
        slot = this.fixSlotId(slot);
        BlockEntity tile = this.getTileEntity();
        ItemStack previous = this.getModuleInSlot(slot);
        if (!previous.m_41619_()) {
            this.onModuleRemoved(previous, ((ModuleItem)previous.m_41720_()).getModuleType());
            blockEntity = tile;
            if (blockEntity instanceof CustomizableBlockEntity) {
                CustomizableBlockEntity te = (CustomizableBlockEntity)blockEntity;
                ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, previous, te);
            }
        }
        this.getInventory().set(slot, (Object)stack);
        blockEntity = stack.m_41720_();
        if (blockEntity instanceof ModuleItem) {
            ModuleItem module = (ModuleItem)blockEntity;
            this.onModuleInserted(stack, module.getModuleType());
            BlockEntity blockEntity2 = tile;
            if (blockEntity2 instanceof CustomizableBlockEntity) {
                CustomizableBlockEntity te = (CustomizableBlockEntity)blockEntity2;
                ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, stack, te);
            }
        }
    }

    default public int getSlotLimit(int slot) {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isItemValid(int slot, ItemStack stack) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).m_41619_()) return false;
        if (stack.m_41619_()) return false;
        Item item = stack.m_41720_();
        if (!(item instanceof ModuleItem)) return false;
        ModuleItem module = (ModuleItem)item;
        if (!this.getAcceptedModules().contains((Object)module.getModuleType())) return false;
        if (this.hasModule(module.getModuleType())) return false;
        return true;
    }

    default public ArrayList<ModuleType> getAcceptedModules() {
        ArrayList<ModuleType> list = new ArrayList<ModuleType>();
        for (ModuleType module : this.acceptedModules()) {
            list.add(module);
        }
        return list;
    }

    default public ArrayList<ModuleType> getInsertedModules() {
        ArrayList<ModuleType> modules = new ArrayList<ModuleType>();
        for (ItemStack stack : this.getInventory()) {
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ModuleItem)) continue;
            ModuleItem module = (ModuleItem)item;
            modules.add(module.getModuleType());
        }
        return modules;
    }

    default public ItemStack getModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleItem moduleItem;
            Item item;
            if (((ItemStack)modules.get(i)).m_41619_() || !((item = ((ItemStack)modules.get(i)).m_41720_()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
            return (ItemStack)modules.get(i);
        }
        return ItemStack.f_41583_;
    }

    default public void insertModule(ModuleType module) {
        int i;
        NonNullList<ItemStack> modules = this.getInventory();
        for (i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).m_41619_() || ((ItemStack)modules.get(i)).m_41720_() != module.getItem()) continue;
            return;
        }
        for (i = 0; i < modules.size(); ++i) {
            if (!((ItemStack)modules.get(i)).m_41619_() && module != null) {
                modules.set(i, (Object)new ItemStack((ItemLike)module.getItem()));
                break;
            }
            if (((ItemStack)modules.get(i)).m_41619_() || module != null) continue;
            modules.set(i, (Object)ItemStack.f_41583_);
        }
    }

    default public void insertModule(ItemStack module) {
        int i;
        if (module.m_41619_() || !(module.m_41720_() instanceof ModuleItem)) {
            return;
        }
        NonNullList<ItemStack> modules = this.getInventory();
        for (i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).m_41619_() || ((ItemStack)modules.get(i)).m_41720_() != module.m_41720_()) continue;
            return;
        }
        for (i = 0; i < modules.size(); ++i) {
            if (!((ItemStack)modules.get(i)).m_41619_()) continue;
            modules.set(i, (Object)module.m_41777_());
            break;
        }
    }

    default public void removeModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleItem moduleItem;
            Item item;
            if (((ItemStack)modules.get(i)).m_41619_() || !((item = ((ItemStack)modules.get(i)).m_41720_()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
            modules.set(i, (Object)ItemStack.f_41583_);
        }
    }

    default public boolean hasModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        if (module == null) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((ItemStack)modules.get(i)).m_41619_()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                ModuleItem moduleItem;
                Item item;
                if (((ItemStack)modules.get(i)).m_41619_() || !((item = ((ItemStack)modules.get(i)).m_41720_()) instanceof ModuleItem) || (moduleItem = (ModuleItem)item).getModuleType() != module) continue;
                return true;
            }
        }
        return false;
    }

    default public NonNullList<ItemStack> readModuleInventory(CompoundTag tag) {
        ListTag list = tag.m_128437_("Modules", 10);
        NonNullList modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.m_128728_(i);
            byte slot = stackTag.m_128445_("ModuleSlot");
            if (slot < 0 || slot >= modules.size()) continue;
            modules.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)stackTag));
        }
        return modules;
    }

    default public CompoundTag writeModuleInventory(CompoundTag tag) {
        ListTag list = new ListTag();
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128344_("ModuleSlot", (byte)i);
            ((ItemStack)modules.get(i)).m_41739_(stackTag);
            list.add((Object)stackTag);
        }
        tag.m_128365_("Modules", (Tag)list);
        return tag;
    }
}

