/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.ObjectHolder;

public class Owner {
    @ObjectHolder(value="securitycraft:owner")
    public static final DataSerializerEntry SERIALIZER = null;
    private String playerName = "owner";
    private String playerUUID = "ownerUUID";

    public Owner() {
    }

    public Owner(String playerName, String playerUUID) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null) continue;
            String uuid = ownable.getOwner().getUUID();
            String owner = ownable.getOwner().getName();
            if (uuid != null && !uuid.equals(this.playerUUID)) {
                return false;
            }
            if (owner == null || !uuid.equals("ownerUUID") || owner.equals("owner") || owner.equals(this.playerName)) continue;
            return false;
        }
        return true;
    }

    public boolean isOwner(Player player) {
        if (player == null) {
            return false;
        }
        String uuid = player.m_36316_().getId().toString();
        String owner = player.m_7755_().getString();
        if (uuid != null && uuid.equals(this.playerUUID)) {
            return true;
        }
        return owner != null && this.playerUUID.equals("ownerUUID") && owner.equals(this.playerName);
    }

    public void set(String uuid, String name) {
        this.playerName = name;
        this.playerUUID = uuid;
    }

    public void setOwnerName(String name) {
        this.playerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.playerUUID = uuid;
    }

    public String getName() {
        return this.playerName;
    }

    public String getUUID() {
        return this.playerUUID;
    }

    public String toString() {
        return "Name: " + this.playerName + "  UUID: " + this.playerUUID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Owner)) return false;
        Owner owner = (Owner)object;
        if (!this.getName().equals(owner.getName())) return false;
        if (!this.getUUID().equals(owner.getUUID())) return false;
        return true;
    }

    public static EntityDataSerializer<Owner> getSerializer() {
        return SERIALIZER.getSerializer();
    }
}

