/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SecurityCraftBlockEntity
extends OwnableBlockEntity
implements INameable,
ITickingBlockEntity {
    protected boolean intersectsEntities = false;
    protected boolean viewActivated = false;
    private boolean attacks = false;
    private boolean canBeNamed = false;
    private Component customName = new TextComponent("name");
    private double attackRange = 0.0;
    private int viewCooldown = 0;
    private int ticksBetweenAttacks = 0;
    private int attackCooldown = 0;
    private Class<? extends Entity> typeToAttack = Entity.class;

    public SecurityCraftBlockEntity(BlockPos pos, BlockState state) {
        this(SCContent.beTypeAbstract, pos, state);
    }

    public SecurityCraftBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level world, BlockPos pos, BlockState state) {
        List entities;
        AABB area;
        int z;
        int y;
        int x;
        if (this.intersectsEntities) {
            x = this.f_58858_.m_123341_();
            y = this.f_58858_.m_123342_();
            z = this.f_58858_.m_123343_();
            area = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            entities = world.m_45976_(Entity.class, area);
            for (Entity entity : entities) {
                SecurityCraftBlockEntity.entityIntersecting(world, pos, entity);
            }
        }
        if (this.viewActivated) {
            if (this.viewCooldown > 0) {
                --this.viewCooldown;
                return;
            }
            x = this.f_58858_.m_123341_();
            y = this.f_58858_.m_123342_();
            z = this.f_58858_.m_123343_();
            area = new AABB((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).m_82400_(5.0);
            entities = world.m_6443_(LivingEntity.class, area, e -> !(e instanceof Player) || !e.m_5833_());
            for (Entity entity : entities) {
                double eyeHeight = entity.m_20192_();
                boolean isPlayer = entity instanceof Player;
                Vec3 lookVec = new Vec3(entity.m_20185_() + entity.m_20154_().f_82479_ * 5.0, eyeHeight + entity.m_20186_() + entity.m_20154_().f_82480_ * 5.0, entity.m_20189_() + entity.m_20154_().f_82481_ * 5.0);
                BlockHitResult mop = world.m_45547_(new ClipContext(new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_()), lookVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
                if (mop == null || mop.m_82425_().m_123341_() != pos.m_123341_() || mop.m_82425_().m_123342_() != pos.m_123342_() || mop.m_82425_().m_123343_() != pos.m_123343_() || (!isPlayer || !this.activatedOnlyByPlayer()) && this.activatedOnlyByPlayer()) continue;
                this.entityViewed((LivingEntity)entity);
                this.viewCooldown = this.getViewCooldown();
            }
        }
        if (this.attacks) {
            if (this.attackCooldown < this.getTicksBetweenAttacks()) {
                ++this.attackCooldown;
                return;
            }
            if (this.canAttack()) {
                AABB area2 = new AABB(pos).m_82400_(this.getAttackRange());
                List entities2 = world.m_45976_(this.entityTypeToAttack(), area2);
                Iterator iterator = entities2.iterator();
                if (!world.f_46443_) {
                    boolean attacked = false;
                    if (!iterator.hasNext()) {
                        this.attackFailed();
                    }
                    while (iterator.hasNext()) {
                        Entity mobToAttack = (Entity)iterator.next();
                        if (mobToAttack == null || mobToAttack instanceof ItemEntity || !this.shouldAttackEntityType(mobToAttack) || !this.attackEntity(mobToAttack)) continue;
                        attacked = true;
                    }
                    if (attacked || this.shouldRefreshAttackCooldown()) {
                        this.attackCooldown = 0;
                    }
                    if (attacked || this.shouldSyncToClient()) {
                        this.sync();
                    }
                }
            }
        }
    }

    private static void entityIntersecting(Level world, BlockPos pos, Entity entity) {
        Block block = world.m_8055_(pos).m_60734_();
        if (!(block instanceof IIntersectable)) {
            return;
        }
        IIntersectable intersectable = (IIntersectable)block;
        intersectable.onEntityIntersected(world, pos, entity);
    }

    public void entityViewed(LivingEntity entity) {
    }

    public boolean attackEntity(Entity entity) {
        return false;
    }

    public void attackFailed() {
    }

    public boolean canAttack() {
        return false;
    }

    public boolean shouldAttackEntityType(Entity entity) {
        return entity instanceof Player || this.typeToAttack.isAssignableFrom(entity.getClass());
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        tag.m_128379_("intersectsEntities", this.intersectsEntities);
        tag.m_128379_("viewActivated", this.viewActivated);
        tag.m_128379_("attacks", this.attacks);
        tag.m_128379_("canBeNamed", this.canBeNamed);
        tag.m_128347_("attackRange", this.attackRange);
        tag.m_128405_("attackCooldown", this.attackCooldown);
        tag.m_128405_("ticksBetweenAttacks", this.ticksBetweenAttacks);
        tag.m_128359_("customName", this.customName.getString());
        return tag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("intersectsEntities")) {
            this.intersectsEntities = tag.m_128471_("intersectsEntities");
        }
        if (tag.m_128441_("viewActivated")) {
            this.viewActivated = tag.m_128471_("viewActivated");
        }
        if (tag.m_128441_("attacks")) {
            this.attacks = tag.m_128471_("attacks");
        }
        if (tag.m_128441_("canBeNamed")) {
            this.canBeNamed = tag.m_128471_("canBeNamed");
        }
        if (tag.m_128441_("attackRange")) {
            this.attackRange = tag.m_128459_("attackRange");
        }
        if (tag.m_128441_("attackCooldown")) {
            this.attackCooldown = tag.m_128451_("attackCooldown");
        }
        if (tag.m_128441_("ticksBetweenAttacks")) {
            this.ticksBetweenAttacks = tag.m_128451_("ticksBetweenAttacks");
        }
        if (tag.m_128441_("customName")) {
            this.customName = new TextComponent(tag.m_128461_("customName"));
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.onTileEntityDestroyed();
    }

    public void onTileEntityDestroyed() {
    }

    public void sync() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public SecurityCraftBlockEntity intersectsEntities() {
        this.intersectsEntities = true;
        return this;
    }

    public boolean doesIntersectsEntities() {
        return this.intersectsEntities;
    }

    public SecurityCraftBlockEntity activatedByView() {
        this.viewActivated = true;
        return this;
    }

    public int getViewCooldown() {
        return 0;
    }

    public boolean activatedOnlyByPlayer() {
        return true;
    }

    public boolean isActivatedByView() {
        return this.viewActivated;
    }

    public SecurityCraftBlockEntity attacks(Class<? extends Entity> type, double range, int cooldown) {
        this.attacks = true;
        this.typeToAttack = type;
        this.attackRange = range;
        this.ticksBetweenAttacks = cooldown;
        return this;
    }

    public Class<? extends Entity> entityTypeToAttack() {
        return this.typeToAttack;
    }

    public double getAttackRange() {
        return this.attackRange;
    }

    public int getTicksBetweenAttacks() {
        return this.ticksBetweenAttacks;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public void attackNextTick() {
        this.attackCooldown = this.ticksBetweenAttacks;
    }

    public boolean shouldRefreshAttackCooldown() {
        return true;
    }

    public boolean shouldSyncToClient() {
        return true;
    }

    public boolean doesAttack() {
        return this.attacks;
    }

    public SecurityCraftBlockEntity nameable() {
        this.canBeNamed = true;
        return this;
    }

    @Override
    public Component getCustomSCName() {
        return this.customName;
    }

    @Override
    public void setCustomSCName(Component customName) {
        this.customName = customName;
        this.sync();
    }

    @Override
    public boolean hasCustomSCName() {
        return this.customName != null && !this.customName.getString().equals("name");
    }

    @Override
    public boolean canBeNamed() {
        return this.canBeNamed;
    }
}

